/******************************************************************************
 *
 *    pfsd_iseof.c,v : Check for end of file
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : pfsd_iseof.c,v
 *  RCS Date     : 1995/11/23 17:43:09
 *  RCS Revision : 1.6
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef lint
static char rcs_id[] = "pfsd_iseof.c,v 1.6 1995/11/23 17:43:09 lamberts Rel";
#endif


#include <rpc/rpc.h>
#include <errno.h>

#include "pfsd.h"
#include "pfsd_defines.h"
#include "pfsd_macros.h"
#include "pfslib_errno.h"

extern filetabel *_cftbl;

extern int _checkfh
#ifdef ANSI_C
(pfslib_fhdl fh, struct svc_req *rqstp);
#else
();
#endif /* ANSI_C */


/* ************************************************************************ */
/* pfsd_iseof_1(): this is the true rpc function which is called        */
/* ************************************************************************ */

iseofres *pfsd_iseof_1
#ifdef ANSI_C
(pfslib_fhdl *argp, struct svc_req *rqstp)
#else
(argp, rqstp)
pfslib_fhdl *argp;
struct svc_req *rqstp;
#endif /* ANSI_C */
{

	static iseofres result;

  int _ftix = argp->vfd;        /* File table index */
  int _ctix = argp->which;      /* Client table index */
  
  off_t curpos;

  /*
	xdr_free(xdr_iseofres, (char *)&result);
  */

	/*
	 * check pfslib_fhdl     
	 */

	if (_checkfh(*argp,rqstp) < 0 )
	{
    ERR_MACRO(iseofres_u,errno);
    return (&result);
	}

	/* This call is never synchronizing */

	/*
	 * compare the position of client fp with the filelength
	 */

  /* LAMBO warte auf beendigung aller asynchronen io operations */

  switch (_MODE)
  {
  case M_UNIX:
  case M_RECORD:
    curpos = _CLNT.foffs;       /* own offsets */
    break;
  case M_LOG:
  case M_SYNC:
  case M_GLOBAL:
    curpos = _CFTE.shoffs;      /* shared offsets */
    break;
  default:
    /* LAMBO Fehler */
    break;
  }
  
	result.stat = RPC_OK;

	if (_CFTE.endoffs == curpos)
		result.iseofres_u.eof = TRUE;
	else
		result.iseofres_u.eof = FALSE;


	return(&result);
}
