/******************************************************************************
 *
 *    pfsd_iowait.c,v : wait for completion fo an IO operations
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : pfsd_iowait.c,v
 *  RCS Date     : 1995/11/23 17:43:08
 *  RCS Revision : 1.6
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef lint
static char rcs_id[] = "pfsd_iowait.c,v 1.6 1995/11/23 17:43:08 lamberts Rel";
#endif


#include <rpc/rpc.h>
#include <errno.h>

#include "pfsd.h"
#include "pfsd_defines.h"
#include "pfsd_macros.h"
#include "pfslib_errno.h"

extern filetabel *_cftbl;

extern int _checkfh
#ifdef ANSI_C
(pfslib_fhdl fh, struct svc_req *rqstp);
#else
();
#endif /* ANSI_C */


/* ************************************************************************ */
/* iowait_msync(): request for iowait() is a synchronising call             */
/* ************************************************************************ */

/* _ftix must be set correctly */
void _iowait_reply
#ifdef ANSI_C
(int _ftix, int _ctix, int _ioID)
#else
(_ftix,_ctix,_ioID)
int _ftix;
int _ctix;
int _ioID;
#endif /* ANSI_C */
{
  static iowaitres  result;
  
  /*
  xdr_free(xdr_iowaitres, (char *)&result);
  */

  result.stat = RPC_OK;
  
  _IOID.state = ID_UNUSED;

  if (!svc_sendreply(_CLNT.transp, xdr_iowaitres, (char *)&result))
  {
    svcerr_systemerr(_CLNT.transp);
  }
  
  return;
}




/* ************************************************************************ */
/* pfsd_iowait_1(): the rpc procedure called                           */
/* ************************************************************************ */

iowaitres *pfsd_iowait_1
#ifdef ANSI_C
(ioidstatargs *argp, struct svc_req *rqstp)
#else
(argp, rqstp)
ioidstatargs *argp;
struct svc_req *rqstp;
#endif /* ANSI_C */
{

  static iowaitres  result;

  int _ftix = argp->fh.vfd;     /* File table index */
  int _ctix = argp->fh.which;   /* Client table index */
  int _ioID = argp->ioID;       /* Id table index */

  /*
  xdr_free(xdr_iowaitres, (char *)&result);
  */

  /*
   * check pfslib_fhdl     
   */

  if (_checkfh(argp->fh,rqstp) < 0 )
  {
    ERR_MACRO(iowaitres_u, errno);
    return (&result);
  }

  /*
   * check the rest of the input arguments
   */

  if ((_ioID < 0) || ( _ioID >= MAXIOID ) ||
      (_IOID.state == ID_UNUSED))
  {
    ERR_MACRO(iowaitres_u, EPFSLBADID);
    return (&result);
  }

  /* Set transport handle */
  _CLNT.transp = rqstp->rq_xprt;
    
  if ((_IOID.state != ID_DONE) && (_IOID.state != ID_FAILED))
    _IOID.iowait = TRUE;
  else
    /* OK send an successful reply */
    _iowait_reply(_ftix, _ctix, _ioID);

  /* Reply sent by _iowait_reply() or must be delayed */
  return((iowaitres *)0);
}
