/******************************************************************************
 *
 *    pfsd_ioop.c,v : I/O operations
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : pfsd_ioop.c,v
 *  RCS Date     : 1995/11/23 17:43:06
 *  RCS Revision : 1.8
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef lint
static char rcs_id[] = "pfsd_ioop.c,v 1.8 1995/11/23 17:43:06 lamberts Rel";
#endif

#include <rpc/rpc.h>
#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include "pfsd.h"
#include "pfsd_defines.h"
#include "pfsd_macros.h"
#include "pfslib_errno.h"

extern filetabel *_cftbl;

extern int _checkfh
#ifdef ANSI_C
(pfslib_fhdl fh, struct svc_req *rqstp);
#else
();
#endif /* ANSI_C */


void _ioop_reply
#ifdef ANSI_C
(int _ftix, int _ctix, int _ioID, char *wrbuf)
#else
(_ftix,_ctix,_ioID,wrbuf)
int _ftix;
int _ctix;
int _ioID;
char *wrbuf;
#endif /* ANSI_C */
{
  static ioopres result;
  static char rdbuf[MAXDATALEN];
  int iolenres;
  
  /*
  xdr_free(xdr_ioopres, (char *)&result);
  */

  if (_IOID.iolen == 0)
  {
    result.stat = RPC_OK;
    result.ioopres_u.res.iolen = 0;
    result.ioopres_u.res.data.pfslib_data_val = "";
    result.ioopres_u.res.data.pfslib_data_len = 0;

    _IOID.state = ID_DONE;
  }
  else
  {
    if (lseek(_RFDC, _IOID.offset, SEEK_SET) != _IOID.offset)
    {
      fprintf(stderr,"lseek() to wrong location");
      result.stat = RPC_ERR;
    }
    
    else if (_IOID.iolen > MAXDATALEN)
    {
      errno = ENOSYS;
      perror("_ioop_reply(): iolen too long");
      result.stat = RPC_ERR;
    }

    else switch (_IOID.op)
    {
    case WRITE_OP:
    case WRITEV_OP:

      if ((iolenres = write(_RFDC,wrbuf,_IOID.iolen)) < 0)
        result.stat = RPC_ERR;

      else
      {
        result.stat = RPC_OK;
        result.ioopres_u.res.data.pfslib_data_val = "";
        result.ioopres_u.res.data.pfslib_data_len = 0;
        result.ioopres_u.res.iolen = iolenres;
        _IOID.state = ID_DONE;
      }
      break;

    case READ_OP:
    case READV_OP:
      if ((iolenres = read(_RFDC,rdbuf,_IOID.iolen)) < 0)
        result.stat = RPC_ERR;

      else
      {
        result.stat = RPC_OK;
        result.ioopres_u.res.data.pfslib_data_val = rdbuf;
        result.ioopres_u.res.data.pfslib_data_len = iolenres;
        result.ioopres_u.res.iolen = iolenres;
        _IOID.state = ID_DONE;
      }
      break;
    default:
      /* LAMBO Fehler */
      break;
    }
  }
  
  if (result.stat == RPC_ERR)
  {
    ERR_MACRO(ioopres_u, errno);
    _IOID.errno = errno;
    _IOID.state = ID_FAILED;
  }
  
  if (!svc_sendreply(_IOID.transp, xdr_ioopres, (char *)&result))
  {
    svcerr_systemerr(_IOID.transp);
  }

  return;
}





ioopres *pfsd_ioop_1
#ifdef ANSI_C
(ioopargs *argp, struct svc_req *rqstp)
#else
(argp, rqstp)
ioopargs *argp;
struct svc_req *rqstp;
#endif /* ANSI_C */
{
  static ioopres result;

  int _ftix = argp->fh.vfd;     /* File table index */
  int _ctix = argp->fh.which;   /* Client table index */
  int _ioID = argp->ioID;       /* Id table index */

  /*
  xdr_free(xdr_ioopres, (char *)&result);
  */

	/*
	 * check pfslib_fhdl     
	 */

	if (_checkfh(argp->fh,rqstp) < 0)
	{
    ERR_MACRO(ioopres_u, errno);
    return (&result);
	}

	/*
	 * check the rest of the input arguments
	 */

	if ((_ioID < 0) || (_ioID >= MAXIOID) ||
      ((_IOID.state != ID_SYNC) && (_IOID.state != ID_SYNCDO)) ||
      (_IOID.op != argp->op) || (_IOID.iolen != argp->iolen))
	{
    ERR_MACRO(ioopres_u, EPFSLBADID);
    return (&result);
	}

  if ((argp->iolen > MAXDATALEN) &&
      (argp->iolen != argp->data.pfslib_data_len))
  {
    ERR_MACRO(ioopres_u, EPFSLIOLEN);
    return (&result);
  }
  
  
  _IOID.transp = rqstp->rq_xprt;

  if (_IOID.state == ID_SYNC)
  {
    _IOID.state = ID_SYNCPENDING;

    /* Copy data for later use */
    if (((_IOID.op == WRITE_OP) || (_IOID.op == WRITEV_OP)) &&
        (_IOID.iolen <= MAXDATALEN) && (_IOID.iolen > (unsigned int)0))
    {
      if ((_IOID.data = malloc(_IOID.iolen)) == (char *)0)
      {
        ERR_MACRO(ioopres_u, errno);
        return (&result);
      }
      memcpy(_IOID.data,argp->data.pfslib_data_val,_IOID.iolen);
    }

    /* Delay reply */
    return ((ioopres *)0);
  }

  _ioop_reply(_ftix, _ctix, _ioID, argp->data.pfslib_data_val);
  
  return ((ioopres *)0);
}
  
