/******************************************************************************
 *
 *    pfsd_iodrpc.c,v : Communication to iod
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : pfsd_iodrpc.c,v
 *  RCS Date     : 1995/11/30 16:23:33
 *  RCS Revision : 1.12
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef lint
static char rcs_id[] = "pfsd_iodrpc.c,v 1.12 1995/11/30 16:23:33 lamberts Rel";
#endif

#include <rpc/rpc.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/tcp.h>
#include <stdio.h>
#include <errno.h>
#include <stdlib.h>

#include "iod.h"
#include "pfsd_defines.h"
#include "pfsd_macros.h"
#include "pfslib_errno.h"


extern filetabel *_cftbl;

CLIENT *_clntiod_create 
#ifdef ANSI_C
(int *sockp, struct sockaddr_in *addr)
#else
(sockp, addr)
int *sockp;
struct sockaddr_in *addr;
#endif /* ANSI_C */
{
  CLIENT * clnt;

  int sooptarg;
  
	if ((clnt = clnttcp_create(addr, IOD, IOD_VERS,
                             sockp, RPC_IOD_BUFSZ, RPC_IOD_BUFSZ))  == NULL)
	{
		clnt_pcreateerror("_clntiod_create(): clnttcp_create()");
    return ((CLIENT *)0);
	}

  /* Set REUSEADDR */
  sooptarg = 1;
  setsockopt(*sockp,SOL_SOCKET,SO_REUSEADDR,(char *)&sooptarg,
             sizeof(sooptarg));
  /* TCP_NODELAY */
  sooptarg = 1;
  setsockopt(*sockp,IPPROTO_TCP,TCP_NODELAY,(char *)&sooptarg,sizeof(sooptarg));

	auth_destroy(clnt->cl_auth);
	clnt->cl_auth = authunix_create_default();

  return(clnt);
}


void _send_iod_exit
#ifdef ANSI_C
(CLIENT *clnt)
#else
(clnt)
CLIENT *clnt;
#endif /* ANSI_C */
{
  char args;

  if (iod_exit_1(&args,clnt) == NULL)
  {
    clnt_perror(clnt,"iod_exit_1()");
  }
  return;
}


void _prt_iod_stat
#ifdef ANSI_C
(char *filename, CLIENT *clnt)
#else
(filename, clnt)
char *filename;
CLIENT *clnt;
#endif /* ANSI_C */
{
  iod_prtstatargs args;

  args.filename = filename;

  if (iod_prtstat_1(&args,clnt) == NULL)
  {
    clnt_perror(clnt,"iod_prtstat_1()");
  }
  
  return;
}


int _send_iod_request
#ifdef ANSI_C
(int _ftix, int _ctix, int _ioID)
#else
(_ftix,_ctix,_ioID)
int _ftix;
int _ctix;
int _ioID;
#endif /* ANSI_C */
{
  iod_reqargs args;

  char dhb[RPC_IOD_BUFSZ];

  if (_IOID.iod->clnt == (CLIENT *)0)
  {
    errno = EPFSLNOTIOD;
    return (-1);
  }
  

  args.op     = _IOID.op;
  args.fh.vfd = _ftix;
  args.fh.which = _ctix;
  args.fh.how_many = _CFTE.how_many;
  args.fh.mode = _CFTE.mode;
  args.mixio  = _IOID.mixio;
  args.fn     = _CFTE.filename;
  args.oflags = _CFTE.oflags;
  args.foffs  = (u_int)_IOID.offset;
  args.iolen  = _IOID.iolen;
  args.ioID   = _ioID;

  args.hname    = _CLNT.ident.hname;
  args.uid      = _CLNT.ident.uid;
  args.gid      = _CLNT.ident.gid;
  args.aup_time = _CLNT.ident.aup_time;

  /* Append some additional data to force sending of RPC request */
  args.dhb.pfslib_data_val = dhb;
  args.dhb.pfslib_data_len = RPC_IOD_BUFSZ;
  
  if (iod_request_1(&args,_IOID.iod->clnt) == NULL)
  {
    clnt_perror(_IOID.iod->clnt,"_send_rdrequest(): ioproc_iorequest_1()");
    
    return (-1);
  }
  /* RPC won't send reply */
  
  return (0);
}


