/******************************************************************************
 *
 *    pfsd_iodone.c,v : get the status of an io id
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : pfsd_iodone.c,v
 *  RCS Date     : 1995/11/23 17:43:05
 *  RCS Revision : 1.6
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef lint
static char rcs_id[] = "pfsd_iodone.c,v 1.6 1995/11/23 17:43:05 lamberts Rel";
#endif


#include <rpc/rpc.h>
#include <errno.h>

#include "pfsd.h"
#include "pfsd_defines.h"
#include "pfsd_macros.h"
#include "pfslib_errno.h"

extern filetabel *_cftbl;

extern int _checkfh
#ifdef ANSI_C
(pfslib_fhdl fh, struct svc_req *rqstp);
#else
();
#endif /* ANSI_C */



/* ************************************************************************ */
/* pfsd_ioidstat_1(): the rpc procedure called                              */
/* ************************************************************************ */

iodoneres *pfsd_iodone_1
#ifdef ANSI_C
(ioidstatargs *argp, struct svc_req *rqstp)
#else
(argp, rqstp)
ioidstatargs *argp;
struct svc_req *rqstp;
#endif /* ANSI_C */
{

  static iodoneres  result;

  int _ftix = argp->fh.vfd;     /* File table index */
  int _ctix = argp->fh.which;   /* Client table index */
  int _ioID = argp->ioID;       /* Id table index */

  /*
  xdr_free(xdr_iodoneres, (char *)&result);
  */

  /*
   * check pfslib_fhdl     
   */

  if (_checkfh(argp->fh,rqstp) < 0 )
  {
    ERR_MACRO(iodoneres_u, errno);
    return (&result);
  }

  /*
   * check the rest of the input arguments
   */

  if ((_ioID < 0) || ( _ioID >= MAXIOID ) || 
      (_IOID.state == ID_UNUSED))
  {
    ERR_MACRO(iodoneres_u, EPFSLBADID);
    return(&result);
  }


  /* LAMBO iodone sollte nie synchronisieren  */

  result.stat = RPC_OK;
  
  if ((_IOID.state != ID_DONE) && (_IOID.state != ID_FAILED))
  {
    /* The ioop is not complete */
    result.iodoneres_u.done = FALSE;

    return (&result);
  }
  
  /* The ioop is complete */
  result.iodoneres_u.done = TRUE;

  _IOID.state = ID_UNUSED;

  return (&result);
}
