/******************************************************************************
 *
 *    pfsd_iod.c,v : iod administration
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : pfsd_iod.c,v
 *  RCS Date     : 1995/11/30 16:23:31
 *  RCS Revision : 1.12
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef lint
static char rcs_id[] = "pfsd_iod.c,v 1.12 1995/11/30 16:23:31 lamberts Rel";
#endif


#include <rpc/rpc.h>
#include <sys/types.h>
#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>

#include "pfsd.h"
#include "pfsd_defines.h"
#include "pfsd_macros.h"
#include "pfslib_errno.h"



extern filetabel *_cftbl;

extern void _iowait_reply
#ifdef ANSI_C
(int _ftix, int _ctix, int _ioID);
#else
();
#endif /* ANSI_C */

extern CLIENT *_clntiod_create 
#ifdef ANSI_C
(int *sockp, struct sockaddr_in *addr);
#else
();
#endif /* ANSI_C */

extern void _prt_iod_stat
#ifdef ANSI_C
(char *filename, CLIENT *clnt);
#else
();
#endif /* ANSI_C */

extern void _send_iod_exit
#ifdef ANSI_C
(CLIENT *clnt);
#else
();
#endif /* ANSI_C */


static IOD_LISTEL iodt[MAXNUMIOD];

static int curriod = 0;


void prt_iodtab
#ifdef ANSI_C
(char *filename, bool_t verbose)
#else
(filename, verbose)
char *filename;
bool_t verbose;
#endif /* ANSI_C */
{
  int i;

  printf("IODTABLE\n");
  
  for (i=0;i<MAXNUMIOD;i++)
  {
    if ((iodt[i].pid != -1) || verbose)
    {
      printf("IODTABLE ELEMENT %d\n",i);
      printf("\thname\t: %s\n",iodt[i].hname);
      printf("\tport\t: %d\n",iodt[i].port);
      printf("\tsockp\t: %d\n",iodt[i].sockp);
      printf("\tpid\t: %d\n",(int)iodt[i].pid);
      if (iodt[i].clnt == NULL)
        printf("\tclnt\t: NULL\n");
      else
      {
        printf("\tclnt\t: SET\n");
        _prt_iod_stat(filename,iodt[i].clnt);
      }
      printf("\n");
    }      
  }
  
  printf("\n");
  return;
}





/* Get index of iodt to a pid of an iod */
static int getioidx
#ifdef ANSI_C
(int pid)
#else
(pid)
int pid;
#endif /* ANSI_C */
{
	int i;

	for (i=0; i < MAXNUMIOD; i++)
		if (iodt[i].pid == pid) 
      return (i);

  errno = EPFSLNOTIOD;
	return(-1);
}


int _init_iod
#ifdef ANSI_C
(void)
#else
()
#endif /* ANSI_C */
{
  int i;
  
  for (i=0;i<MAXNUMIOD;i++)
  {
    iodt[i].pid = -1;
    iodt[i].clnt = (CLIENT *)0;
    iodt[i].port = -1;
    iodt[i].sockp = RPC_ANYSOCK;
    iodt[i].hname[0] = '\0';
    memset(&iodt[i].ipaddr, 0, IPADDRLEN);
  }
  
  return (0);
}


/* Fork iod processes */
int _start_iod
#ifdef ANSI_C
(int how_many)
#else
(how_many)
int how_many;
#endif /* ANSI_C */
{
	int cnt;
  int started = 0;

  if (how_many > MAXNUMIOD)
  {
    errno = EPFSLIODCNT;
    return (-1);
  }

	for (cnt = 0; cnt<how_many; cnt++)
	{
    if (iodt[cnt].pid != -1)
      /* Table element in use */
      continue;
      
		if ((iodt[cnt].pid = fork()) < 0)
    {
      return (-1);
    }
    
		if (iodt[cnt].pid == 0) 
		{
      /* Child process */
			/* set up as IO-Server */
			execlp(IOD_PATH, IOD_PATH, (char *)0);
			/* NEVER RETURNED */
      return (-1);
		}

    /* Parent process */
    started++;
	}

	return(started);
}

int _exit_iod
#ifdef ANSI_C
(void)
#else
()
#endif /* ANSI_C */
{
  int i;
  
  for (i=0;i<MAXNUMIOD;i++)
  {
    if (iodt[i].clnt != (CLIENT *)0)
    {
      _send_iod_exit(iodt[i].clnt);
    }
  }
  
  return (0);
}

int _kill_iod
#ifdef ANSI_C
(int sig)
#else
(sig)
int sig;
#endif /* ANSI_C */
{
  int i;
  
  for (i=0;i<MAXNUMIOD;i++)
  {
    if (iodt[i].pid != -1)
    {
      kill(iodt[i].pid,sig);
    }
  }
  
  return (0);
}

int _del_iod
#ifdef ANSI_C
(pid_t pid)
#else
(pid)
pid_t pid;
#endif /* ANSI_C */
{
  int i = getioidx(pid);
  
  if (i == -1)
    return (-1);
      
  if (iodt[i].clnt != NULL)
    clnt_destroy(iodt[i].clnt);

  close(iodt[i].sockp);

  iodt[i].pid = -1;
  iodt[i].clnt = (CLIENT *)0;
  iodt[i].port = -1;
  iodt[i].hname[0] = '\0';
  iodt[i].sockp = RPC_ANYSOCK;
  memset(&iodt[i].ipaddr, 0, IPADDRLEN);
  
  return (0);
}

  
    

IOD_LISTEL *_get_iod
#ifdef ANSI_C
(void)
#else
()
#endif /* ANSI_C */
{
  int i;
  IOD_LISTEL *res = (struct IOD_LISTEL *)0;

  for (i=0; i < MAXNUMIOD; i++, curriod = (++curriod)%MAXNUMIOD)
    if ((iodt[curriod].pid != -1) &&
        (iodt[curriod].clnt != (CLIENT *)0) &&
        (iodt[curriod].port != -1) &&
        (iodt[curriod].sockp != RPC_ANYSOCK) &&
        (iodt[curriod].hname[0] != '\0'))
      break;
  
  if (i >= MAXNUMIOD)
  {
    return (res);
  }
  
  res = &iodt[curriod];
  
  curriod = (++curriod)%MAXNUMIOD;
  
  return(res);
}




/* Register an iod */
iodregres *pfsd_iod_register_1
#ifdef ANSI_C
(iodregargs *argp, struct svc_req *rqstp)
#else
(argp, rqstp)
iodregargs *argp;
struct svc_req *rqstp;
#endif /* ANSI_C */
{
	static iodregres result;
	struct sockaddr_in *ioaddr;
	int i;

  /*
  xdr_free(xdr_iodregres, (char *)&result);
  */

#ifdef DEBUG
  fprintf(stderr,"pfsd: registering IOD %d\n",argp->pid);
#endif

	if ((i = getioidx(argp->pid)) < 0)
	{
		perror("pfsd_iod_register_1(): getioidx()");
		ERR_MACRO(iodregres_u,errno);
    return(&result);
	}

  /* get the address of the calling iod */
	if ((ioaddr = svc_getcaller(rqstp->rq_xprt)) == NULL)
	{
		perror("pfsd_iod_register_1(): svc_getcaller(iod)");
    ERR_MACRO(iodregres_u,errno);
    return(&result);
	}

  iodt[i].port = argp->addr.port;
  strcpy(iodt[i].hname,argp->addr.hname);
  memcpy(&iodt[i].ipaddr, &ioaddr->sin_addr, IPADDRLEN);

	ioaddr->sin_port = htons(iodt[i].port);

  
  if ((iodt[i].clnt = _clntiod_create(&iodt[i].sockp, ioaddr)) == (CLIENT *)0)
  {
    ERR_MACRO(iodregres_u,errno);
    return(&result);
  }

#ifdef DEBUG
  fprintf(stderr,"pfsd: IOD %d registered\n",argp->pid);
#endif

  result.stat = RPC_OK;

	return(&result);
}




void *pfsd_iod_result_1
#ifdef ANSI_C
(iodresargs *argp, struct svc_req *rqstp)
#else
(argp, rqstp)
iodresargs *argp;
struct svc_req *rqstp;
#endif /* ANSI_C */
{

  int _ftix = argp->fh.vfd;     /* File table index */
  int _ctix = argp->fh.which;   /* Client table index */
  int _ioID = argp->ioID;       /* Id table index */

  /* LAMBO It should be checked whether this index is accessible */
  if ((_ftix < 0) || (_ftix >= MAXNUMFILES) || /* out of range */
      (_RFDC == -1) ||          /* not a valid file table element */
      (_ctix < 0) || (_ctix >= _CFTE.how_many) || /* out of range */
      (_ioID < 0) || (_ioID > MAXIOID) || /* out of range */
      (_CFTE.cltab == NULL))  /* No client table */
  {
    fprintf(stderr,"pfsd_iod_result_1(): Wrong input arguments\n");
    return (NULL);
  }
  
      
  if (_IOID.state != ID_ASYNC)
  {
    fprintf(stderr,"pfsd_iod_result_1(): Wrong state in IOID\n");
    return(NULL);
  }

  _IOID.errno  = argp->errno;
  
  if (argp->ok)
    _IOID.state = ID_DONE;
  else
    _IOID.state = ID_FAILED;
  
  if (_IOID.iowait)
    _iowait_reply(_ftix, _ctix, _ioID);

	return(NULL);                 /* No reply needed */
}


