/******************************************************************************
 *
 *    pfsd_init.c,v : initialize pfsd 
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : pfsd_init.c,v
 *  RCS Date     : 1995/11/30 16:22:17
 *  RCS Revision : 1.9
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef lint
static char rcs_id[] = "pfsd_init.c,v 1.9 1995/11/30 16:22:17 lamberts Rel";
#endif


#include <rpc/rpc.h>
#ifndef RS6K
#include <sys/time.h>
#include <sys/resource.h>
#endif /* ! RS6K */
#include <signal.h>
#include <sys/wait.h>
#include <errno.h>
#include <stdlib.h>
#include <stdio.h>

#include "pfsd.h"
#include "pfsd_defines.h"
#include "pfsd_macros.h"

extern int _del_iod
#ifdef ANSI_C
(pid_t pid);
#else
();
#endif /* ANSI_C */

extern int _kill_iod
#ifdef ANSI_C
(int sig);
#else
();
#endif /* ANSI_C */

extern int _init_iod
#ifdef ANSI_C
(void);
#else
();
#endif /* ANSI_C */

extern int _start_iod
#ifdef ANSI_C
(int how_many);
#else
();
#endif /* ANSI_C */


filetabel *_cftbl;


void _pfsd_childhandler
#ifdef ANSI_C
(int signo)
#else
(signo)
int signo;
#endif /* ANSI_C */
{
	int status;
	int pid;

	while ((pid = waitpid(-1,&status,WNOHANG)) != 0)
	{
    if (pid > 0)
    {
      _del_iod(pid);
    }
    
		if ((pid < 0) && (errno == ECHILD))
			break;
	}

	return;
}

static void kill_iods
#ifdef ANSI_C
(void)
#else
()
#endif /* ANSI_C */
{
  _kill_iod(SIGKILL);
}

void unregister
#ifdef ANSI_C
(void)
#else
()
#endif /* ANSI_C */
{
  fprintf(stderr,"pfsd: unregistering at portmapper\n");

  svc_unregister(PFSD,PFSD_VERS);
  svc_unregister(PFSD_IOD,PFSD_IOD_VERS);
}  

void _pfslib_sighandler
#ifdef ANSI_C
(int signo)
#else
(signo)
int signo;
#endif /* ANSI_C */
{
#ifdef BSD_SIG
  struct sigvec vec;
#else
  struct sigaction  sigact;
#endif

  kill_iods();                  /* kill iods */
  
  /* Reset the signal handler */
#ifdef BSD_SIG
  vec.sv_handler = void(*)()0;
  vec.sv_mask = 0;
  vec.sv_flags = SV_RESETHAND;
  if (sigvec(signo, &vec, (struct sigvec *)0) != 0)
  {
    perror("sigvec()");
    exit(1);
  }
#else  /* ! BSD_SIG */
  sigact.sa_handler = SIG_DFL;
  sigact.sa_flags = 0;
  if (sigaction(signo, &sigact, (struct sigaction *)0) != 0)
  {
    perror("sigaction()");
    exit(1);
  }
#endif /* BSD_SIG */

  kill(getpid(),signo);
}

static void chatch_sigs
#ifdef ANSI_C
(void)
#else
()
#endif /* ANSI_C */
{
  
#ifdef BSD_SIG
  struct sigvec vec;
#else
  struct sigaction  sigact;
#endif
  int i;
  int sig[] =
  {
    SIGHUP,
    SIGINT,
    SIGQUIT,
    SIGILL,
    SIGTRAP,
    SIGABRT,
#ifndef LINUX
    SIGEMT,
#else
    SIGUNUSED,
#endif
    SIGFPE,
#ifndef LINUX
    SIGBUS,
#endif
    SIGSEGV,
#ifndef LINUX
    SIGSYS,
#endif
    SIGPIPE,
    SIGALRM,
    SIGTERM,
#ifdef LINUX
    SIGSTKFLT,
#endif
#ifndef HPPA
    SIGXCPU,
    SIGXFSZ,
#endif
    SIGVTALRM,
    SIGPROF,
    SIGUSR1,
    SIGUSR2,
#ifdef RS6K
    SIGMIGRATE,
    SIGPRE,
#endif
    -1
  };
  
  for (i=0; sig[i] > 0; i++)
  {
#ifdef BSD_SIG
    vec.sv_handler = _pfslib_sighandler;
    vec.sv_mask = sigmask(sig[i]);
    vec.sv_flags = 0;
    if (sigvec(sig[i], &vec, (struct sigvec *)0) != 0)
    {
      perror("sigvec()");
      exit(1);
    }
#else  /* ! BSD_SIG */
    sigact.sa_handler = _pfslib_sighandler;
    sigact.sa_flags = 0;
    if ((sigemptyset(&sigact.sa_mask) != 0) ||
        (sigaddset(&sigact.sa_mask,sig[i]) != 0) ||
        (sigaction(sig[i], &sigact, (struct sigaction *)0) != 0))
    {
      perror("sigaction()");
      exit(1);
    }
#endif /* BSD_SIG */
  }
}


void _pfsd_init
#ifdef ANSI_C
(int argc, char **argv)
#else
(argc, argv)
int argc;
char **argv;
#endif /* ANSI_C */
{
#ifndef RS6K
  struct rlimit      pfsd_fd_limit, fd_curlim;
#endif /* ! RS6K */

  int iodcnt = DFLTIODCNT;                   /* Number of ids */
  int iodst;

  int _ftix;

#ifdef BSD_SIG
  struct sigvec vec;
#else
  struct sigaction  sigact;
#endif

  if (argc > 1)
  {
    if ((iodcnt = atoi(argv[1])) > MAXNUMIOD)
    {
      fprintf(stderr,"%s: Warning: Starting only %d io daemons\n",
              argv[0],MAXNUMIOD);
      iodcnt = MAXNUMIOD;
    }
  }

  if (_init_iod() < 0)
  {
    perror("_pfsd_init(): _init_iod()");
    exit(1);
  }
  

#ifdef BSD_SIG
  vec.sv_handler = _pfsd_childhandler;
  vec.sv_mask = sigmask(SIGCHLD);
  vec.sv_flags = 0;
  if (sigvec(SIGCHLD, &vec, (struct sigvec *)0) != 0)
  {
    perror("sigvec()");
    exit(1);
  }
#else  /* ! BSD_SIG */
  sigact.sa_handler = _pfsd_childhandler;
  sigact.sa_flags = 0;
  if ((sigemptyset(&sigact.sa_mask) != 0) ||
      (sigaddset(&sigact.sa_mask,SIGCHLD) != 0) ||
      (sigaction(SIGCHLD, &sigact, (struct sigaction *)0) != 0))
  {
    perror("sigaction()");
    exit(1);
  }
#endif /* BSD_SIG */

#ifdef SUN4
  on_exit(kill_iods);
#else
  atexit(kill_iods);
#endif /* SUN4 */

  if ((iodst = _start_iod(iodcnt)) < 0)
  {
    perror("_pfsd_init(): _start_iod()");
    exit(1);
  }
  if (iodst != iodcnt)
  {
    fprintf(stderr,"%s: Warning: Started only %d io daemons\n",
            argv[0],MAXNUMIOD);
  }
  
#ifndef RS6K
  if (getrlimit(RLIMIT_NOFILE, &fd_curlim) < 0 )
  {
    perror("_pfsd_init(): getrlimit()");
    exit(1);
  }

  /* set number of filedescriptors to maximum posible */

  pfsd_fd_limit.rlim_cur = fd_curlim.rlim_max;
  pfsd_fd_limit.rlim_max = fd_curlim.rlim_max;

  if (setrlimit(RLIMIT_NOFILE,&pfsd_fd_limit) < 0 )
  {
    fprintf(stderr,"_pfsd_init(): setrlimit() error %d",errno);
    exit(1);
  }
#endif /* ! RS6K */

	/* allocate memory for _cftbl (static during runtime) */
	if ((_cftbl = (filetabel *)malloc(sizeof(filetabel)*MAXNUMFILES ))
      == NULL )
	{
    perror("_pfsd_init(): _malloc()");
    exit(1);
	}

	for (_ftix=0; _ftix<MAXNUMFILES; _ftix++)
	{
		_RFDC = -1;
		_CFTE.cltab = (CltTabEl *)0;
	}

#ifdef SUN4
  on_exit(unregister);
#else
  atexit(unregister);
#endif /* SUN4 */

  chatch_sigs();
  
  return;
}
