/******************************************************************************
 *
 *    pfsd_getioid.c,v : get an io id
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : pfsd_getioid.c,v
 *  RCS Date     : 1995/11/29 14:51:12
 *  RCS Revision : 1.7
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef lint
static char rcs_id[] = "pfsd_getioid.c,v 1.7 1995/11/29 14:51:12 lamberts Rel";
#endif


#include <rpc/rpc.h>
#include <errno.h>
#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>

#include "pfsd.h"
#include "pfsd_defines.h"
#include "pfsd_macros.h"
#include "pfslib_errno.h"

extern filetabel *_cftbl;

extern int _checkfh
#ifdef ANSI_C
(pfslib_fhdl fh, struct svc_req *rqstp);
#else
();
#endif /* ANSI_C */

extern IOD_LISTEL *_get_iod
#ifdef ANSI_C
(void);
#else
();
#endif /* ANSI_C */

extern int _send_iod_request
#ifdef ANSI_C
(int _ftix, int _ctix, int _ioID);
#else
();
#endif /* ANSI_C */

extern void _ioop_reply
#ifdef ANSI_C
(int _ftix, int _ctix, int _ioID, char *wrbuf);
#else
();
#endif /* ANSI_C */


getioidres *pfsd_getioid_1
#ifdef ANSI_C
(getioidargs *argp, struct svc_req *rqstp)
#else
(argp, rqstp)
getioidargs *argp;
struct svc_req *rqstp;
#endif /* ANSI_C */
{
  static getioidres result;
  
  int _ftix = argp->fh.vfd;     /* file table index */
  int _ctix = argp->fh.which;   /* Client table index */
	int _ioID;                    /* Id table index */

  int _clc;
  int _cid;
  
  off_t offs;
  
  bool_t all_calls;
  bool_t mixio     = FALSE;
  
  /*
	xdr_free(xdr_getioidres, (char *)&result);
  */

	/*
	 * check pfslib_fhdl     
	 */

	if (_checkfh(argp->fh,rqstp) < 0 )
	{
    ERR_MACRO(getioidres_u, errno);
		return(&result);
	}

  switch (argp->op)
  {
  case READ_OP:
  case READV_OP:
  case WRITE_OP:
  case WRITEV_OP:
    break;
  default:
    ERR_MACRO(getioidres_u, EPFSLINVAL);
    return (&result);
  }

	/* get the next free ioid */
	for (_ioID=0; _ioID<MAXIOID; _ioID++)
	{
		if (_IOID.state == ID_UNUSED)
			break;
	}

	if (_ioID >= MAXIOID)
	{
    /* No more unused ioids */
    ERR_MACRO(getioidres_u, EPFSLMREQUEST);
		return(&result);
	}

  /* Set default values of ioid table element */

  _IOID.ioseq  = _CLNT.ioseq++; /* Sequence number */
  _IOID.oldmode = FALSE;
  
  _IOID.errno  = 0;
  _IOID.iowait = FALSE;
  _IOID.mixio  = FALSE;
  _IOID.op     = argp->op;
  _IOID.offset = -1;
  _IOID.iolen  = argp->iolen;
  _IOID.data   = (char *)0;
  _IOID.iod    = (IOD_LISTEL *)0;
  
  /* Asign an iod if the operation is asynchron on server side */
  if (argp->ssync)
  {
    _IOID.state = ID_SYNC;
  }
  else
  {
    _IOID.state = ID_ASYNC;
    if ((_IOID.iod = _get_iod()) == (struct IOD_LISTEL *) 0)
    {
      ERR_MACRO(getioidres_u, EPFSLNOIOD);
      
      /* LAMBO: ioid freigeben ??? */

      return(&result);
    }
  }
  
  /* Set the file offset for the operation */
  switch (_MODE)
  {
  case M_UNIX:
    if (((_IOID.op == WRITE_OP) || (_IOID.op == WRITEV_OP)) &&
        (_CFTE.oflags & O_APPEND))
    {
      _IOID.offset = _CFTE.endoffs;
      _CFTE.endoffs += _IOID.iolen;
      _CLNT.foffs = _CFTE.endoffs;
    }
    else
    {
      _IOID.offset = _CLNT.foffs;
      _CLNT.foffs += _IOID.iolen;
      if (_CLNT.foffs > _CFTE.endoffs)
        _CFTE.endoffs = _CLNT.foffs;
    }
    break;

  case M_LOG:
    if (((_IOID.op == WRITE_OP) || (_IOID.op == WRITEV_OP)) &&
        (_CFTE.oflags & O_APPEND))
    {
      _IOID.offset   = _CFTE.endoffs;
      _CFTE.endoffs += _IOID.iolen;
      _CFTE.shoffs   = _CFTE.endoffs;
    }
    else 
    {
      _IOID.offset = _CFTE.shoffs;
      _CFTE.shoffs += _IOID.iolen;
      if (_CFTE.shoffs > _CFTE.endoffs)
        _CFTE.endoffs = _CFTE.shoffs;
    }
    break;

  case M_RECORD:
    if (((_IOID.op == WRITE_OP) || (_IOID.op == WRITEV_OP)) &&
        (_CFTE.oflags & O_APPEND))
    {
      _IOID.offset   = _CLNT.endoffs+(_ctix * _IOID.iolen);
      _CLNT.endoffs += (_CFTE.how_many * _IOID.iolen);
      _CLNT.foffs    = _CLNT.endoffs;
    }
    else 
    {
      _IOID.offset = _CLNT.foffs+(_ctix * _IOID.iolen);
      _CLNT.foffs += (_CFTE.how_many * _IOID.iolen);
      if (_CLNT.foffs > _CLNT.endoffs)
        _CLNT.endoffs = _CLNT.foffs;
    }
    if (_CLNT.foffs > _CFTE.endoffs)
      _CFTE.endoffs = _CLNT.foffs;
    break;

  case M_GLOBAL:

    /* Check whether all processes did the same call */

    _IOID.giolen = _IOID.iolen;

    /* Only the process with client number 0 will write the data */
    if (((_IOID.op == WRITEV_OP) || (_IOID.op == WRITE_OP)) && (_ctix > 0))
      _IOID.iolen = 0;

    all_calls = TRUE;
    mixio = FALSE;
    for(_clc = 0; _clc < _CFTE.how_many; _clc++)
    {
      /* Find matching ioID of other processes and check their arguments */
      for (_cid = 0; _cid < MAXIOID; _cid++)
      {
        if ((_CNID.state != ID_UNUSED) && (_CNID.state != ID_DONE) &&
            (_CNID.state != ID_FAILED) && (_CNID.state != ID_SYNCDO) &&
            (!_CNID.oldmode) &&
            (_CNID.ioseq == _IOID.ioseq)) /* This is the matching id */
        {
          if ((_CNID.op != argp->op) || (_CNID.giolen != argp->iolen))
            mixio = TRUE;
          break;
        }
      }
      
      if (_cid >= MAXIOID)      /* Current client didn't perform
                                   the call yet */
      {
        all_calls = FALSE;
        break;
      }
    }
    
    if (all_calls)
    {
      /* all processes performed the call;
       * set the offset and the errorflag for EMIXIO if necessary */
      for (_clc = 0; _clc < _CFTE.how_many; _clc++)
      {
        for (_cid = 0; _cid < MAXIOID; _cid++)
        {
          if ((_CNID.state != ID_UNUSED) && (_CNID.state != ID_DONE) &&
              (_CNID.state != ID_FAILED) && (_CNID.state != ID_SYNCDO) &&
              (!_CNID.oldmode) &&
              (_CNID.ioseq == _IOID.ioseq)) /* This is the matching call */
          {
            if (mixio)
              _CNID.errno = EPFSLMIXIO;

            if (((_IOID.op == WRITE_OP) || (_IOID.op == WRITEV_OP)) &&
                (_CFTE.oflags & O_APPEND))
              _CNID.offset = _CFTE.endoffs;
            else
              _CNID.offset = _CFTE.shoffs;
            break;
          }
        }
      }      
      if (((_IOID.op == WRITE_OP) || (_IOID.op == WRITEV_OP)) &&
          (_CFTE.oflags & O_APPEND))
      {
        _CFTE.endoffs += _IOID.giolen;
        _CFTE.shoffs   = _CFTE.endoffs;
      }
      else
      {
        _CFTE.shoffs += _IOID.giolen;
        if (_CFTE.shoffs > _CFTE.endoffs)
          _CFTE.endoffs = _CFTE.shoffs;
      }
    }
    
    break;

  case M_SYNC:
    
    all_calls = TRUE;
    mixio = FALSE;
    for(_clc = 0; _clc < _CFTE.how_many; _clc++)
    {
      /* Find matching ioID of other processes and check their arguments */
      for (_cid = 0; _cid < MAXIOID; _cid++)
      {
        if ((_CNID.state != ID_UNUSED) && (_CNID.state != ID_DONE) &&
            (_CNID.state != ID_FAILED) && (_CNID.state != ID_SYNCDO) &&
            (!_CNID.oldmode) &&
            (_CNID.ioseq == _IOID.ioseq)) /* This is the matching call */
        {
          if (_CNID.op != argp->op)
            mixio = TRUE;
          break;
        }
      }
      
      if (_cid >= MAXIOID)      /* Current client didn't perform
                                   the call yet */
      {
        all_calls = FALSE;
        break;
      }
    }
    
    /* Set offsets if all processes did the call */
    /* All previous iread or iwrite calls must have done this already;
       otherwise the incomming call would match to a different set.
       Hence, it's ok to update the file pointer without explicit waiting
       for other pending iread/iwrite calls */
    if (all_calls)
    {
      if (((_IOID.op == WRITE_OP) || (_IOID.op == WRITEV_OP)) &&
          (_CFTE.oflags & O_APPEND))
        offs = _CFTE.endoffs;
      else
        offs = _CFTE.shoffs;
      for (_clc = 0; _clc < _CFTE.how_many; _clc++)
      {
        for (_cid = 0; _cid < MAXIOID; _cid++)
        {
          if ((_CNID.state != ID_UNUSED) && (_CNID.state != ID_DONE) &&
              (_CNID.state != ID_FAILED) && (_CNID.state != ID_SYNCDO) &&
              (!_CNID.oldmode) &&
              (_CNID.ioseq == _IOID.ioseq)) /* This is the matching call */
          {
            if (mixio)
              _CNID.errno = EPFSLMIXIO;
            _CNID.offset = offs;
            offs += _CNID.iolen;
            break;
          }
        }
      }      
      if (((_IOID.op == WRITE_OP) || (_IOID.op == WRITEV_OP)) &&
          (_CFTE.oflags & O_APPEND))
      {
        _CFTE.endoffs = offs;
        _CFTE.shoffs  = offs;
      }
      else
      {
        _CFTE.shoffs = offs;
        if (_CFTE.shoffs > _CFTE.endoffs)
          _CFTE.endoffs = _CFTE.shoffs;
      }
    }
    break;

  default:
    /* LAMBO Fehler */
    break;
  }
  
  /* Send the io sever the request */
  switch(_MODE)
  {
  case M_UNIX:
  case M_LOG:
  case M_RECORD:
    switch (_IOID.state)
    {
    case ID_SYNC:
      _IOID.state =ID_SYNCDO;   /* Allow synchronous ioops */
      break;
    case ID_ASYNC:
      if (_send_iod_request(_ftix, _ctix, _ioID) < 0)
      {
        ERR_MACRO(getioidres_u, EPFSLNOIOD);

        /* Free ioid ??? */

        return (&result);
      }
      break;
    default:
      /* LAMBO Fehler */
      break;
    }
    break;

  case M_GLOBAL:
  case M_SYNC:
    /* Send the request if all processes did the getioid call */
    if (all_calls)
    {
      for (_clc = 0; _clc < _CFTE.how_many; _clc++)
      {
        for (_cid = 0; _cid < MAXIOID; _cid++)
        {
          if ((_CNID.state != ID_UNUSED) && (_CNID.state != ID_DONE) &&
              (_CNID.state != ID_FAILED) && (_CNID.state != ID_SYNCDO) &&
              (!_CNID.oldmode) && (_CNID.ioseq == _IOID.ioseq))
          {
            switch (_CNID.state)
            {
            case ID_ASYNC:
              if (_send_iod_request(_ftix, _clc, _cid) < 0)
              {
                ERR_MACRO(getioidres_u, EPFSLNOIOD);

                return (&result);
              }
              break;
            case ID_SYNC:
              _CNID.state = ID_SYNCDO; /* Allow synchronous ioops */
              break;
            case ID_SYNCPENDING:
              /* Serve the pending IO operation */
              _ioop_reply(_ftix, _clc, _cid, _CNID.data);
              if (_CNID.data != (char *)0)
                free(_CNID.data);
              break;
            default:
              /* LAMBO Fehler */
              break;
            }
            break;
          }
        }
      }
    }
    break;
  default:
    /* LAMBO Fehler */
    break;
  }
  
  result.stat = RPC_OK;
  result.getioidres_u.res.ioID = _ioID;
  if (_IOID.state == ID_ASYNC)
  {
    result.getioidres_u.res.iod_addr.hname = _IOID.iod->hname;
    memcpy(&result.getioidres_u.res.iod_addr.ipaddr, &_IOID.iod->ipaddr,
           IPADDRLEN);
    result.getioidres_u.res.iod_addr.port  = _IOID.iod->port;
  }
  else 
  {
    result.getioidres_u.res.iod_addr.hname = "";
    result.getioidres_u.res.iod_addr.port  = 0;
  }
  
  return(&result);
}
