/******************************************************************************
 *
 *    pfsd_fattr.c,v : get file attributes
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : pfsd_fattr.c,v
 *  RCS Date     : 1995/11/23 17:42:56
 *  RCS Revision : 1.6
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef lint
static char rcs_id[] = "pfsd_fattr.c,v 1.6 1995/11/23 17:42:56 lamberts Rel";
#endif


#include <rpc/rpc.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>

#include "pfsd.h"
#include "pfsd_defines.h"
#include "pfsd_macros.h"
#include "pfslib_errno.h"

extern filetabel *_cftbl;

extern int _checkfh
#ifdef ANSI_C
(pfslib_fhdl fh, struct svc_req *rqstp);
#else
();
#endif /* ANSI_C */


/* ************************************************************************ */
/* pfsd_getfattr_1(): the rpc for getting file attributes                   */
/* ************************************************************************ */

fattrres *pfsd_getfattr_1
#ifdef ANSI_C
(pfslib_fhdl *argp, struct svc_req *rqstp)
#else
(argp, rqstp)
pfslib_fhdl *argp;
struct svc_req *rqstp;
#endif /* ANSI_C */
{

	static fattrres  result;

  struct stat statbuf;

  int _ftix = argp->vfd;        /* File table index */
  
  /*
	xdr_free(xdr_fattrres, (char *)&result);
  */

	/*
	 * check pfslib_fhdl     
	 */

	if (_checkfh(*argp,rqstp) < 0 )
	{
    ERR_MACRO(fattrres_u,errno);
    return (&result);
	}

  /* Wait for asynchronous operations to finish */

	/* This operation is never synchronizing */

	if (fstat(_RFDC, &statbuf) < 0 )
	{
    ERR_MACRO(fattrres_u,errno);
		return(&result);
	}

	result.fattrres_u.attr.type    = 1;
	result.fattrres_u.attr.amode   = statbuf.st_mode;
	result.fattrres_u.attr.nlink   = statbuf.st_nlink;
	result.fattrres_u.attr.userid  = statbuf.st_uid;
	result.fattrres_u.attr.groupid = statbuf.st_gid; 
	result.fattrres_u.attr.size    = statbuf.st_size; 
	result.fattrres_u.attr.atime   = statbuf.st_atime;
	result.fattrres_u.attr.mtime   = statbuf.st_mtime;
	result.fattrres_u.attr.ctime   = statbuf.st_ctime; 
	result.fattrres_u.attr.actual  = _CFTE.actual;

	return(&result);
}
