/******************************************************************************
 *
 *    pfsd_exit.c,v : causes the pfsd to exit.
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : pfsd_exit.c,v
 *  RCS Date     : 1995/11/30 16:56:09
 *  RCS Revision : 1.2
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef lint
static char rcs_id[] = "pfsd_exit.c,v 1.2 1995/11/30 16:56:09 lamberts Rel";
#endif


#include <rpc/rpc.h>
#include <stdio.h>

extern int _exit_iod
#ifdef ANSI_C
(void);
#else
();
#endif /* ANSI_C */

extern int _kill_iod
#ifdef ANSI_C
(void);
#else
();
#endif /* ANSI_C */


void *pfsd_exit_1
#ifdef ANSI_C
(void *argp, struct svc_req *rqstp)
#else
(argp, rqstp)
void *argp;
struct svc_req *rqstp;
#endif /* ANSI_C */
{
  static char result;

  _exit_iod();

  svc_sendreply(rqstp->rq_xprt,xdr_void,&result);

  _kill_iod();
  
  fprintf(stderr,"pfsd: exiting\n");

  exit(0);
}
