/******************************************************************************
 *
 *    pfsd_defines.h,v : definitions for pfsd
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : pfsd_defines.h,v
 *  RCS Date     : 1995/11/29 14:08:32
 *  RCS Revision : 1.6
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef __pfslib_pfsd_defines_h__
#define __pfslib_pfsd_defines_h__

#ifndef lint
static char rcs_id_pfsd_defines[] = "pfsd_defines.h,v 1.6 1995/11/29 14:08:32 lamberts Rel";
#endif



#define MAXNUMFILES     64      /* == (getdtablesize()/4) */
#define MAXNUMCLIENTS  128      /* == (getdtablesize()/2) */
#define MAXIOID         20      /* numer of io identifiers per client
                                   per file */
#define MAXNUMIOD       20      /* Max number of io daemons */
#define DFLTIODCNT      8       /* Default number of iodaemons */
#define IOD_PATH       "iod"    /* iod executable */

/* ************************************************************************* */
/*      the internal structure for complete administration                   */
/* ************************************************************************* */

/* ************************************************************************* */
/*               handle the forked IO-Server                                 */
/* ************************************************************************* */

struct IOD_LISTEL
{
  char        hname[MAXNLEN];   /* Hostname of the iod */
  pfslib_ipaddr ipaddr;        /* IP address */
  int         port;             /* Portnumber of the iod */
  int         sockp;            /* Socket number  */
  pid_t       pid;              /* -1 if not existent */
  CLIENT      *clnt;            /* Client transport handle */
};
typedef struct IOD_LISTEL IOD_LISTEL;


/* ------------------------------------------ */
/* table of the IOid's                        */
/* Possible state of an ioid  */
typedef enum
{
  ID_UNUSED,                    /* Not in use */
  ID_SYNC,                      /* Associate io operation will be done
                                 * by the daemon itself;
                                 * The operation must not be performed yet
                                 * there is still some information missing */
  ID_SYNCDO,                    /* As ID_SYNC;
                                 * The operation my be performed;
                                 * The client didn't call the io operation
                                 * yet*/
  ID_SYNCPENDING,               /* As ID_SYNCDO;
                                 * The client did the io operation but the
                                 * daemon didn't send a reply yet */
  ID_ASYNC,                     /* Associate operation will be done by a
                                 * io daemon */
  ID_DONE,                      /* The operation was done successfuly */
  ID_FAILED                    /* The operation was done unsuccessfuly */
} ID_state;


struct IdTabEl {
	ID_state      state;          /* State of this ioID */

  unsigned long ioseq;          /* Sequence number */
  bool_t        oldmode;        /* This idID was not released before a
                                   setiomode call */

  int           errno;          /* If state is ID_FAILED errno contains 
                                   the error number of the error */
  bool_t       iowait;          /* If TRUE iowait call is waiting */
  bool_t        mixio;          /* TRUE if error in input parameters in
                                   mode M_GLOBAL or M_SYNC */
  int           op;             /* What kind of operation has to be done */
  off_t         offset;         /* Offset in the file for the operation */
  unsigned int  iolen;          /* Number of bytes to be transfrered */
  unsigned int  giolen;         /* Number of bytes to be transfrered in a
                                   global operation */
  IOD_LISTEL   *iod;            /* The index of the iod if ID_ASYNC */
  char         *data;           /* data for io operation if state is
                                   ID_SYNCPENDING */
	SVCXPRT      *transp;         /* Transport for pending IO operations */
};

typedef struct IdTabEl IdTabEl;

typedef IdTabEl IdTable[MAXIOID];

/* Client identifier */
struct clntident
{
  char   hname[MAXNLEN];        /* Hostname of client */
  int    uid;                   /* Userid of client */
  int    gid;                   /* Groupid of client */
  u_long aup_time;              /* Time of authenifiaction information */
};
typedef struct clntident clntident;


/* --------------------------------------------------------------- */
/* table of associated clients of a file, in case of synchronising */
/* the clients the transport handle is needed (SVCXPRT *)          */
struct CltTabEl {
	bool_t      access;           /* TRUE if the client has access to the file */
	off_t       foffs;            /* offset in the file if filepointers are
                                   independent */
  off_t       endoffs;          /* End of file for this process
                                   Used in M_RECORD */
  bool_t      syncdone;         /* TRUE if the client already called a
                                   synchronizing operation */
  bool_t      syncok;           /* TRUE if no error occured during the
                                   execution of a synchronizing operation
                                   by the client  */
  int         syncerr;          /* errno of the error if syncok == FALSE */
	SVCXPRT     *transp;
  /* Authentification parameter */
  clntident   ident;

  unsigned long ioseq;          /* Sequence nuber of ioID */
  
	IdTable     ioIDs;            /* Table of io identifiers */
};
typedef struct CltTabEl CltTabEl;


typedef enum
{
  PFSD_SYNC_NONE,
  PFSD_SYNC_OPEN,
  PFSD_SYNC_CLOSE,
  PFSD_SYNC_SETIOMODE,
  PFSD_SYNC_LSEEK
} syncop;


/* ------------------------------------------ */
/* the complete structure of the filetable    */
struct filetabel {
	int      filedes;             /* real filedescriptor */
	int      oflags;              /* passed openflags */
  mode_t   permission;          /* file creation permissions */
  uid_t    uid;                 /* Unix user id */
  gid_t    gid;                 /* Unix group id */
  char     filename[MAXNLEN];   /* real filename */
	int      mode;                /* current iomode */
  int      rqmode;              /* iomode requested in setiomode() */
  off_t    shoffs;              /* offset in the file if filepointer is
                                   shared */
  off_t    endoffs;             /* End of file offset */
  int      how_many;            /* number of clients */
	int      actual;              /* accessing the file */
	syncop   sync;                /* controlling flag for synchronisation */
	CltTabEl *cltab;              /* pointer to clienttable */
};
typedef struct filetabel filetabel;

#endif /* __pfslib_pfsd_defines_h__ */
