/*****************************************************************************
 *
 *    pfsd.x,v RPC specification file of the PFS daemon.
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    This file is part of PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/*****************************************************************************
 *
 *  RCS Filename : pfsd.x,v
 *  RCS Date     : 1995/11/30 16:23:29
 *  RCS Revision : 1.10
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/

%/*****************************************************************************
% *
% *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
% *
% *    PFSLib (Parallel I/O on workstations)
% *
% *    PFSLib offers parallel access to files for a parallel application
% *    running on a cluster of workstations.
% *    It is intended but not restricted to be used in message passing
% *    applications based on PVM, NXLib, MPI, and other.
% *
% *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
% *
% *    PFSLib is free software; you can redistribute the LIBRARY and/or
% *    modify it under the terms of the GNU Library General Public
% *    License as published by the Free Software Foundation; either
% *    version 2 of the License, or (at your option) any later version.
% *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
% *    and/or modify them under the terms of the GNU General Public
% *    License as published by the Free Software Foundation; either
% *    version 2 of the License, or (at your option) any later version.
% *
% *    PFSLib is distributed in the hope that it will be useful,
% *    but WITHOUT ANY WARRANTY; without even the implied warranty of
% *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% *    Library General Public License and GNU General Public License 
% *    for more details.
% *
% *    You should have received a copy of the GNU Library General Public
% *    License and the GNU General Public License along with this
% *    library; if not, write to the Free 
% *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
% *
% *    Contact to the authors:
% *
% *    electronic mail: pfslib@informatik.tu-muenchen.de
% *
% *    paper mail:      Prof. Dr. A. Bode
% *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
% *                     Institut f"ur Informatik
% *                     Technische Universit"at M"unchen
% *                     80290 M"unchen
% *                     Germany
% *
% *    This project was partially funded by a research grant form Intel
% *    Corporation. 
% *
% *****************************************************************************/



#ifdef RPC_HDR
%
%#ifdef HPPA
%#include <sys/time.h>
%#include <sys/types.h>
%#endif /* HPPA */
%
%/* *********************************************************************** */
%/*    basic data types                                                     */
%/* *********************************************************************** */
%
#endif /* RPC_HDR */


#include "../include/global_rpc.h"


#ifdef RPC_HDR
%
%/* *********************************************************************** */
%/*     define the function input arguments                                 */
%/* *********************************************************************** */
%
#endif /* RPC_HDR */

/* input of PFSD_OPEN */
struct openargs
{
  bool         global;
  string       filename<MAXNLEN>;
  pfslib_otype oflags;
  int          permission;
  int          how_many;
  int          which;
  int          mode;
};

/* input of PFSD_SETIOMODE */
struct setiomodeargs
{
  pfslib_fhdl   fh;
  int       mode;
};

/* input of PFSD_GETIOID */
struct getioidargs
{
  pfslib_fhdl fh;
  int        op;
  bool       ssync;             /* server works synchronously */
  u_int      iolen;
};

/* input of PFSD_IODONE and PFSD_IOWAIT */
struct ioidstatargs
{
  pfslib_fhdl   fh;
  int          ioID; 
};

/* input of PFSD_IOOP */
struct ioopargs
{
  int          op;
  pfslib_fhdl   fh;
  int          ioID;
  u_int        iolen;
  pfslib_data  data;
};

/* input of PFSD_LSIZE and PFSD_LSEEK */
struct fpmoveargs
{
  pfslib_fhdl   fh;
  int          whence;
  u_int        offset;
}; 

struct resetargs
{
  string fname<MAXNLEN>;
};


struct prtstatargs
{
  bool   verbose;
  bool   iods;
  string fname<MAXNLEN>;
};

/* all other procedures only take an pfslib_fhdl as input argument */


#ifdef RPC_HDR
%
%/* *********************************************************************** */
%/*     define the function results                                         */
%/* *********************************************************************** */
%
#endif /* RPC_HDR */

/* result of PFSD_OPEN */
union openres switch (int stat)
{
 case RPC_OK:
  pfslib_fhdl  fh;
 case RPC_ERR:
  errorinfo   err;
 default:
  void;
};

/* result of PFSD_SETIOMODE */
union setiomoderes switch (int stat)
{
 case RPC_ERR:
  errorinfo   err;
 default:
  void;
};

/* result of PFSD_GETIOMODE */
union iomoderes switch (int stat)
{
 case RPC_OK:
  int         mode;
 case RPC_ERR:
  errorinfo   err;
 default:
  void;
};

/* result of PFSD_GETIOID */
struct gioidres
{
  int         ioID;
  iod_address iod_addr;
};  

union getioidres switch (int stat)
{
 case RPC_OK:
  gioidres  res;
 case RPC_ERR:
  errorinfo err;
 default:
  void;
};

union iodoneres switch (int stat)
{
 case RPC_OK:
  bool      done;
 case RPC_ERR:
  errorinfo err;
 default:
  void;
};

/* result of PFSD_IOWAIT */
union iowaitres switch (int stat)
{
 case RPC_ERR:
  errorinfo err;
 default:
  void;
};

struct opres
{
  u_int       iolen;
  pfslib_data data;
};  

/* result of PFSD_IOOP */
union ioopres switch (int stat)
{
 case RPC_OK:
  opres     res;
 case RPC_ERR:
  errorinfo err;
 default:
  void;
};
    
/* result of PFSD_LSIZE */
union lsizeres switch ( int stat )
{
 case RPC_OK:
  u_int     size;
 case RPC_ERR:
  errorinfo err;
 default:
  void;
};

/* result of PFSD_ISEOF */
union iseofres switch (int stat)
{
 case RPC_OK:
  bool      eof;
 case RPC_ERR:
  errorinfo err;
 default:
  void;
};

/* result of PFSD_LSEEK */
union lseekres switch (int stat)
{
 case RPC_OK:
  u_int        pos;
 case RPC_ERR:
  errorinfo    err;
 default:
  void;
};

#ifdef RPC_HDR
%
%
%/* cio_stat: NOT the same as UNIX stat structure */
%
#endif /* RPC_HDR */


/* result of PFSD_GETFATTR */
union fattrres switch (int stat)
{
 case RPC_OK:
  pfslib_fattr attr;
 case RPC_ERR:
  errorinfo    err;
 default:
  void;
};

/* result of PFSD_CLOSE */
union closeres switch(int stat)
{
 case RPC_ERR:
  errorinfo err;
 default:
  void;
};

/* result of PSFD_RESET */
union resetres switch (int stat)
{
 case RPC_OK:
  int  count;                   /* Number of files which were reset */
 case RPC_ERR:
  errorinfo err;
 default:
  void;
};


#ifdef RPC_HDR
%
%/* *********************************************************************** */
%/*    pfsd-program definition (for client communication)                    */
%/* *********************************************************************** */
%
#endif /* RPC_HDR */

#ifdef RPC_SVC
%
%#ifdef SUN4
%#include <memory.h>
%#else
%#include <string.h>
%#endif /* SUN4 */
%
%#define bzero(a,b) memset(a,0,b)
%
%extern void _pfsd_init
%#ifdef ANSI_C
%(int argc, char **argv);
%#else
%();
%#endif /* ANSI_C */
%
%#include "auth_ok.c"
%
%static void pfsd_main
%#ifdef ANSI_C
%(int argc, char **argv);
%#else
%();
%#endif /* ANSI_C */
%
%int main
%#ifdef ANSI_C
%(int argc, char **argv)
%#else
%(argc, argv)
%int    argc;
%char **argv;
%#endif /* ANSI_C */
%{
%  char hostname[MAXNLEN];
%  
%  if (gethostname(hostname,MAXNLEN) < 0)
%  {
%    perror("gethostname");
%    exit(1);
%  }
%  
%  if (callrpc(hostname, PFSD, PFSD_VERS, NULLPROC,
%              xdr_void, (char *)NULL, xdr_void, (char *)0) == RPC_SUCCESS)
%  {
%    fprintf(stderr,"%s: There is already a pfsd registered on this machine\n",
%            argv[0]);
%    fprintf(stderr,"%s: Exiting\n",argv[0]);
%    exit(1);
%  }
%
%  pfsd_main(argc,argv);
%  return (1);
%}
%
%/* define main to be able to access the original main procedure */
%#ifdef ANSI_C
%#define main() static void pfsd_main(int argc, char **argv)
%#else
%#define main() static void pfsd_main(argc, argv)\
%int argc;\
%char **argv;
%#endif
%
%/* Initialize before running svc_run() */
%#ifdef ANSI_C
%static int pfsd_svc_run(int argc, char **argv)
%#else
%static int pfsd_svc_run(argc, argv)
%int argc;
%char **argv;
%#endif /* ANSI_C */
%{
%  _pfsd_init(argc, argv);
%  svc_run();
%  /* Should never return */
%  exit(1);
%}
%
%#define svc_run() pfsd_svc_run(argc, argv)  
%
#endif /* RPC_SVC */


program PFSD
{
  version PFSD_VERS
  {
    openres       PFSD_OPEN       (openargs)       =  1;
    setiomoderes  PFSD_SETIOMODE  (setiomodeargs)  =  2;
    iomoderes     PFSD_GETIOMODE  (pfslib_fhdl)    =  3;
    getioidres    PFSD_GETIOID    (getioidargs)    =  4;
    iodoneres     PFSD_IODONE     (ioidstatargs)   =  5;
    iowaitres     PFSD_IOWAIT     (ioidstatargs)   =  6;
    ioopres       PFSD_IOOP       (ioopargs)       =  7;
    lsizeres      PFSD_LSIZE      (fpmoveargs)     =  8;
    iseofres      PFSD_ISEOF      (pfslib_fhdl)    =  9;
    lseekres      PFSD_LSEEK      (fpmoveargs)     = 10;
    fattrres      PFSD_GETFATTR   (pfslib_fhdl)    = 11;
    closeres      PFSD_CLOSE      (pfslib_fhdl)    = 12;
    int           PFSD_NUMCLNTS   (void)           = 13;
    int           PFSD_NUMFILES   (void)           = 14;
    resetres      PFSD_RESET      (resetargs)      = 15;
    void          PFSD_CLTEXIT    (pfslib_fhdl)    = 16;
    void          PFSD_PRTSTAT    (prtstatargs)    = 17;
    void	  PFSD_EXIT       (void)           = 18;
  } = 1;
} = 0x399997;

#ifdef RPC_HDR
%
%/* *********************************************************************** */
%/*    communication between IOD and the PFSD                               */
%/* *********************************************************************** */
%
#endif

struct iodresargs
{
  pfslib_fhdl fh;               /* File table index */
  int         ioID;             /* ioID of the operation */
  bool        ok;               /* The operation was successfull or not */
  int         errno;            /* errno if not successfull */

  pfslib_data dhb;              /* Dirty Hack Buffer
                                   Send additional data to force sending of
                                   the RPC request */
};

struct iodregargs
{
  iod_address addr;  
  int         pid;
};

union iodregres switch (int stat)
{
 case RPC_ERR:
  errorinfo err;
 default:
  void;
};


#ifdef RPC_HDR
%
%/* *********************************************************************** */
%/*    pfsd-program definition (for IOD communication)                      */
%/* *********************************************************************** */
%
#endif

#ifdef RPC_CLNT
%
%
%#ifdef SUN4
%#include <memory.h>
%#else
%#include <string.h>
%#endif /* SUN4 */
%
%#define bzero(a,b) memset(a,0,b)
%
%/* Zero timeout */
%static struct timeval ZTIMEOUT = { 0, 0 };
%
#endif

program PFSD_IOD
{
  version PFSD_IOD_VERS
  {
    void      PFSD_IOD_RESULT   (iodresargs)   = 1;
    iodregres PFSD_IOD_REGISTER (iodregargs)   = 2;
  } = 1;
} = 0x399998;


#ifdef RPC_XDR
%
%#include <fcntl.h>
%
%/* ********************************************************************** */
%/* xdr routine to convert open flags                                      */
%/* ********************************************************************** */
%bool_t
%xdr_pfslib_otype(xdrs, objp)
%  XDR *xdrs;
%  pfslib_otype *objp;
%{
%  int res = 0;
%  
%  switch (xdrs->x_op)
%  {
%  case XDR_ENCODE:
%    if (*objp & O_RDONLY) res |= PFSLIB_O_RDONLY;
%    if (*objp & O_WRONLY) res |= PFSLIB_O_WRONLY;
%    if (*objp & O_RDWR) res |= PFSLIB_O_RDWR;
%    if (*objp & O_APPEND) res |= PFSLIB_O_APPEND;
%    if (*objp & O_CREAT) res |= PFSLIB_O_CREAT;
%    if (*objp & O_EXCL) res |= PFSLIB_O_EXCL;
%    if (*objp & O_NOCTTY) res |= PFSLIB_O_NOCTTY;
%    if (*objp & O_NONBLOCK) res |= PFSLIB_O_NONBLOCK;
%    if (*objp & O_TRUNC) res |= PFSLIB_O_TRUNC;
%    if (*objp & O_NDELAY) res |= PFSLIB_O_NDELAY;
%    if (*objp & O_SYNC) res |= PFSLIB_O_SYNC;
%    return (xdr_int(xdrs, &res));
%  case XDR_DECODE:
%    if (!xdr_int(xdrs, &res))
%    {
%      return (FALSE);
%    }
%    *objp = 0;
%    if (res & PFSLIB_O_RDONLY) *objp |= O_RDONLY;
%    if (res & PFSLIB_O_WRONLY) *objp |= O_WRONLY;
%    if (res & PFSLIB_O_RDWR) *objp |= O_RDWR;
%    if (res & PFSLIB_O_APPEND) *objp |= O_APPEND;
%    if (res & PFSLIB_O_CREAT) *objp |= O_CREAT;
%    if (res & PFSLIB_O_EXCL) *objp |= O_EXCL;
%    if (res & PFSLIB_O_NOCTTY) *objp |= O_NOCTTY;
%    if (res & PFSLIB_O_NONBLOCK) *objp |= O_NONBLOCK;
%    if (res & PFSLIB_O_TRUNC) *objp |= O_TRUNC;
%    if (res & PFSLIB_O_NDELAY) *objp |= O_NDELAY;
%    if (res & PFSLIB_O_SYNC) *objp |= O_SYNC;
%    return (TRUE);
%  case XDR_FREE:
%    return (xdr_int(xdrs, &res));
%  }
%  return (FALSE);
%}
%
#endif /* RPC_XDR */
  












