/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#include <rpc/types.h>

/*****************************************************************************
 *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

#ifdef HPPA
#include <sys/time.h>
#include <sys/types.h>
#endif /* HPPA */

/* *********************************************************************** */
/*    basic data types                                                     */
/* *********************************************************************** */


#include "global.h"


/* Flags for open() call */
typedef int pfslib_otype;
bool_t xdr_pfslib_otype();


struct errorinfo {
	int errno;
	char *errstr;
};
typedef struct errorinfo errorinfo;
bool_t xdr_errorinfo();

typedef struct {
	u_int pfslib_data_len;
	char *pfslib_data_val;
} pfslib_data;
bool_t xdr_pfslib_data();

struct pfslib_fhdl {
	int vfd;
	int how_many;
	int which;
	int mode;
};
typedef struct pfslib_fhdl pfslib_fhdl;
bool_t xdr_pfslib_fhdl();
#define IPADDRLEN 4

typedef char pfslib_ipaddr[IPADDRLEN];
bool_t xdr_pfslib_ipaddr();

struct iod_address {
	char *hname;
	int port;
	pfslib_ipaddr ipaddr;
};
typedef struct iod_address iod_address;
bool_t xdr_iod_address();

struct pfslib_fattr {
	int type;
	int amode;
	int nlink;
	int userid;
	int groupid;
	long size;
	long atime;
	long mtime;
	long ctime;
	int actual;
};
typedef struct pfslib_fattr pfslib_fattr;
bool_t xdr_pfslib_fattr();

/* *********************************************************************** */
/*     define the function input arguments                                 */
/* *********************************************************************** */


struct openargs {
	bool_t global;
	char *filename;
	pfslib_otype oflags;
	int permission;
	int how_many;
	int which;
	int mode;
};
typedef struct openargs openargs;
bool_t xdr_openargs();

struct setiomodeargs {
	pfslib_fhdl fh;
	int mode;
};
typedef struct setiomodeargs setiomodeargs;
bool_t xdr_setiomodeargs();

struct getioidargs {
	pfslib_fhdl fh;
	int op;
	bool_t ssync;
	u_int iolen;
};
typedef struct getioidargs getioidargs;
bool_t xdr_getioidargs();

struct ioidstatargs {
	pfslib_fhdl fh;
	int ioID;
};
typedef struct ioidstatargs ioidstatargs;
bool_t xdr_ioidstatargs();

struct ioopargs {
	int op;
	pfslib_fhdl fh;
	int ioID;
	u_int iolen;
	pfslib_data data;
};
typedef struct ioopargs ioopargs;
bool_t xdr_ioopargs();

struct fpmoveargs {
	pfslib_fhdl fh;
	int whence;
	u_int offset;
};
typedef struct fpmoveargs fpmoveargs;
bool_t xdr_fpmoveargs();

struct resetargs {
	char *fname;
};
typedef struct resetargs resetargs;
bool_t xdr_resetargs();

struct prtstatargs {
	bool_t verbose;
	bool_t iods;
	char *fname;
};
typedef struct prtstatargs prtstatargs;
bool_t xdr_prtstatargs();

/* *********************************************************************** */
/*     define the function results                                         */
/* *********************************************************************** */


struct openres {
	int stat;
	union {
		pfslib_fhdl fh;
		errorinfo err;
	} openres_u;
};
typedef struct openres openres;
bool_t xdr_openres();

struct setiomoderes {
	int stat;
	union {
		errorinfo err;
	} setiomoderes_u;
};
typedef struct setiomoderes setiomoderes;
bool_t xdr_setiomoderes();

struct iomoderes {
	int stat;
	union {
		int mode;
		errorinfo err;
	} iomoderes_u;
};
typedef struct iomoderes iomoderes;
bool_t xdr_iomoderes();

struct gioidres {
	int ioID;
	iod_address iod_addr;
};
typedef struct gioidres gioidres;
bool_t xdr_gioidres();

struct getioidres {
	int stat;
	union {
		gioidres res;
		errorinfo err;
	} getioidres_u;
};
typedef struct getioidres getioidres;
bool_t xdr_getioidres();

struct iodoneres {
	int stat;
	union {
		bool_t done;
		errorinfo err;
	} iodoneres_u;
};
typedef struct iodoneres iodoneres;
bool_t xdr_iodoneres();

struct iowaitres {
	int stat;
	union {
		errorinfo err;
	} iowaitres_u;
};
typedef struct iowaitres iowaitres;
bool_t xdr_iowaitres();

struct opres {
	u_int iolen;
	pfslib_data data;
};
typedef struct opres opres;
bool_t xdr_opres();

struct ioopres {
	int stat;
	union {
		opres res;
		errorinfo err;
	} ioopres_u;
};
typedef struct ioopres ioopres;
bool_t xdr_ioopres();

struct lsizeres {
	int stat;
	union {
		u_int size;
		errorinfo err;
	} lsizeres_u;
};
typedef struct lsizeres lsizeres;
bool_t xdr_lsizeres();

struct iseofres {
	int stat;
	union {
		bool_t eof;
		errorinfo err;
	} iseofres_u;
};
typedef struct iseofres iseofres;
bool_t xdr_iseofres();

struct lseekres {
	int stat;
	union {
		u_int pos;
		errorinfo err;
	} lseekres_u;
};
typedef struct lseekres lseekres;
bool_t xdr_lseekres();


/* cio_stat: NOT the same as UNIX stat structure */


struct fattrres {
	int stat;
	union {
		pfslib_fattr attr;
		errorinfo err;
	} fattrres_u;
};
typedef struct fattrres fattrres;
bool_t xdr_fattrres();

struct closeres {
	int stat;
	union {
		errorinfo err;
	} closeres_u;
};
typedef struct closeres closeres;
bool_t xdr_closeres();

struct resetres {
	int stat;
	union {
		int count;
		errorinfo err;
	} resetres_u;
};
typedef struct resetres resetres;
bool_t xdr_resetres();

/* *********************************************************************** */
/*    pfsd-program definition (for client communication)                    */
/* *********************************************************************** */


#define PFSD ((u_long)0x399997)
extern struct rpcgen_table pfsd_1_table[];
extern pfsd_1_nproc;
#define PFSD_VERS ((u_long)1)
#define PFSD_OPEN ((u_long)1)
extern openres *pfsd_open_1();
#define PFSD_SETIOMODE ((u_long)2)
extern setiomoderes *pfsd_setiomode_1();
#define PFSD_GETIOMODE ((u_long)3)
extern iomoderes *pfsd_getiomode_1();
#define PFSD_GETIOID ((u_long)4)
extern getioidres *pfsd_getioid_1();
#define PFSD_IODONE ((u_long)5)
extern iodoneres *pfsd_iodone_1();
#define PFSD_IOWAIT ((u_long)6)
extern iowaitres *pfsd_iowait_1();
#define PFSD_IOOP ((u_long)7)
extern ioopres *pfsd_ioop_1();
#define PFSD_LSIZE ((u_long)8)
extern lsizeres *pfsd_lsize_1();
#define PFSD_ISEOF ((u_long)9)
extern iseofres *pfsd_iseof_1();
#define PFSD_LSEEK ((u_long)10)
extern lseekres *pfsd_lseek_1();
#define PFSD_GETFATTR ((u_long)11)
extern fattrres *pfsd_getfattr_1();
#define PFSD_CLOSE ((u_long)12)
extern closeres *pfsd_close_1();
#define PFSD_NUMCLNTS ((u_long)13)
extern int *pfsd_numclnts_1();
#define PFSD_NUMFILES ((u_long)14)
extern int *pfsd_numfiles_1();
#define PFSD_RESET ((u_long)15)
extern resetres *pfsd_reset_1();
#define PFSD_CLTEXIT ((u_long)16)
extern void *pfsd_cltexit_1();
#define PFSD_PRTSTAT ((u_long)17)
extern void *pfsd_prtstat_1();
#define PFSD_EXIT ((u_long)18)
extern void *pfsd_exit_1();

/* *********************************************************************** */
/*    communication between IOD and the PFSD                               */
/* *********************************************************************** */


struct iodresargs {
	pfslib_fhdl fh;
	int ioID;
	bool_t ok;
	int errno;
	pfslib_data dhb;
};
typedef struct iodresargs iodresargs;
bool_t xdr_iodresargs();

struct iodregargs {
	iod_address addr;
	int pid;
};
typedef struct iodregargs iodregargs;
bool_t xdr_iodregargs();

struct iodregres {
	int stat;
	union {
		errorinfo err;
	} iodregres_u;
};
typedef struct iodregres iodregres;
bool_t xdr_iodregres();

/* *********************************************************************** */
/*    pfsd-program definition (for IOD communication)                      */
/* *********************************************************************** */


#define PFSD_IOD ((u_long)0x399998)
extern struct rpcgen_table pfsd_iod_1_table[];
extern pfsd_iod_1_nproc;
#define PFSD_IOD_VERS ((u_long)1)
#define PFSD_IOD_RESULT ((u_long)1)
extern void *pfsd_iod_result_1();
#define PFSD_IOD_REGISTER ((u_long)2)
extern iodregres *pfsd_iod_register_1();
struct rpcgen_table {
    char	*(*proc)();
    xdrproc_t	xdr_arg;
    unsigned	len_arg;
    xdrproc_t	xdr_res;
    unsigned	len_res;
};
