/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#include <stdio.h>
#include <rpc/rpc.h>
#include "iod.h"
/*****************************************************************************
 *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

#include <errno.h>

#ifdef SUN4
#include <memory.h>
#else
#include <string.h>
#endif /* SUN4 */

#define bzero(a,b) memset(a,0,b)

extern void _iod_pfsd_register
#ifdef ANSI_C
(int port);
#else
();
#endif /* ANSI_C */

#include "auth_ok.c"

/* ***********************************************************************
   define IPPROTP_UDP and IPPROTO_TCP as 0 so that the service won't
   be registered with the portmapper
   *********************************************************************** */

#ifdef IPPROTO_UDP
#undef IPPROTO_UDP
#endif
#define IPPROTO_UDP 0

#ifdef IPPROTO_TCP
#undef IPPROTO_TCP
#endif
#define IPPROTO_TCP 0


static void svc_main
#ifdef ANSI_C
(void);
#else
();
#endif


int main
#ifdef ANSI_C
(void)
#else
()
#endif /* ANSI_C */
{
  /* close all open files */
  int fd;
  for (fd=3; fd<256;fd++) close(fd);
  /* reset errno to ignore result */
  errno = 0;

  /* call the original main */
  svc_main();
  /* Should never return */
  exit(1);
}

/* define main to be able to access the original main procedure */
#ifdef ANSI_C
#define main() static void svc_main(void)
#else
#define main() static void svc_main()
#endif

/* register at the pfsd before calling svc_run() */
static void local_svc_run
#ifdef ANSI_C
(void)
#else
()
#endif /* ANSI_C */
{
  svc_run();
}

#define svc_run  _iod_pfsd_register(transp->xp_port); local_svc_run


static void iod_1();

main()
{
	register SVCXPRT *transp;

	(void) pmap_unset(IOD, IOD_VERS);

	transp = svcudp_create(RPC_ANYSOCK);
	if (transp == NULL) {
		fprintf(stderr, "cannot create udp service.");
		exit(1);
	}
	if (!svc_register(transp, IOD, IOD_VERS, iod_1, IPPROTO_UDP)) {
		fprintf(stderr, "unable to register (IOD, IOD_VERS, udp).");
		exit(1);
	}

	transp = svctcp_create(RPC_ANYSOCK, 0, 0);
	if (transp == NULL) {
		fprintf(stderr, "cannot create tcp service.");
		exit(1);
	}
	if (!svc_register(transp, IOD, IOD_VERS, iod_1, IPPROTO_TCP)) {
		fprintf(stderr, "unable to register (IOD, IOD_VERS, tcp).");
		exit(1);
	}

	svc_run();
	fprintf(stderr, "svc_run returned");
	exit(1);
	/* NOTREACHED */
}

static void
iod_1(rqstp, transp)
	struct svc_req *rqstp;
	register SVCXPRT *transp;
{
	union {
		iod_reqargs iod_request_1_arg;
		iod_ioopargs iod_ioop_1_arg;
		iod_prtstatargs iod_prtstat_1_arg;
	} argument;
	char *result;
	bool_t (*xdr_argument)(), (*xdr_result)();
	char *(*local)();


/* BEGIN PATCH done by Makefile */
if (!auth_ok(rqstp,transp)) return;
/* END PATCH */

	switch (rqstp->rq_proc) {
	case NULLPROC:
		(void) svc_sendreply(transp, xdr_void, (char *)NULL);
		return;

	case IOD_REQUEST:
		xdr_argument = xdr_iod_reqargs;
		xdr_result = xdr_void;
		local = (char *(*)()) iod_request_1;
		break;

	case IOD_IOOP:
		xdr_argument = xdr_iod_ioopargs;
		xdr_result = xdr_iod_ioopres;
		local = (char *(*)()) iod_ioop_1;
		break;

	case IOD_EXIT:
		xdr_argument = xdr_void;
		xdr_result = xdr_void;
		local = (char *(*)()) iod_exit_1;
		break;

	case IOD_PRTSTAT:
		xdr_argument = xdr_iod_prtstatargs;
		xdr_result = xdr_void;
		local = (char *(*)()) iod_prtstat_1;
		break;

	default:
		svcerr_noproc(transp);
		return;
	}
	bzero((char *)&argument, sizeof(argument));
	if (!svc_getargs(transp, xdr_argument, &argument)) {
		svcerr_decode(transp);
		return;
	}
	result = (*local)(&argument, rqstp);

/* BEGIN PATCH done by by Makefile */
/* Send reply only if resul != NULL
* otherwise reply has to be delayed and sent by _do_op()
*/
if (result != NULL) {
if (!svc_sendreply(transp, xdr_result, result)) {
svcerr_systemerr(transp); }}
/* END PATCH */

	if (!svc_freeargs(transp, xdr_argument, &argument)) {
		fprintf(stderr, "unable to free arguments");
		exit(1);
	}
	return;
}
