/******************************************************************************
 *
 *    iod_req.c,v : Handling requests for io operations
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : iod_req.c,v
 *  RCS Date     : 1995/11/23 17:58:58
 *  RCS Revision : 1.6
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef lint
static char rcs_id[] = "iod_req.c,v 1.6 1995/11/23 17:58:58 lamberts Rel";
#endif


#include <sys/types.h>
#include <errno.h>
#include <rpc/rpc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "iod.h"
#include "iod_defines.h"

extern void _del_op
#ifdef ANSI_C
(struct OPLIST *oplel);
#else
();
#endif /* ANSI_C */

extern struct OPLIST *_find_op
#ifdef ANSI_C
(iod_reqargs *argp);
#else
();
#endif /* ANSI_C */

extern int _do_op
#ifdef ANSI_C
(int op, char *fn, int oflags, int foffs, unsigned int iolen, char *wrbuf, bool_t mixio, SVCXPRT *transp);
#else
();
#endif /* ANSI_C */

extern void _iod_pfsd_result
#ifdef ANSI_C
(pfslib_fhdl fh, int ioID, bool_t ok, int err);
#else
();
#endif /* ANSI_C */


static struct REQLIST *firstreq = (struct REQLIST *)0;

static struct REQLIST *lastreq = (struct REQLIST *)0;


void _print_req
#ifdef ANSI_C
(char *filename)
#else
(filename)
char *filename;
#endif /* ANSI_C */
{
  struct REQLIST *rqlel;
  int i;
  
  for (rqlel = firstreq, i=0;
       rqlel != (struct REQLIST *)0;
       rqlel = rqlel->next, i++)
  {
    if ((filename[0] == '\0') ||(strcmp(rqlel->fn,filename) == 0))
    {
      printf("REQLIST ELEMENT %d on iod %d\n",i,(int)getpid());
      printf("\tfh.vfd\t\t: %d\n",rqlel->fh.vfd);
      printf("\tfh.how_many\t: %d\n",rqlel->fh.how_many);
      printf("\tfh.which\t: %d\n",rqlel->fh.which);
      printf("\tfh.mode\t\t: %d\n",rqlel->fh.mode);
      if (rqlel->mixio)
        printf("\tmixio\t\t: TRUE\n");
      else
        printf("\tmixio\t\t: FALSE\n");
      printf("\tfn\t\t: %s\n",rqlel->fn);
      printf("\toflags\t\t: %o\n",rqlel->oflags);
      printf("\tfoffs\t\t: %d\n",(int)rqlel->foffs);
      printf("\tiolen\t\t: %d\n",(int)rqlel->iolen);
      printf("\tioID\t\t: %d\n",rqlel->ioID);
      printf("\thname\t\t: %s\n",rqlel->hname);
      printf("\tuid\t\t: %d\n",rqlel->uid);
      printf("\tgid\t\t: %d\n",rqlel->gid);
      printf("\taup_time\t: %lu\n",rqlel->aup_time);
    }
  }

  return;
}

      

int _ins_req
#ifdef ANSI_C
(iod_reqargs *argp)
#else
(argp)
iod_reqargs *argp;
#endif /* ANSI_C */
{
  struct REQLIST *reqlel;
  
  
  if ((reqlel = (struct REQLIST *)malloc(sizeof(struct REQLIST)))
      == (struct REQLIST *)0)
  {
    perror("_ins_req(): malloc()");
    return (-1);
  }
  
  reqlel->fh       = argp->fh;
  reqlel->mixio    = argp->mixio;
  reqlel->op       = argp->op;
  reqlel->oflags   = argp->oflags;
  reqlel->foffs    = argp->foffs;
  reqlel->iolen    = argp->iolen;
  reqlel->ioID     = argp->ioID;
  reqlel->uid      = argp->uid;
  reqlel->gid      = argp->gid;
  reqlel->aup_time = argp->aup_time;
  strcpy(reqlel->fn,argp->fn);
  strcpy(reqlel->hname, argp->hname);

  if (firstreq == (struct REQLIST *)0)
  {
    reqlel->next = (struct REQLIST *)0;
    reqlel->prev = (struct REQLIST *)0;
    firstreq = reqlel;
    lastreq = reqlel;

    return (0);
  }

  /* Append reqlel at the end of the list of request */
  lastreq->next = reqlel;
  reqlel->prev = lastreq;
  reqlel->next = (struct REQLIST *)0;
  lastreq = reqlel;

  return (0);
}


void _del_req
#ifdef ANSI_C
(struct REQLIST *reqlel)
#else
(reqlel)
struct REQLIST *reqlel;
#endif /* ANSI_C */
{

  struct REQLIST *next = reqlel->next;
  struct REQLIST *prev = reqlel->prev;
  

  if (prev == (struct REQLIST *)0)
    firstreq = next;
  else
    prev->next = reqlel->next;
  
  if (next == (struct REQLIST *)0)
    lastreq = reqlel->prev;
  else
    next->prev = reqlel->prev;

  free(reqlel);
  
  return;
}


struct REQLIST *_find_req
#ifdef ANSI_C
(iod_ioopargs *argp, struct svc_req *rqstp)
#else
(argp, rqstp)
iod_ioopargs *argp;
struct svc_req *rqstp;
#endif /* ANSI_C */
{
  struct REQLIST *reqlel;
  
	struct authunix_parms *unix_cred;

  switch (rqstp->rq_cred.oa_flavor)
  {
  case AUTH_UNIX:
    unix_cred = (struct authunix_parms *)rqstp->rq_clntcred;
    break;
  default:
    return ((struct REQLIST *)0);
  }
  
  for (reqlel = firstreq; reqlel != (struct REQLIST *)0; reqlel = reqlel->next)
  {
    if ((reqlel->op       == argp->op) &&
        (reqlel->ioID     == argp->ioID) &&
        (reqlel->fh.vfd   == argp->fh.vfd) &&
        (reqlel->fh.which == argp->fh.which) &&
        (reqlel->fh.how_many == argp->fh.how_many) &&
        (reqlel->iolen    == argp->iolen) &&
        (reqlel->uid      == unix_cred->aup_uid) &&
        (reqlel->gid      == unix_cred->aup_gid) &&
        (reqlel->aup_time == unix_cred->aup_time) &&
        (strcmp(reqlel->hname,unix_cred->aup_machname) == 0))
      return (reqlel);
  }
  
  return ((struct REQLIST *)0);
}

void *iod_request_1
#ifdef ANSI_C
(iod_reqargs *argp, struct svc_req *rqstp)
#else
(argp, rqstp)
iod_reqargs *argp;
struct svc_req *rqstp;
#endif /* ANSI_C */
{
  struct OPLIST *oplel;

  /* Try to find a matching operation */
  if ((oplel = _find_op(argp)) == (struct OPLIST *)0)
  {
    /* There is no matching operation
     * Insert the request in the list of requests */
    if (_ins_req(argp) < 0)
    {
      fprintf(stderr,"Couldn't insert request\n");
    }

    return (NULL);
  }
  
  /* There is a matching operation
   * execute it. */
  if (_do_op(argp->op, argp->fn, argp->oflags, (off_t)argp->foffs, argp->iolen,
             oplel->data, argp->mixio, oplel->transp) < 0)
    _iod_pfsd_result(argp->fh,argp->ioID,FALSE,errno);
  else
    _iod_pfsd_result(argp->fh,argp->ioID,TRUE,0);

  _del_op(oplel);

  return (NULL);
}

