/******************************************************************************
 *
 *    iod_print.c,v : Print status information of an iod
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : iod_print.c,v
 *  RCS Date     : 1995/11/23 17:58:23
 *  RCS Revision : 1.2
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts
 *
 *****************************************************************************/
#ifndef lint
static char rcs_id[] = "iod_print.c,v 1.2 1995/11/23 17:58:23 lamberts Rel";
#endif

#include <sys/types.h>
#include <rpc/rpc.h>
#include <stdio.h>
#include <unistd.h>

#include "iod.h"


extern void _print_op 
#ifdef ANSI_C
(void);
#else
();
#endif /* ANSI_C */

extern void _print_req
#ifdef ANSI_C
(char *filename);
#else
();
#endif /* ANSI_C */


/* ***************************************************************************
 * RPC to print status information of iod                                    *
 *************************************************************************** */
void *iod_prtstat_1
#ifdef ANSI_C
(iod_prtstatargs *argp, struct svc_req *rqstp)
#else
(argp, rqstp)
iod_prtstatargs *argp;
struct svc_req *rqstp;
#endif /* ANSI_C */
{
  static int result;
  
  printf("STATE of iod %d\n",(int)getpid());
  
  _print_req(argp->filename);
  _print_op();
  
  return (&result);
}
