/******************************************************************************
 *
 *    iod_pfsdrpc.c,v : Communication with PFSD
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : iod_pfsdrpc.c,v
 *  RCS Date     : 1995/11/29 14:50:59
 *  RCS Revision : 1.12
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef lint
static char rcs_id[] = "iod_pfsdrpc.c,v 1.12 1995/11/29 14:50:59 lamberts Rel";
#endif


#include <rpc/rpc.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/tcp.h>
#include <stdio.h>
#include <memory.h>
#include <stdlib.h>
#include <unistd.h>

#include "pfsd.h"

static CLIENT *ioclnt;

void _iod_pfsd_register
#ifdef ANSI_C
(int port)
#else
(port)
int port;
#endif /* ANSI_C */
{
	char           pfsdhost[MAXNLEN];
	iodregargs args;
  iodregres *res;

  struct hostent *hp;
  struct sockaddr_in addr;
  int sockp = RPC_ANYSOCK;

  int sooptarg;
  
	if (gethostname(pfsdhost, MAXNLEN) < 0)
	{
		perror("_iod_pfsd_register: gethostname()");
		exit(1);
	}
  
  if ((hp = gethostbyname(pfsdhost)) == (struct hostent *)0)
  {
    perror("gethostbyname()");
    exit (1);
  }

  memset(&addr, 0, sizeof(struct sockaddr_in));
  addr.sin_family = AF_INET;
  memcpy(&addr.sin_addr, hp->h_addr, (size_t)hp->h_length);
  addr.sin_port = htons(0);
   
  /* make a client connection to the pfsd */

	if ((ioclnt = clnttcp_create(&addr, PFSD_IOD, PFSD_IOD_VERS,
                               &sockp, RPC_IOD_BUFSZ, RPC_IOD_BUFSZ)) == NULL)
	{
		clnt_pcreateerror(pfsdhost);
		exit(1);
	}

  /* Set REUSEADDR */
  sooptarg = 1;
  setsockopt(sockp,SOL_SOCKET,SO_REUSEADDR,(char *)&sooptarg,sizeof(sooptarg));
  /* TCP_NODELAY */
  sooptarg = 1;
  setsockopt(sockp,IPPROTO_TCP,TCP_NODELAY,(char *)&sooptarg,sizeof(sooptarg));

	auth_destroy(ioclnt->cl_auth);
	ioclnt->cl_auth = authunix_create_default();

	/* send the address of my TCP RPC port to the PFSD */

  memset(&args.addr.ipaddr, 0, IPADDRLEN);
	args.addr.hname = pfsdhost;
  args.addr.port = port;
	args.pid  = getpid();

	if ((res = pfsd_iod_register_1(&args, ioclnt)) == NULL)
  {
    clnt_perror(ioclnt,"_iod_pfsd register(): pfsd_iod_register_1()");
    exit (1);
  }
  
  if (res->stat == RPC_ERR)
  {
    fprintf(stderr,"iod_pfsd_register(): pfsd_iod_register_1(): %s\n",
            res->iodregres_u.err.errstr);
    exit(1);
  }
  
#ifdef DEBUG
  fprintf(stderr,"IOD: registered at PFSD with pid %d\n",args.pid);
#endif

  xdr_free(xdr_iodregres, (char *)res);

	return;
}



/* ************************************************************************ */
/* send rpc reply to the pfsd about result of IO                            */
/* ************************************************************************ */

void _iod_pfsd_result
#ifdef ANSI_C
(pfslib_fhdl fh, int ioID, bool_t ok, int err)
#else
(fh, ioID, ok, err)
pfslib_fhdl fh;
int ioID;
bool_t ok;
int err;
#endif /* ANSI_C */
{
  iodresargs args;
  
  char dhb[RPC_IOD_BUFSZ];

  /* LAMBO: RPC argument zusammenbasteln!!! */

  args.fh = fh;
  args.ioID = ioID;
  args.ok = ok;
  args.errno = err;
  args.dhb.pfslib_data_val = dhb;
  args.dhb.pfslib_data_len = RPC_IOD_BUFSZ;

	if (pfsd_iod_result_1(&args, ioclnt) == NULL)
  {
    clnt_perror(ioclnt,"_iod_pfsd_result(): pfsd_iod_result_1()");
    
    exit (1);
  }
  
	return;
}




