/******************************************************************************
 *
 *    iod_op.c,v : handling io operations
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : iod_op.c,v
 *  RCS Date     : 1995/11/23 17:57:56
 *  RCS Revision : 1.9
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef lint
static char rcs_id[] = "iod_op.c,v 1.9 1995/11/23 17:57:56 lamberts Rel";
#endif

#include <rpc/rpc.h>
#include <sys/types.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>

#include "iod.h"
#include "iod_defines.h"
#include "pfslib_errno.h"

extern void _iod_pfsd_result
#ifdef ANSI_C
(pfslib_fhdl, int, bool_t, int);
#else
();
#endif /* ANSI_C */
extern struct REQLIST *_find_req
#ifdef ANSI_C
(iod_ioopargs *, struct svc_req *);
#else
();
#endif /* ANSI_C */
extern void _del_req
#ifdef ANSI_C
(struct REQLIST *);
#else
();
#endif /* ANSI_C */


static struct OPLIST *firstop = (struct OPLIST *)0;

static struct OPLIST *lastop = (struct OPLIST *)0;


void _print_op 
#ifdef ANSI_C
(void)
#else
()
#endif /* ANSI_C */
{
  struct OPLIST *oplel;
  int i;
  
  for (oplel = firstop, i=0;
       oplel != (struct OPLIST *)0;
       oplel = oplel->next, i++)
  {
    printf("OPLIST ELEMENT %d on iod %d\n",i,(int)getpid());
    switch (oplel->op)
    {
    case READ_OP:
      printf("\top\t\t: READ_OP\n");
      break;
    case READV_OP:
      printf("\top\t\t: READV_OP\n");
      break;
    case WRITE_OP:
      printf("\top\t\t: WRITE_OP\n");
      break;
    case WRITEV_OP:
      printf("\top\t\t: WRITEV_OP\n");
      break;
    default:
      printf("\top\t\t: UNKOWN\n");
      break;
    }
    printf("\tioID\t\t: %d\n",oplel->ioID);
    printf("\tfh.vfd\t\t: %d\n",oplel->fh.vfd);
    printf("\tfh.how_many\t: %d\n",oplel->fh.how_many);
    printf("\tfh.which\t: %d\n",oplel->fh.which);
    printf("\tfh.mode\t\t: %d\n",oplel->fh.mode);
    printf("\tiolen\t\t: %u\n",oplel->iolen);
    if (oplel->data == NULL)
      printf("\tdata\t\t: NULL\n");
    else
      printf("\tdata\t\t: SET\n");
    printf("\thname\t\t: %s\n",oplel->hname);
    printf("\tuid\t\t: %d\n",oplel->uid);
    printf("\tgid\t\t: %d\n",oplel->gid);
    printf("\taup_time\t: %lu\n",oplel->aup_time);
    if (oplel->transp == NULL)
      printf("\ttransp\t\t: NULL\n");
    else
      printf("\ttransp\t\t: SET\n");
  }

  return;
}


static int _ins_op
#ifdef ANSI_C
(iod_ioopargs *argp, struct svc_req *rqstp)
#else
(argp, rqstp)
iod_ioopargs *argp;
struct svc_req *rqstp;
#endif /* ANSI_C */
{
  struct OPLIST *oplel;
  
	struct authunix_parms *unix_cred;

  switch (rqstp->rq_cred.oa_flavor)
  {
  case AUTH_UNIX:
    unix_cred = (struct authunix_parms *)rqstp->rq_clntcred;
    break;
  default:
    return (-1);
  }
  
  if ((oplel = (struct OPLIST *)malloc(sizeof(struct OPLIST)))
      == (struct OPLIST *)0)
  {
    perror("_ins_op(): malloc()");
    return (-1);
  }
  
  oplel->op       = argp->op;
  oplel->ioID     = argp->ioID;
  oplel->fh       = argp->fh;
  oplel->iolen    = argp->iolen;
  oplel->uid      = unix_cred->aup_uid;
  oplel->gid      = unix_cred->aup_gid;
  oplel->aup_time = unix_cred->aup_time;
  oplel->transp   = rqstp->rq_xprt;

  strcpy(oplel->hname,unix_cred->aup_machname);
  
  if ((oplel->iolen > (unsigned int)0) && (oplel->iolen <= MAXDATALEN) &&
      ((oplel->op == WRITE_OP) || (oplel->op == WRITEV_OP)))
  {
    if ((oplel->data = malloc(oplel->iolen)) == (char *)0)
    {
      perror("_ins_op(): malloc()");
      return (-1);
    }
    memcpy(oplel->data,argp->data.pfslib_data_val,oplel->iolen);
  }
  else
    oplel->data = (char *)0;
  
  if (firstop == (struct OPLIST *)0)
  {
    oplel->next = (struct OPLIST *)0;
    oplel->prev = (struct OPLIST *)0;
    firstop = oplel;
    lastop = oplel;

    return (0);
  }

  /* Append oplel at the end of the list of operations */
  lastop->next = oplel;
  oplel->prev = lastop;
  oplel->next = (struct OPLIST *)0;
  lastop = oplel;

  return (0);
}


void _del_op
#ifdef ANSI_C
(struct OPLIST *oplel)
#else
(oplel)
struct OPLIST *oplel;
#endif /* ANSI_C */
{

  struct OPLIST *next = oplel->next;
  struct OPLIST *prev = oplel->prev;
  

  if (prev == (struct OPLIST *)0)
    firstop = next;
  else
    prev->next = oplel->next;
  
  if (next == (struct OPLIST *)0)
    lastop = oplel->prev;
  else
    next->prev = oplel->prev;

  if (oplel->data != (char *)0)
    free(oplel->data);
  free(oplel);
  
  return;
}


struct OPLIST *_find_op
#ifdef ANSI_C
(iod_reqargs *argp)
#else
(argp)
iod_reqargs *argp;
#endif /* ANSI_C */
{
  struct OPLIST *oplel;
  
  
  for (oplel = firstop; oplel != (struct OPLIST *)0; oplel = oplel->next)
  {
    if ((oplel->op       == argp->op) &&
        (oplel->ioID     == argp->ioID) &&
        (oplel->fh.vfd   == argp->fh.vfd) &&
        (oplel->fh.which == argp->fh.which) &&
        (oplel->fh.how_many == argp->fh.how_many) &&
        (oplel->iolen    == argp->iolen) &&
        (oplel->uid      == argp->uid) &&
        (oplel->gid      == argp->gid) &&
        (oplel->aup_time == argp->aup_time) &&
        (strcmp(oplel->hname,argp->hname) == 0))
      return (oplel);
  }
  
  return ((struct OPLIST *)0);
}


int _do_op
#ifdef ANSI_C
(int op, char *fn, int oflags, int foffs, unsigned int iolen, char *wrbuf,
 bool_t mixio, SVCXPRT *transp)
#else
(op, fn, oflags, foffs, iolen, wrbuf, mixio, transp)
int op;
char *fn;
int oflags;
off_t foffs;
unsigned int iolen;
char *wrbuf;
bool_t mixio;
SVCXPRT *transp;
#endif /* ANSI_C */
{
  int fd = -1;
  static iod_ioopres result;
  static char rdbuf[MAXDATALEN];
  int iolenres;
  
  /*
  xdr_free(xdr_iod_ioopres, (char *)&result);
  */

  if (mixio)
  {
    errno = EPFSLMIXIO;
    result.stat = RPC_ERR;
  }

  else if (iolen == 0)
  {
    result.stat = RPC_OK;
    result.iod_ioopres_u.res.iolen = 0;
    result.iod_ioopres_u.res.data.pfslib_data_val = "";
    result.iod_ioopres_u.res.data.pfslib_data_len = 0;
  }    

  else if ((fd = open(fn,oflags & ~(O_APPEND|O_CREAT|O_EXCL|O_TRUNC))) < 0)
  {
    perror("_do_op(): open()");
    result.stat = RPC_ERR;
  }
  
  else if (lseek(fd,foffs, SEEK_SET) < 0)
  {
    perror("_do_op(): lseek()");
    result.stat = RPC_ERR;
  }

  else if (iolen > MAXDATALEN)
  {
    /* LAMBO: Send or receive the data differently */
    errno = EPFSLIOLEN;
    perror("_do_op(): iolen too long");
    result.stat = RPC_ERR;
  }
  
  else switch (op)
  {
  case WRITE_OP:
  case WRITEV_OP:
    if ((iolenres = write(fd,wrbuf,iolen)) < 0)
    {
      perror("_do_op(): write()");
      result.stat = RPC_ERR;
    }
    else 
    {
      result.stat = RPC_OK;
      result.iod_ioopres_u.res.iolen = iolenres;
      result.iod_ioopres_u.res.data.pfslib_data_val = "";
      result.iod_ioopres_u.res.data.pfslib_data_len = 0;
    }
    break;

  case READ_OP:
  case READV_OP:
    if ((iolenres = read(fd,rdbuf,iolen)) < 0)
    {
      perror("_do_op(): read()");
      result.stat = RPC_ERR;
    }
    else 
    {
      result.stat = RPC_OK;
      result.iod_ioopres_u.res.iolen = iolenres;
      result.iod_ioopres_u.res.data.pfslib_data_val = rdbuf;
      result.iod_ioopres_u.res.data.pfslib_data_len = iolenres;
    }
    break;

  default:
    errno = EPFSLINVAL;
    perror("_do_op(): no such operation");
    result.stat = RPC_ERR;
    break;
  }
  
  /* Close filepointer */
  if (fd > 0) close(fd);

  if (result.stat == RPC_ERR)
  {
    result.stat = RPC_ERR;
    result.iod_ioopres_u.err.errno = errno;
    result.iod_ioopres_u.err.errstr = "";
  }    

  if (!svc_sendreply(transp, xdr_iod_ioopres, (char *)&result))
    svcerr_systemerr(transp);
  
  if (result.stat == RPC_ERR)
    return (-1);
  
  return (0);
}


iod_ioopres *iod_ioop_1
#ifdef ANSI_C
(iod_ioopargs *argp, struct svc_req *rqstp)
#else
(argp, rqstp)
iod_ioopargs *argp;
struct svc_req *rqstp;
#endif /* ANSI_C */
{
  static iod_ioopres result;
  struct REQLIST *reqlel;
  
  /*
  xdr_free(xdr_iod_ioopres, (char *)&result);
  */

  /* Check data */
  if (((argp->op == WRITE_OP) || (argp->op == WRITEV_OP)) &&
      (argp->iolen >= MAXDATALEN) &&
      (argp->iolen != argp->data.pfslib_data_len))
  {
    result.stat = RPC_ERR;
    result.iod_ioopres_u.err.errno = EPFSLINVAL;
    result.iod_ioopres_u.err.errstr = "";

    return (&result);
  }
    
  /* Try to find a matching request */
  if ((reqlel = _find_req(argp,rqstp)) == (struct REQLIST *)0)
  {
    /* There is no matching request */
    /* Insert the operation in the list of operations */
    if (_ins_op(argp, rqstp) < 0)
    {
      result.stat = RPC_ERR;
      result.iod_ioopres_u.err.errno = errno;
      result.iod_ioopres_u.err.errstr = "";

      return (&result);
    }
    
    /* LAMBO: Verz"ogere die Ausf"uhrung und das Zur"uckliefern des
     * Ergebnisses bis der entsprechenede Request eintrifft. */

    return ((iod_ioopres *)0);
  }


  /* There is a matching request.
   * Execute the operation and delete the request. */
  if (_do_op(reqlel->op, reqlel->fn, reqlel->oflags, reqlel->foffs,
             reqlel->iolen, argp->data.pfslib_data_val, reqlel->mixio,
             rqstp->rq_xprt) < 0)
    /* Notify pfsd */
    _iod_pfsd_result(reqlel->fh,reqlel->ioID,FALSE,errno);
  else
    _iod_pfsd_result(reqlel->fh,reqlel->ioID,TRUE,0);

  _del_req(reqlel);

  return ((iod_ioopres *)0);
}
