/******************************************************************************
 *
 *    iod_defines.h,v : definitions for iod
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : iod_defines.h,v
 *  RCS Date     : 1995/11/29 14:08:21
 *  RCS Revision : 1.6
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef __pfslib_iod_defines_h__
#define __pfslib_iod_defines_h__

#ifndef lint
static char rcs_id_iod_defines[] = "iod_defines.h,v 1.6 1995/11/29 14:08:21 lamberts Rel";
#endif


/* *********************************************************************** */
/*      Internal structures of the iod                                     */ 
/* *********************************************************************** */

struct REQLIST
{
  pfslib_fhdl     fh;

  bool_t          mixio;        /* Errorcode in case of EMIXIO */
  int             op;           /* operation */

  char            fn[MAXNLEN];  /* filename to read from or write to */
  int             oflags;       /* openflags of the file */
  off_t           foffs;        /* offset to seek for filepointer */

  unsigned int    iolen;        /* number of bytes */
  int             ioID;         /* ioID of the pfsd for this job*/

  char            hname[MAXNLEN]; /* Hostname of client */
  int             uid;          /* Userid of client */
  int             gid;          /* Groupid of client */
  u_long          aup_time;     /* Client Unix authenification creation time */

  struct REQLIST *next;
  struct REQLIST *prev;
};


struct OPLIST
{
  int            op;            /* operation */
  
  int            ioID;          /* ioID of the pfsd for this job */
  pfslib_fhdl    fh;

  unsigned int   iolen;         /* length of io operation */


  char          *data;          /* data */

  char           hname[MAXNLEN]; /* Hostname of client */
  int            uid;           /* Userid of client */
  int            gid;           /* Groupid of client */
  u_long         aup_time;      /* Client Unix authenification creation time */

  SVCXPRT       *transp;
  struct OPLIST *next;
  struct OPLIST *prev;
};


#endif /* __pfslib_iod_defines_h__ */
