/*****************************************************************************
 *
 *    iod.x,v RPC specification file of the IO daemon.
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    This file is part of PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/*****************************************************************************
 *
 *  RCS Filename : iod.x,v
 *  RCS Date     : 1995/11/29 14:49:37
 *  RCS Revision : 1.9
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/

%/*****************************************************************************
% *
% *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
% *
% *    PFSLib (Parallel I/O on workstations)
% *
% *    PFSLib offers parallel access to files for a parallel application
% *    running on a cluster of workstations.
% *    It is intended but not restricted to be used in message passing
% *    applications based on PVM, NXLib, MPI, and other.
% *
% *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
% *
% *    PFSLib is free software; you can redistribute the LIBRARY and/or
% *    modify it under the terms of the GNU Library General Public
% *    License as published by the Free Software Foundation; either
% *    version 2 of the License, or (at your option) any later version.
% *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
% *    and/or modify them under the terms of the GNU General Public
% *    License as published by the Free Software Foundation; either
% *    version 2 of the License, or (at your option) any later version.
% *
% *    PFSLib is distributed in the hope that it will be useful,
% *    but WITHOUT ANY WARRANTY; without even the implied warranty of
% *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% *    Library General Public License and GNU General Public License 
% *    for more details.
% *
% *    You should have received a copy of the GNU Library General Public
% *    License and the GNU General Public License along with this
% *    library; if not, write to the Free 
% *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
% *
% *    Contact to the authors:
% *
% *    electronic mail: pfslib@informatik.tu-muenchen.de
% *
% *    paper mail:      Prof. Dr. A. Bode
% *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
% *                     Institut f"ur Informatik
% *                     Technische Universit"at M"unchen
% *                     80290 M"unchen
% *                     Germany
% *
% *    This project was partially funded by a research grant form Intel
% *    Corporation. 
% *
% *****************************************************************************/


#ifdef RPC_HDR
%
%#ifdef HPPA
%#include <sys/time.h>
%#include <sys/types.h>
%#endif /* HPPA */
%
%/* *********************************************************************** */
%/*    communication between IOD and  PFSD                                  */
%/* *********************************************************************** */
%
#endif /*  */

#ifdef RPC_XDR
%
%/* ********************************************************************** */
%/* define names of xdr routines to avoid confilcts with pfsd_xdr.c        */
%/* ********************************************************************** */
%
%#define xdr_errorinfo xdr_errorinfo_iod
%#define xdr_pfslib_data xdr_pfslib_data_iod
%#define xdr_pfslib_fhdl xdr_pfslib_fhdl_iod
%#define xdr_iod_address xdr_iod_address_iod
%#define xdr_pfslib_fattr xdr_pfslib_fattr_iod
%#define xdr_pfslib_ipaddr xdr_pfslib_ipaddr_iod
%
#endif


#include "../include/global_rpc.h"


struct iod_reqargs
{
  pfslib_fhdl fh;
  bool        mixio;            /* Errorcode in case of EMIXIO */
  int         op;               /* operation */

  string      fn<MAXNLEN>;      /* filename to read from or write to */
  pfslib_otype oflags;          /* openflags of the file */
  u_int       foffs;            /* offset to seek for filepointer */

  u_int       iolen;            /* number of bytes */
  int         ioID;             /* ioID of the pfsd for this job*/

  string      hname<MAXNLEN>;   /* Hostname of client */
  int         uid;              /* Userid of client */
  int         gid;              /* Groupid of client */
  u_long      aup_time;         /* Client Unix authenification
                                   creation time */
  pfslib_data dhb;              /* Dirty Hack Buffer
                                   Send additional data to force sending of
                                   the RPC request */
};

struct iod_ioopargs
{
  int         op;               /* operation */
  
  int         ioID;             /* ioID of the pfsd for this job */
  pfslib_fhdl fh;
  
  u_int       iolen;            /* length of io operation */

  pfslib_data data;             /* data to be written to the file */
};


struct iod_prtstatargs
{
  string filename<MAXNLEN>;
};


#ifdef RPC_HDR
%
%/* *********************************************************************** */
%/*     define the function results                                         */
%/* *********************************************************************** */
%
#endif /* RPC_HDR */

struct iod_opres
{
  u_int       iolen;
  pfslib_data data;
};

union iod_ioopres switch (int stat)
{
 case RPC_OK:
  iod_opres res;
 case RPC_ERR:
  errorinfo err;
 default:
  void;
};

#ifdef RPC_HDR
%
%/* *********************************************************************** */
%/*    pfsd-program definition (for IOserver communication)                  */
%/* *********************************************************************** */
%
#endif

#ifdef RPC_SVC
%
%#include <errno.h>
%
%#ifdef SUN4
%#include <memory.h>
%#else
%#include <string.h>
%#endif /* SUN4 */
%
%#define bzero(a,b) memset(a,0,b)
%
%extern void _iod_pfsd_register
%#ifdef ANSI_C
%(int port);
%#else
%();
%#endif /* ANSI_C */
%
%#include "auth_ok.c"
%
%/* ***********************************************************************
%   define IPPROTP_UDP and IPPROTO_TCP as 0 so that the service won't
%   be registered with the portmapper
%   *********************************************************************** */
%
%#ifdef IPPROTO_UDP
%#undef IPPROTO_UDP
%#endif
%#define IPPROTO_UDP 0
%
%#ifdef IPPROTO_TCP
%#undef IPPROTO_TCP
%#endif
%#define IPPROTO_TCP 0
%
%
%static void svc_main
%#ifdef ANSI_C
%(void);
%#else
%();
%#endif
%
%
%int main
%#ifdef ANSI_C
%(void)
%#else
%()
%#endif /* ANSI_C */
%{
%  /* close all open files */
%  int fd;
%  for (fd=3; fd<256;fd++) close(fd);
%  /* reset errno to ignore result */
%  errno = 0;
%
%  /* call the original main */
%  svc_main();
%  /* Should never return */
%  exit(1);
%}
%
%/* define main to be able to access the original main procedure */
%#ifdef ANSI_C
%#define main() static void svc_main(void)
%#else
%#define main() static void svc_main()
%#endif
%
%/* register at the pfsd before calling svc_run() */
%static void local_svc_run
%#ifdef ANSI_C
%(void)
%#else
%()
%#endif /* ANSI_C */
%{
%  svc_run();
%}
%
%#define svc_run  _iod_pfsd_register(transp->xp_port); local_svc_run
%
#endif /* RPC_SVC */

#ifdef RPC_CLNT
%
%
%#ifdef SUN4
%#include <memory.h>
%#else
%#include <string.h>
%#endif /* SUN4 */
%
%#define bzero(a,b) memset(a,0,b)
%
%/* Zero timeout */
%static struct timeval ZTIMEOUT = { 0, 0 };
%
#endif

program IOD {
  version IOD_VERS {
    void          IOD_REQUEST  (iod_reqargs)     = 1;
    iod_ioopres   IOD_IOOP     (iod_ioopargs)    = 2;
    void          IOD_EXIT     (void)            = 3;
    void          IOD_PRTSTAT  (iod_prtstatargs) = 4;
  } = 1;
} = 0x399999;

