/******************************************************************************
 *
 *    pfslib_errno.h,v : PFSLib error numbers
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : pfslib_errno.h,v
 *  RCS Date     : 1995/11/21 14:18:40
 *  RCS Revision : 1.6
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef __pfslib_errno_h__
#define __pfslib_errno_h__

#ifndef lint
static char rcs_id_pfslib_errno[] = "pfslib_errno.h,v 1.6 1995/11/21 14:18:40 lamberts Rel";
#endif


#define PFSLERR        1000    /* offset for errno */

#define EPFSLACCESS    PFSLERR+0 /* PFSLib: Permission denied */
#define EPFSLAPPEND    PFSLERR+1 /* PFSLib: O_APPEND is not yet supported */
#define EPFSLAUTH      PFSLERR+2 /* PFSLib: Incorrect authentification */
#define EPFSLBADID     PFSLERR+3 /* PFSLib: Bad I/O id */
#define EPFSLBADF      PFSLERR+4 /* PFSLib: Bad file number */
#define EPFSLBADFH     PFSLERR+5 /* PFSLib: Bad filehandle */
#define EPFSLBADFT     PFSLERR+6 /* PFSLib: Filetype not supported */
#define EPFSLINVAL     PFSLERR+7 /* PFSLib: invalid argument */
#define EPFSLIODCNT    PFSLERR+8 /* PFSLib: Too many I/O daemons specified */
#define EPFSLIOLEN     PFSLERR+9 /* PFSLib: Too large I/O operation  */
#define EPFSLMFILE     PFSLERR+10 /* PFSLib: Too many open files */
#define EPFSLMIXIO     PFSLERR+11 /* PFSLib: Mixed file operations */
#define EPFSLMREQUEST  PFSLERR+12 /* PFSLib: Too many outstanding request */
#define EPFSLNDELAY    PFSLERR+13 /* PFSLib: O_NDELAY is not supported */
#define EPFSLNOIOD     PFSLERR+14 /* PFSLib: Couldn't get an I/O daemon */
#define EPFSLNOTIOD    PFSLERR+15 /* PFSLib: I/O daemon doesn't exist */
#define EPFSLPENDAS    PFSLERR+16 /* PFSLib: Unreleased I/O id's */
#define EPFSLCHLDSIG   PFSLERR+17 /* PFSLib: Asynchronous I/O process terminated by signal */
#define EPFSLCHLDEXIT  PFSLERR+18 /* PFSLib: Asynchronous I/O process terminated unsuccessfuly */
#define EPFSLNOCHLD    PFSLERR+19 /* PFSLib: Asynchronous I/O process doesn't exist */
#define EPFSLREMOTE    PFSLERR+20 /* PFSLib: Error on the server side */
#define EPFSLNBYTES    PFSLERR+21 /* PFSLib: Read or written to few data */
#define PFSLMAXERR     PFSLERR+21

#ifdef DEFINE_ERRLIST
char *pfslib_errlist[] =
{
  "PFSLib: Permission denied",
  "PFSLib: O_APPEND is not supported",
  "PFSLib: Incorrect authentification",
  "PFSLib: Bad I/O id",
  "PFSLib: Bad file number",
  "PFSLib: Bad filehandle",
  "PFSLib: Filetype not supported",
  "PFSLib: invalid argument",
  "PFSLib: Too many I/O daemons specified",
  "PFSLib: Too large I/O operation ",
  "PFSLib: Too many open files",
  "PFSLib: Mixed file operations",
  "PFSLib: Too many outstanding request",
  "PFSLib: O_NDELAY is not supported",
  "PFSLib: Couldn't get an I/O daemon",
  "PFSLib: I/O daemon doesn't exist",
  "PFSLib: Unreleased I/O id's",
  "PFSLib: Asynchronous I/O process terminated by signal",
  "PFSLib: Asynchronous I/O process terminated unsuccessfuly",
  "PFSLib: Asynchronous I/O process doesn't exist",
  "PFSLib: Error on the server side",
  "PFSLib: Read or written to few data"
};
#else
extern char *pfslib_errlist[];
#endif


#endif /* __pfslib_errno_h__ */
