/******************************************************************************
 *
 *    pfslib.h,v : include file for applications using PFSLib
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : pfslib.h,v
 *  RCS Date     : 1995/11/19 16:55:58
 *  RCS Revision : 1.7
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef __pfslib_h__
#define __pfslib_h__

#ifndef lint
static char rcs_id_pfslib[] = "pfslib.h,v 1.7 1995/11/19 16:55:58 lamberts Rel";
#endif

#include <sys/types.h>
#include <sys/uio.h>

#ifdef __STDC__
#define _PH(a) a
#else
#define _PH(a) ()
#endif

#define M_UNIX   0
#define M_LOG    1
#define M_RECORD 2
#define M_SYNC   3
#define M_GLOBAL 4

/* lsize operation flags */
#define SIZE_SET 0
#define SIZE_CUR 1
#define SIZE_END 2


/* structure for pfslib file stat */

struct pfslib_attr {
	int       type;
	u_short   amode;
	short     nlink;
	short     userid;
	short     groupid;
	long      size;
	long      atime;
	long      mtime;
	long      ctime;
};

/* Paragon(TM) library calls */

extern void   cread        _PH((int fd, char *buffer, unsigned int nbytes));
extern long  _cread        _PH((int fd, char *buffer, unsigned int nbytes));
extern void   creadv       _PH((int fd, struct iovec *iov, int iovcnt));
extern long  _creadv       _PH((int fd, struct iovec *iov, int iovcnt));
extern void   cwrite       _PH((int fd, char *buffer, unsigned int nbytes));
extern long  _cwrite       _PH((int fd, char *buffer, unsigned int nbytes));
extern void   cwritev      _PH((int fd, struct iovec *iov, int iovcnt));
extern long  _cwritev      _PH((int fd, struct iovec *iov, int iovcnt));
extern int    gopen        _PH((char *path, int oflags, int iomode,
                                mode_t mode));
extern int   _gopen        _PH((char *path, int oflags, int iomode,
                                mode_t mode));
extern long   iodone       _PH((long id));
extern long  _iodone       _PH((long id));
extern long   iomode       _PH((int fd));
extern long  _iomode       _PH((int fd));
extern void   iowait       _PH((long id));
extern long  _iowait       _PH((long id));
extern long   iread        _PH((int fd, char *buffer, unsigned int nbytes));
extern long  _iread        _PH((int fd, char *buffer, unsigned int nbytes));
extern long   ireadv       _PH((int fd, struct iovec *iov, int iovcnt));
extern long  _ireadv       _PH((int fd, struct iovec *iov, int iovcnt));
extern long   iseof        _PH((int fd));
extern long  _iseof        _PH((int fd));
extern long   iwrite       _PH((int fd, char *buffer, unsigned int nbytes));
extern long  _iwrite       _PH((int fd, char *buffer, unsigned int nbytes));
extern long   iwritev      _PH((int fd, struct iovec *iov, int iovcnt));
extern long  _iwritev      _PH((int fd, struct iovec *iov, int iovcnt));
extern long   lsize        _PH((int fd, off_t offset, int whence));
extern long  _lsize        _PH((int fd, off_t offset, int whence));
extern void  setiomode     _PH((int fd, int iomode));
extern long _setiomode     _PH((int fd, int iomode));

/* PFSLib library calls */

extern int    pfslib_close _PH((int fd));
extern int   _pfslib_close _PH((int fd));
extern void   pfslib_init  _PH((char *host, int nclient, int mynumber));
extern void  _pfslib_init  _PH((char *host, int nclient, int mynumber,
                                int svr_thr, int clt_thr));
extern off_t  pfslib_lseek _PH((int fd, off_t offset, int whence));
extern off_t _pfslib_lseek _PH((int fd, off_t offset, int whence));
extern int    pfslib_open  _PH((char *fn, int oflags, mode_t perm));
extern int   _pfslib_open  _PH((char *fn, int oflags, mode_t perm,
                                int iomode, int nclient, int mynumber,
                                int global));
extern int    pfslib_stat  _PH((int fd, struct pfslib_attr *buffer));

/* defines due to the possibility of using shared and private files */

#define lseek  pfslib_lseek
#define open   pfslib_open
#define close  pfslib_close

#undef _PH

#endif /* __pfslib_h__ */
