/******************************************************************************
 *
 *    global_rpc.h,v : global definitions for RPC files
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : global_rpc.h,v
 *  RCS Date     : 1995/11/29 14:41:53
 *  RCS Revision : 1.8
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef __pfslib_global_rpc_h__
#define __pfslib_global_rpc_h__


#define MAXNLEN 1024            /* Max length of an arbitrary name */

#define RPC_ERR -1              /* RCP returned with an error */
#define RPC_OK  0               /* RCP returned  successfuly */

#ifdef RPC_HDR
%
%#include "global.h"
%
#endif

#ifdef RPC_HDR
%
%/* Flags for open() call */
%typedef int pfslib_otype;
%bool_t xdr_pfslib_otype();
%
#endif /* RPC_HDR */


/* errorinfo: structure in case of an error */
struct errorinfo
{
  int       errno;
  string    errstr<MAXERRLEN>;
};

/* pfslib_data: IO data */
typedef opaque pfslib_data<MAXDATALEN>;

/* pfslib_fhdl: result of open */
struct pfslib_fhdl
{
  int  vfd;
  int  how_many;
  int  which;
  int  mode;   /* LAMBO mode mu"s noch "uberall eingetragen werden */
};


/* address: simple a port number, hostname and IP address */
const IPADDRLEN = 4;
typedef opaque pfslib_ipaddr[IPADDRLEN];

struct iod_address
{
  string hname<MAXNLEN>;
  int    port;
  pfslib_ipaddr ipaddr;         /* IP address 4 bytes shoud be enough */
};

struct pfslib_fattr
{
  int       type;
  int       amode;
  int       nlink;
  int       userid;
  int       groupid;
  long      size;
  long      atime;
  long      mtime;
  long      ctime;
  int       actual;
};

#endif /* __pfslib_global_rpc_h__ */
