/******************************************************************************
 *
 *    global.h,v : global definitions
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : global.h,v
 *  RCS Date     : 1995/11/29 14:07:03
 *  RCS Revision : 1.9
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef __pfslib_global_h__
#define __pfslib_global_h__

#ifndef lint
static char rcs_id_global[] = "global.h,v 1.9 1995/11/29 14:07:03 lamberts Rel";
#endif


#define M_UNIX   0
#define M_LOG    1
#define M_RECORD 2
#define M_SYNC   3
#define M_GLOBAL 4

/* lsize operation flags */
#define SIZE_SET 0
#define SIZE_CUR 1
#define SIZE_END 2


#define RPC_IOD_BUFSZ 1024      /* Buffer size for RPC between IOD and PFSD */

#define MAXDATALEN 5000000      /* Max data length for RPC */
#define MAXNLEN 1024            /* Max length of an arbitrary name */
#define MAXERRLEN  1024         /* Max length of an error message */


#define RPC_ERR -1              /* RCP returned with an error */
#define RPC_OK  0               /* RCP returned  successfuly */

#define WRITE_OP  0             /* Write operation */
#define READ_OP   1             /* Read operation */
#define WRITEV_OP 2             /* Write vector operation */
#define READV_OP  3             /* Read vector operation */

/* Flags for open() call */

#define PFSLIB_O_RDONLY   0x0000
#define PFSLIB_O_WRONLY   0x0001
#define PFSLIB_O_RDWR     0x0002
#define PFSLIB_O_NDELAY   0x0004
#define PFSLIB_O_APPEND   0x0008
#define PFSLIB_O_CREAT    0x0200
#define PFSLIB_O_TRUNC    0x0400
#define PFSLIB_O_EXCL     0x0800
#define PFSLIB_O_SYNC     0x2000
#define PFSLIB_O_NONBLOCK 0x4000
#define PFSLIB_O_NOCTTY   0x8000


#endif /* __pfslib_global_h__ */
