/******************************************************************************
 *
 *    auth_ok.c,v : Authentification of clients
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : auth_ok.c,v
 *  RCS Date     : 1995/11/29 14:08:09
 *  RCS Revision : 1.3
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef __pfslib_auth_ok_c__
#define __pfslib_auth_ok_c__

#ifndef lint
static char rcs_id_auth_ok[] = "auth_ok.c,v 1.3 1995/11/29 14:08:09 lamberts Rel";
#endif

#include <sys/types.h>
#include <unistd.h>

static bool_t auth_ok
#ifdef ANSI_C
(struct svc_req *rqstp, SVCXPRT *transp)
#else
(rqstp, transp)
struct svc_req *rqstp;
SVCXPRT *transp;
#endif /* ANSI_C */
{
	struct authunix_parms *unix_cred;
	int uid, gid;
#ifdef DES_AUTH
	struct authdes_cred *des_cred;
  int gidlen, gidlist[10];
#endif /* DES_AUTH */

	/* ******************************************* */
	/* detecting the authentication                */
	/* ******************************************* */

	switch (rqstp->rq_cred.oa_flavor) {
#ifdef DES_AUTH
#ifndef HPPA
	case AUTH_DES:
		des_cred = (struct authdes_cred *) rqstp->rq_clntcred;
		if (!netname2user(des_cred->adc_fullname.name, &uid, &gid, &gidlen, gidlist))
		{
			fprintf(stderr,"auth_ok(): unknown user: %s\n",des_cred->adc_fullname.name);
			svcerr_weakauth(transp);
			return (FALSE);
		}
		break;
#endif /* ! HPPA */
#endif /* DES_AUTH */
	case AUTH_UNIX:
		unix_cred = (struct authunix_parms *) rqstp->rq_clntcred;
		uid = unix_cred->aup_uid;
		gid = unix_cred->aup_gid;
		break;
	case AUTH_NULL:
		break;
	default:
		if (rqstp->rq_proc != NULLPROC)
			svcerr_weakauth(transp);
		return (FALSE);
	}

  if (rqstp->rq_proc != NULLPROC)
  {
    if ((uid != getuid()) ||
        (gid != getgid()))
    {
      fprintf(stderr,"auth_ok(): wrong uid (%d) or gid (%d)\n",uid,gid);
      svcerr_weakauth(transp);
      return (FALSE);
    }
  }
  return (TRUE);
}  

#endif /* __pfslib_auth_ok_c__ */
