

#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <pfslib.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <stdlib.h>
#ifdef NXLIB
#include <nx.h>
#endif


#define TESTFILE "/tmp/tstfile"
#define INPUTFILE "/tmp/inputfile"
#define INPUTFILEV "/tmp/inputfilev"
#define OUTPUTFILE "/tmp/outputfile"
#define OUTPUTFILEV "/tmp/outputfilev"
#define prtmsg printf
#define BUFFSIZE 10000
#define PERMMODES "glgrgsgulrlslursrusug"
#define PERMOP "ciws"
extern char *optarg;

char *pfsdhost = "sunbode25";
int numclnts = 1;
int svc_thr  = -1;
int clt_thr  = -1;
int iterations = 2;
int mynum      = 0;
int length     = 1;             /* 1 */
int vectorlength = 1;           /* 1 */
int vectorcnt = 2;              /* 2 */
int append = 0;
int nocheck = 0;

struct DATA
{
  char mode;
  char iter;
  char node;
  char vindex;
} buffer [BUFFSIZE];
struct iovec iov[10];

enum optype
{
  N_CWRITE,
  N_CREAD,
  N_CWRITEV,
  N_CREADV,
  N_IWRITE_IOWAIT,
  N_IREAD_IOWAIT,
  N_IWRITEV_IOWAIT,
  N_IREADV_IOWAIT,
  N_IWRITE_N_IOWAIT,
  N_IREAD_N_IOWAIT,
  N_IWRITEV_N_IOWAIT,
  N_IREADV_N_IOWAIT
};
typedef enum optype optype;

char *opstr
#ifdef ANSI_C
(optype op)
#else
(op)
optype op;
#endif /* ANSI_C */
{
  return (op == N_CWRITE ? "N_CWRITE" :
          op == N_CREAD ? "N_CREAD" :
          op == N_CWRITEV ? "N_CWRITEV" :
          op == N_CREADV ? "N_CREADV" :
          op == N_IWRITE_IOWAIT ? "N_IWRITE_IOWAIT" :
          op == N_IREAD_IOWAIT ? "N_IREAD_IOWAIT" :
          op == N_IWRITEV_IOWAIT ? "N_IWRITEV_IOWAIT" :
          op == N_IREADV_IOWAIT ? "N_IREADV_IOWAIT" :
          op == N_IWRITE_N_IOWAIT ? "N_IWRITE_N_IOWAIT" :
          op == N_IREAD_N_IOWAIT ? "N_IREAD_N_IOWAIT" :
          op == N_IWRITEV_N_IOWAIT ? "N_IWRITEV_N_IOWAIT" :
          op == N_IREADV_N_IOWAIT ? "N_IREADV_N_IOWAIT" :
          "UNKNOWN");
}


char *modestr
#ifdef ANSI_C
(int mode)
#else
(mode)
int mode;
#endif
{
  
  return (mode == M_UNIX   ? "M_UNIX"   :
          mode == M_LOG    ? "M_LOG"    :
          mode == M_RECORD ? "M_RECORD" :
          mode == M_SYNC   ? "M_SYNC"   :
          mode == M_GLOBAL ? "M_GLOBAL" :
          "UNKOWN");
}


void set_wr_data
#ifdef ANSI_C
(int mode, int len, int it)
#else
(mode, len, it)
int mode;
int len;
int it;
#endif
{
  int i;
  char m;

  switch (mode)
  {
  case M_UNIX:
    m = 'U';
    break;
  case M_GLOBAL:
    m = 'G';
    break;
  case M_LOG:
    m = 'L';
    break;
  case M_SYNC:
    m = 'S';
    break;
  case M_RECORD:
    m = 'R';
    break;
  }

  for (i=0;i<len;i++)
  {
    buffer[i].mode = m;
    buffer[i].iter = (char)it+'0';
    buffer[i].node = (char)mynum+'0';
    buffer[i].vindex = ' ';
  }
  return;
}

int chk_output
#ifdef ANSI_C
(int fd, int mode)
#else
(fd, mode)
int fd;
int mode;
#endif
{
  int i;
  int n;
  int it;
  int len;
  int iter;
  char curiter;
  char curnode;
  
  if (nocheck)
    return (0);

  switch (mode)
  {
  case M_UNIX:
  case M_GLOBAL:
  case M_RECORD:
    len = length;    
    iter = iterations;
    break;
  case M_LOG:
    len = length;
    iter = (numclnts*iterations)+(((numclnts)*(numclnts-1))/2);
    break;
  case M_SYNC:
    iter = iterations;
    break;
    
  }
  
  for (it=0; it<iter;it++)
  {
    switch (mode)
    {
    case M_UNIX:
      if (read(fd,buffer,len*sizeof(struct DATA)) != (len*sizeof(struct DATA)))
        perror ("read()");
      for (i=0; i<len;i++)
        if ((buffer[i].mode  != 'U') ||
            (buffer[i].iter != ((char)it+'0')))
          return (-1);
      break;
      
    case M_GLOBAL:
      if (read(fd,buffer,len*sizeof(struct DATA)) != (len*sizeof(struct DATA)))
        perror ("read()");
      for (i=0; i<len;i++)
        if ((buffer[i].mode  != 'G') ||
            (buffer[i].iter != ((char)it+'0')) ||
            (buffer[i].node != '0'))
          return (-1);
      break;

    case M_LOG:
      if (read(fd,buffer,len*sizeof(struct DATA)) != (len*sizeof(struct DATA)))
        perror ("read()");
      curiter = buffer[0].iter;
      curnode = buffer[0].node;
      for (i=0; i<len;i++)
        if ((buffer[i].mode  != 'L') ||
            (buffer[i].iter != curiter) ||
            (buffer[i].node != curnode))
          return (-1);
      break;
    case M_SYNC:
      for (n=0; n < numclnts; n++)
      {
        len = length+n;
        if (read(fd,buffer,len*sizeof(struct DATA))
            != (len*sizeof(struct DATA)))
          perror("read()");
        for (i=0; i < len; i++)
          if ((buffer[i].mode  != 'S') ||
              (buffer[i].iter != ((char)it+'0')) ||
              (buffer[i].node != ((char)n+'0')))
            return (-1);
      }
      break;
    case M_RECORD:
      for (n=0; n < numclnts; n++)
      {
        if (read(fd,buffer,len*sizeof(struct DATA))
            != (len*sizeof(struct DATA)))
          perror("read()");
        for (i=0; i< len; i++)
          if ((buffer[i].mode  != 'R') ||
              (buffer[i].iter != ((char)it+'0')) ||
              (buffer[i].node != ((char)n+'0')))
            return (-1);
      }
      break;
    }
  }
  return (0);
}

void wr_input
#ifdef ANSI_C
(int fd, int mode)
#else
(fd, mode)
int fd;
int mode;
#endif
{
  int i;
  int it;
  int len;
  int iter;
  char m;
  int n;
  
  switch (mode)
  {
  case M_UNIX:
    m = 'U';
    len = length;
    iter = iterations;
    break;
  case M_GLOBAL:
    m = 'G';
    len = length;
    iter = iterations;
    break;
  case M_RECORD:
    m = 'R';
    len = length;
    iter = iterations;
    break;
  case M_LOG:
    m = 'L';
    len = length;
    iter = (numclnts*iterations)+(((numclnts)*(numclnts-1))/2);
    break;
  case M_SYNC:
    m = 'S';
    iter = iterations;
    break;
  }    

  switch (mode)
  {
  case M_UNIX:
  case M_GLOBAL:
  case M_LOG:
    for (it=0; it<iter;it++)
    {
      for (i=0; i<len;i++)
      {
        buffer[i].mode = m;
        buffer[i].iter = (char)it+'0';
        buffer[i].node = ' ';
        buffer[i].vindex = ' ';
      }
      
      if (write(fd,buffer,len*sizeof(struct DATA))
          != (len*sizeof(struct DATA)))
      {
        perror ("write()");
        exit (1);
      }
    }
    break;

  case M_SYNC:
  case M_RECORD:
    for (it=0; it < iter;it++)
    {
      for (n=0; n < numclnts; n++)
      {
        if (mode == M_SYNC)
          len = length+n;

        for (i=0; i<len;i++)
        {
          buffer[i].mode = m;
          buffer[i].iter = (char)it+'0';
          buffer[i].node = (char)n+'0';
          buffer[i].vindex = ' ';
        }

        if (write(fd,buffer,len*sizeof(struct DATA))
            != (len*sizeof(struct DATA)))
        {
          perror("write()");
          exit (1);
        }
      }
    }
    break;
  }
  return;
}


int test_rd_data
#ifdef ANSI_C
(int mode, int len, int it)
#else
(mode, len, it)
int mode;
int len;
int it;
#endif
{
  int i;
  char curiter;
  
  if (nocheck)
    return (0);

  switch (mode)
  {
  case M_UNIX:
    for (i=0;i<len;i++)
      if ((buffer[i].mode != 'U') ||
          (buffer[i].iter != ((char)it+'0')))
        return (-1);
    break;
  case M_GLOBAL:
    for (i=0;i<len;i++)
      if ((buffer[i].mode != 'G') ||
          (buffer[i].iter != ((char)it+'0')))
        return (-1);
    break;
  case M_LOG:
    curiter = buffer[0].iter;
    for (i=0;i<len;i++)
      if ((buffer[i].mode != 'L') ||
          (buffer[i].iter != curiter))
        return (-1);
    break;
  case M_SYNC:
    for (i=0;i<len;i++)
      if ((buffer[i].mode != 'S') ||
          (buffer[i].iter != ((char)it+'0')) ||
          (buffer[i].node != ((char)mynum+'0')))
        return (-1);
    break;
  case M_RECORD:
    for (i=0;i<len;i++)
      if ((buffer[i].mode != 'R') ||
          (buffer[i].iter != ((char)it+'0')) ||
          (buffer[i].node != ((char)mynum+'0')))
        return (-1);
    break;
  }
  return (0);
}


void set_wrv_data
#ifdef ANSI_C
(int mode, int vlen, int vcnt, int it)
#else
(mode, vlen, vcnt, it)
int mode;
int vlen;
int vcnt;
int it;
#endif
{
  int i;
  int j;
  char m;
  
  switch (mode)
  {
  case M_UNIX:
    m = 'U';
    break;
  case M_GLOBAL:
    m = 'G';
    break;
  case M_LOG:
    m = 'L';
    break;
  case M_SYNC:
    m = 'S';
    break;
  case M_RECORD:
    m = 'R';
    break;
  }

  for (i=0;i<vcnt;i++)
  {
    for (j=0;j < (iov[i].iov_len/sizeof(struct DATA));j++)
    {
      buffer[(i*(BUFFSIZE/vcnt))+j].mode = m;
      buffer[(i*(BUFFSIZE/vcnt))+j].iter = (char)it+'0';
      buffer[(i*(BUFFSIZE/vcnt))+j].node = (char)mynum+'0';
      buffer[(i*(BUFFSIZE/vcnt))+j].vindex = (char)i+'0';
    }
  }
  return;
}

int chkv_output
#ifdef ANSI_C
(int fd, int mode)
#else
(fd, mode)
int fd;
int mode;
#endif
{
  int i;
  int j;
  int n;
  int it;
  int vlen;
  int vcnt;
  int iter;
  char curiter;
  char curnode;
  
  if (nocheck)
    return (0);

  switch (mode)
  {
  case M_UNIX:
  case M_GLOBAL:
  case M_RECORD:
    vlen = vectorlength;    
    vcnt = vectorcnt;
    iter = iterations;
    for (i=0;i<vcnt;i++)
    {
      iov[i].iov_len = (i+vlen)*sizeof(struct DATA);
      iov[i].iov_base = (char *)&buffer[i*(BUFFSIZE/vcnt)];
    }
    break;
  case M_LOG:

    iter = (numclnts*iterations)+(((numclnts)*(numclnts-1))/2);
    vlen = vectorlength;    
    vcnt = vectorcnt;
    for (i=0;i<vcnt;i++)
    {
      iov[i].iov_len = (i+vlen)*sizeof(struct DATA);
      iov[i].iov_base = (char *)&buffer[i*(BUFFSIZE/vcnt)];
    }
    break;
  case M_SYNC:
    vcnt = vectorcnt;
    iter = iterations;
    break;
    
  }
  
  for (it=0; it<iter;it++)
  {
    switch (mode)
    {
    case M_UNIX:
      if (readv(fd,iov,vcnt) < 0)
        perror ("readv()");
      for (i=0; i<vcnt;i++)
       for (j=0;j< (iov[i].iov_len/sizeof(struct DATA));j++)
          if ((buffer[(i*(BUFFSIZE/vcnt))+j].mode != 'U') ||
              (buffer[(i*(BUFFSIZE/vcnt))+j].iter != ((char)it+'0')) ||
              (buffer[(i*(BUFFSIZE/vcnt))+j].vindex != ((char)i+'0')))
            return (-1);
      break;
      
    case M_GLOBAL:
      if (readv(fd,iov,vcnt) < 0)
        perror ("readv()");
      for (i=0; i<vcnt;i++)
        for (j=0;j< (iov[i].iov_len/sizeof(struct DATA));j++)
          if ((buffer[(i*(BUFFSIZE/vcnt))+j].mode != 'G') ||
              (buffer[(i*(BUFFSIZE/vcnt))+j].iter != ((char)it+'0')) ||
              (buffer[(i*(BUFFSIZE/vcnt))+j].vindex != ((char)i+'0')) ||
              (buffer[(i*(BUFFSIZE/vcnt))+j].node != '0'))
            return (-1);
      break;
      
    case M_LOG:
      if (readv(fd,iov,vcnt) < 0)
        perror ("readv()");
      for (i=0; i<vcnt;i++)
      {
        curiter = buffer[i*(BUFFSIZE/vcnt)].iter;
        curnode = buffer[i*(BUFFSIZE/vcnt)].node;
        for (j=0;j< (iov[i].iov_len/sizeof(struct DATA));j++)
          if ((buffer[(i*(BUFFSIZE/vcnt))+j].mode != 'L') ||
              (buffer[(i*(BUFFSIZE/vcnt))+j].iter != curiter) ||
              (buffer[(i*(BUFFSIZE/vcnt))+j].vindex != ((char)i+'0')) ||
              (buffer[(i*(BUFFSIZE/vcnt))+j].node != curnode))
            return (-1);
      }
      break;
      
    case M_SYNC:
      for (n=0; n < numclnts; n++)
      {
        vlen = length+n;
        for (i=0;i<vcnt;i++)
        {
          iov[i].iov_len = (i+vlen)*sizeof(struct DATA);
          iov[i].iov_base = (char *)&buffer[i*(BUFFSIZE/vcnt)];
        }

        if (readv(fd,iov,vcnt) <0)
          perror("readv()");
        for (i=0; i<vcnt;i++)
          for (j=0;j< (iov[i].iov_len/sizeof(struct DATA));j++)
            if ((buffer[(i*(BUFFSIZE/vcnt))+j].mode != 'S') ||
                (buffer[(i*(BUFFSIZE/vcnt))+j].iter != ((char)it+'0')) ||
                (buffer[(i*(BUFFSIZE/vcnt))+j].vindex != ((char)i+'0')) ||
                (buffer[(i*(BUFFSIZE/vcnt))+j].node != ((char)n+'0')))
              return (-1);
      }
      
      break;
    case M_RECORD:
      for (n=0; n < numclnts; n++)
      {
        if (readv(fd,iov,vcnt) <0)
          perror("readv()");
        for (i=0; i<vcnt;i++)
          for (j=0;j< (iov[i].iov_len/sizeof(struct DATA));j++)
            if ((buffer[(i*(BUFFSIZE/vcnt))+j].mode != 'R') ||
                (buffer[(i*(BUFFSIZE/vcnt))+j].iter != ((char)it+'0')) ||
                (buffer[(i*(BUFFSIZE/vcnt))+j].vindex != ((char)i+'0')) ||
                (buffer[(i*(BUFFSIZE/vcnt))+j].node != ((char)n+'0')))
              return (-1);
      }
      
      break;
    }
  }
  return 0;
}


void wrv_input
#ifdef ANSI_C
(int fd, int mode)
#else
(fd, mode)
int fd;
int mode;
#endif
{
  int i;
  int j;
  int n;
  int it;
  int vlen;
  int vcnt = vectorcnt;
  int iter;
  char m;
  
  switch (mode)
  {
  case M_UNIX:
    m = 'U';
    vlen = vectorlength;
    iter = iterations;
    break;
  case M_GLOBAL:
    m = 'G';
    vlen = vectorlength;
    iter = iterations;
    break;
  case M_RECORD:
    m = 'R';
    vlen = vectorlength;
    iter = iterations;
    break;
  case M_LOG:
    m = 'L';
    vlen = vectorlength;
    iter = (numclnts*iterations)+(((numclnts)*(numclnts-1))/2);
    break;
  case M_SYNC:
    m = 'S';
    iter = iterations;
    break;
  }    

  switch (mode)
  {
  case M_UNIX:
  case M_GLOBAL:
  case M_LOG:
    for (it=0;it<iter;it++)
    {
      for (i=0; i<vcnt;i++)
      {
        iov[i].iov_len = (i+vlen)*sizeof(struct DATA);
        iov[i].iov_base = (char *)&buffer[i*(BUFFSIZE/vcnt)];
        for (j=0;j< (iov[i].iov_len/sizeof(struct DATA));j++)
        {
          buffer[(i*(BUFFSIZE/vcnt))+j].mode = m;
          buffer[(i*(BUFFSIZE/vcnt))+j].iter = (char)it+'0';
          buffer[(i*(BUFFSIZE/vcnt))+j].node = ' ';
          buffer[(i*(BUFFSIZE/vcnt))+j].vindex = (char)i+'0';
        }
      }

      if (writev(fd,iov,vcnt) < 0)
      {
        perror("writev()");
        exit (1);
      }
    }
    break;

  case M_SYNC:
  case M_RECORD:
    for (it=0; it < iter;it++)
    {
      for (n=0; n < numclnts; n++)
      {
        if (mode == M_SYNC)
          vlen = vectorlength+n;
        for (i=0; i < vcnt; i++)
        {
          iov[i].iov_len = (i+vlen)*sizeof(struct DATA);
          iov[i].iov_base = (char *)&buffer[i*(BUFFSIZE/vcnt)];
          for (j=0;j<(iov[i].iov_len/sizeof(struct DATA));j++)
          {
            buffer[(i*(BUFFSIZE/vcnt))+j].mode = m;
            buffer[(i*(BUFFSIZE/vcnt))+j].iter = (char)it+'0';
            buffer[(i*(BUFFSIZE/vcnt))+j].node = (char)n+'0';
            buffer[(i*(BUFFSIZE/vcnt))+j].vindex = (char)i+'0';
          }
        }
        
        if (writev(fd,iov,vcnt) < 0)
        {
          perror("writev()");
          exit (1);
        }
      }
    }
    break;
  }
  return;
}

  
int test_rdv_data
#ifdef ANSI_C
(int mode, int vcnt, int it)
#else
(mode, vcnt, it)
int mode;
int vcnt;
int it;
#endif
{
  int i;
  int j;
  char curiter;

  if (nocheck)
    return (0);

  switch (mode)
  {
  case M_UNIX:
    for (i=0;i<vcnt;i++)
    {
      for (j=0;j < (iov[i].iov_len/sizeof(struct DATA));j++)
        if ((buffer[(i*(BUFFSIZE/vcnt))+j].mode != 'U') ||
            (buffer[(i*(BUFFSIZE/vcnt))+j].iter != (char)it+'0') ||
            (buffer[(i*(BUFFSIZE/vcnt))+j].vindex != (char)i+'0'))
          return (-1);
    }
    break;
  case M_GLOBAL:
    for (i=0;i<vcnt;i++)
    {
      for (j=0;j < (iov[i].iov_len/sizeof(struct DATA));j++)
        if ((buffer[(i*(BUFFSIZE/vcnt))+j].mode != 'G') ||
            (buffer[(i*(BUFFSIZE/vcnt))+j].iter != (char)it+'0') ||
            (buffer[(i*(BUFFSIZE/vcnt))+j].vindex != (char)i+'0'))
          return (-1);
    }
    break;
  case M_LOG:
    for (i=0;i<vcnt;i++)
    {
      curiter = buffer[i*(BUFFSIZE/vcnt)].iter;
      for (j=0;j < (iov[i].iov_len/sizeof(struct DATA));j++)
        if ((buffer[(i*(BUFFSIZE/vcnt))+j].mode != 'L') ||
            (buffer[(i*(BUFFSIZE/vcnt))+j].iter != curiter) ||
            (buffer[(i*(BUFFSIZE/vcnt))+j].vindex != (char)i+'0'))
          return (-1);
    }
    break;
  case M_SYNC:
    for (i=0;i<vcnt;i++)
    {
      for (j=0;j < (iov[i].iov_len/sizeof(struct DATA));j++)
        if ((buffer[(i*(BUFFSIZE/vcnt))+j].mode != 'S') ||
            (buffer[(i*(BUFFSIZE/vcnt))+j].iter != (char)it+'0') ||
            (buffer[(i*(BUFFSIZE/vcnt))+j].node != (char)mynum+'0') ||
            (buffer[(i*(BUFFSIZE/vcnt))+j].vindex != (char)i+'0'))
          return (-1);
    }
    break;
  case M_RECORD:
    for (i=0;i<vcnt;i++)
    {
      for (j=0;j < (iov[i].iov_len/sizeof(struct DATA));j++)
        if ((buffer[(i*(BUFFSIZE/vcnt))+j].mode != 'R') ||
            (buffer[(i*(BUFFSIZE/vcnt))+j].iter != (char)it+'0') ||
            (buffer[(i*(BUFFSIZE/vcnt))+j].node != (char)mynum+'0') ||
            (buffer[(i*(BUFFSIZE/vcnt))+j].vindex != (char)i+'0'))
          return (-1);
    }
    break;
  }
  return 0;
}


void n_op
#ifdef ANSI_C
(int fd, int mode, optype op)
#else
(fd, mode, op)
int fd;
int mode;
optype op;
#endif
{
  int i;
  int it;
  int iter;
  int len;
  int vlen;
  int vcnt;
  long id[20];
  char errs[1000];
  
  setiomode(fd,mode);

  switch (mode)
  {
  case M_UNIX:
  case M_GLOBAL:
    iter = iterations;
    len  = length;
    vlen = vectorlength;
    vcnt = vectorcnt;
    break;
  case M_LOG:
    iter = iterations+mynum;
    len  = length;
    vlen = vectorlength;
    vcnt = vectorcnt;
    break;
  case M_SYNC:
    iter = iterations;
    len = length+mynum;
    vlen = vectorlength+mynum;
    vcnt = vectorcnt;
    break;    
  case M_RECORD:
    iter = iterations;
    len = length;
    vlen = vectorlength;
    vcnt = vectorcnt;
  }
  
  for (i=0;i<vcnt;i++)
  {
    iov[i].iov_len = (i+vlen)*sizeof(struct DATA);
    iov[i].iov_base = (char *)&buffer[i*(BUFFSIZE/vcnt)];
  }    

  if (mynum == 0)
    printf("Doing %s %s\n",opstr(op),modestr(mode));

  for (it = 0; it < iter; it ++)
  {
    switch (op)
    {
    case N_CWRITE:
      set_wr_data(mode,len,it);
      if (_cwrite(fd,(char *)buffer,len*sizeof(struct DATA)) !=
          (len*sizeof(struct DATA)))
      {
        sprintf(errs,"%d %s %s _cwrite()",mynum,opstr(op),modestr(mode));
        pfslib_perror(errs);
      }
      break;

    case N_CWRITEV:
      set_wrv_data(mode,vlen,vcnt,it);
      if (_cwritev(fd,iov,vcnt) != _vectorlength(iov,vcnt))
      {
        sprintf(errs,"%d %s %s _cwritev()",mynum,opstr(op),modestr(mode));
        pfslib_perror(errs);
      }
      break;

    case N_CREAD:
      if (_cread(fd,(char *)buffer,len*sizeof(struct DATA)) !=
          (len*sizeof(struct DATA)))
      {
        sprintf(errs,"%d %s %s _cread()",mynum,opstr(op),modestr(mode));
        pfslib_perror(errs);
      }
      if (test_rd_data(mode,len,it) < 0)
        fprintf(stderr,"%s %s _cread(): INCORRECT DATA\n",
                opstr(op),modestr(mode));
      break;

    case N_CREADV:
      if (_creadv(fd,iov,vcnt) != _vectorlength(iov,vcnt))
      {
        sprintf(errs,"%d %s %s _creadv()",mynum,opstr(op),modestr(mode));
        pfslib_perror(errs);
      }
      if (test_rdv_data(mode,vcnt,it) < 0)
        fprintf(stderr,"%s %s _creadv(): INCORRECT DATA\n",
                opstr(op),modestr(mode));
      break;

    case N_IWRITE_IOWAIT:
      set_wr_data(mode,len,it);
      if ((id[0] = _iwrite(fd,(char *)buffer,len*sizeof(struct DATA))) < 0)
      {
        sprintf(errs,"%d %s %s _iwrite()",mynum,opstr(op),modestr(mode));
        pfslib_perror(errs);
      }
      if (_iowait(id[0]) < 0)
      {
        sprintf(errs,"%d %s %s _iowait()",mynum,opstr(op),modestr(mode));
        pfslib_perror(errs);
      }
      break;

    case N_IWRITEV_IOWAIT:
      set_wrv_data(mode,vlen,vcnt,it);
      if ((id[0] = _iwritev(fd,iov,vcnt)) < 0)
      {
        sprintf(errs,"%d %s %s _iwritev()",mynum,opstr(op),modestr(mode));
        pfslib_perror(errs);
      }
      if (_iowait(id[0]) < 0)
      {
        sprintf(errs,"%d %s %s _iowait()",mynum,opstr(op),modestr(mode));
        pfslib_perror(errs);
      }
      break;

    case N_IREAD_IOWAIT:
      if ((id[0] = _iread(fd,(char *)buffer,len*sizeof(struct DATA))) < 0)
      {
        sprintf(errs,"%d %s %s _iread()",mynum,opstr(op),modestr(mode));
        pfslib_perror(errs);
      }
      if (_iowait(id[0]) < 0)
      {
        sprintf(errs,"%d %s %s _iowait()",mynum,opstr(op),modestr(mode));
        pfslib_perror(errs);
      }
      if (test_rd_data(mode,len,it) < 0)
        fprintf(stderr,"%s %s _iread(): INCORRECT DATA\n",
                opstr(op),modestr(mode));
      break;

    case N_IREADV_IOWAIT:
      if ((id[0] = _ireadv(fd,iov,vcnt)) < 0)
      {
        sprintf(errs,"%d %s %s _ireadv()",mynum,opstr(op),modestr(mode));
        pfslib_perror(errs);
      }
      if (_iowait(id[0]) < 0)
      {
        sprintf(errs,"%d %s %s _iowait()",mynum,opstr(op),modestr(mode));
        pfslib_perror(errs);
      }
      if (test_rdv_data(mode,vcnt,it) < 0)
        fprintf(stderr,"%s %s _ireadv(): INCORRECT DATA\n",
                opstr(op),modestr(mode));
      break;

    case N_IWRITE_N_IOWAIT:
      set_wr_data(mode,len,it);
      if ((id[it] = _iwrite(fd,(char *)buffer,len*sizeof(struct DATA))) < 0)
      {
        sprintf(errs,"%d %s %s _iwrite()",mynum,opstr(op),modestr(mode));
        pfslib_perror(errs);
      }
      break;

    case N_IWRITEV_N_IOWAIT:
      set_wrv_data(mode,vlen,vcnt,it);
      if ((id[it] = _iwritev(fd,iov,vcnt)) < 0)
      {
        sprintf(errs,"%d %s %s _iwritev()",mynum,opstr(op),modestr(mode));
        pfslib_perror(errs);
      }
      break;

    case N_IREAD_N_IOWAIT:
      if ((id[it] = _iread(fd,(char *)buffer,len*sizeof(struct DATA))) < 0)
      {
        sprintf(errs,"%d %s %s _iread()",mynum,opstr(op),modestr(mode));
        pfslib_perror(errs);
      }
      break;

    case N_IREADV_N_IOWAIT:
      if ((id[it] = _ireadv(fd,iov,vcnt)) < 0)
      {
        sprintf(errs,"%d %s %s _ireadv()",mynum,opstr(op),modestr(mode));
        pfslib_perror(errs);
      }
      break;

    default:
      break;
    }
  }

  switch (op)
  {
  case N_IWRITE_N_IOWAIT:
  case N_IREAD_N_IOWAIT:
  case N_IWRITEV_N_IOWAIT:
  case N_IREADV_N_IOWAIT:
    for (it = 0; it < iter; it ++)
    {
      if (_iowait(id[it]) < 0)
      {
        sprintf(errs,"%d %s %s _iowait()",mynum,opstr(op),modestr(mode));
        pfslib_perror(errs);
      }
    }
  default:
    break;
  }
  
  return;
}



/* Test of open and gopen */
void tst_gopen
#ifdef ANSI_C
(void)
#else
()
#endif;
{
  int fd;
  int i;

  prtmsg("Creating a new file exclusively with mode 000\n");
  fd = gopen(TESTFILE,O_RDWR|O_CREAT|O_EXCL,M_UNIX,00);
  
  prtmsg("Closing the file\n");
  fd = close(fd);
  
  prtmsg("Opening the file O_RDOLNY. Must return error\n");
  if (_gopen(TESTFILE,O_RDONLY,M_UNIX,0600) > 0)
  {
    prtmsg("_gopen(\"tst_file.000\",O_RDONLY) should return error\n");
    exit (1);
  }
  perror("_gopen() EXPECTED ERROR");
  errno = 0;
  
  prtmsg("Opening the file O_WROLNY. Must return error\n");
  if (_gopen(TESTFILE,O_WRONLY,M_UNIX,0600) > 0)
  {
    prtmsg("_gopen(\"tst_file.000\",O_WRONLY) should return error\n");
    exit (1);
  }
  perror("_gopen() EXPECTED ERROR");
  errno = 0;
  
  prtmsg("Opening the file O_WROLNY. Must return error\n");
  if (_gopen(TESTFILE,O_WRONLY,M_UNIX,0600) > 0)
  {
    prtmsg("_gopen(\"tst_file.000\",O_WRONLY) should return error\n");
    exit (1);
  }
  perror("_gopen() EXPECTED ERROR");
  errno = 0;
  
  if (unlink(TESTFILE) == -1)
  {
    perror("unlink()");
    exit (1);
  }
  
  prtmsg("Creating a new file exclusively with mode 0644\n");
  fd = gopen(TESTFILE,O_RDWR|O_CREAT|O_EXCL,M_UNIX,0644);
  
  prtmsg("Closing the file\n");
  fd = close(fd);

  prtmsg("Opening the file O_CREAT|O_EXCL. Must return error\n");
  if (_gopen(TESTFILE,O_RDWR|O_CREAT|O_EXCL,M_UNIX,0600) > 0)
  {
    prtmsg("_gopen(\"tst_file.000\",O_WRONLY) should return error\n");
    exit (1);
  }
  perror("_gopen() EXPECTED ERROR");
  errno = 0;
  
  for (i=0; i<1000;i++)
  {
    fd = gopen(OUTPUTFILE,O_CREAT|O_TRUNC|O_WRONLY,M_UNIX,0600);
    prtmsg("gopen() = %d\n",fd);

    setiomode(fd,M_UNIX);
    setiomode(fd,M_UNIX);
    setiomode(fd,M_LOG);
    setiomode(fd,M_UNIX);
    setiomode(fd,M_RECORD);
    setiomode(fd,M_UNIX);
    setiomode(fd,M_SYNC);
    setiomode(fd,M_UNIX);
    setiomode(fd,M_GLOBAL);
    setiomode(fd,M_UNIX);

    setiomode(fd,M_LOG);
    setiomode(fd,M_LOG);
    setiomode(fd,M_RECORD);
    setiomode(fd,M_LOG);
    setiomode(fd,M_SYNC);
    setiomode(fd,M_LOG);
    setiomode(fd,M_GLOBAL);
    setiomode(fd,M_LOG);
    
    setiomode(fd,M_RECORD);
    setiomode(fd,M_RECORD);
    setiomode(fd,M_SYNC);
    setiomode(fd,M_RECORD);
    setiomode(fd,M_GLOBAL);
    setiomode(fd,M_RECORD);

    setiomode(fd,M_SYNC);
    setiomode(fd,M_SYNC);
    setiomode(fd,M_GLOBAL);
    setiomode(fd,M_SYNC);

    setiomode(fd,M_GLOBAL);
    setiomode(fd,M_GLOBAL);
    close(fd);
    prtmsg("close(%d)\n",fd);
  }

  if (unlink(TESTFILE) == -1)
  {
    perror("unlink()");
    exit (1);
  }
  
  return;
}

void n_ops
#ifdef ANSI_C
(char *modes,char *ops)
#else
(modes, ops)
char *modes;
char *ops;
#endif
{
  char *mp;
  char *op;
  int mode;
  int ifd;
  int ofd;
  int ifdv;
  int ofdv;
  int ifdn;
  int ifdvn;
  int ofdn;
  int ofdvn;
  int it;
  
  if (mynum == 0)
  {
    if ((ifdn = open(INPUTFILE,O_CREAT|O_TRUNC|O_WRONLY,0600)) < 0)
    {
      perror("open()");
      exit (1);
    }
  
    if ((ifdvn = open(INPUTFILEV,O_CREAT|O_TRUNC|O_WRONLY,0600)) < 0)
    {
      perror("open()");
      exit (1);
    }

    if ((ofdn = open(OUTPUTFILE,O_CREAT|O_RDONLY,0600)) < 0)
    {
      perror("open()");
      exit (1);
    }
  
    if ((ofdvn = open(OUTPUTFILEV,O_CREAT|O_RDONLY,0600)) < 0)
    {
      perror("open()");
      exit (1);
    }

    for (mp = modes; *mp != '\0'; mp++)
    {
      switch (*mp)
      {
      case 'u':
        mode = M_UNIX;
        break;
      case 'g':
        mode = M_GLOBAL;
        break;
      case 'l':
        mode = M_LOG;
        break;
      case 's':
        mode = M_SYNC;
        break;
      case 'r':
        mode = M_RECORD;
        break;
      default:
        prtmsg("UNKNOWN MODE\n");
        exit(1);
      }
      wr_input(ifdn,mode);
      wrv_input(ifdvn,mode);
    }
    close (ifdn);
    close (ifdvn);
  }

  if (append)
  {
    ofd  = gopen(OUTPUTFILE,O_CREAT|O_TRUNC|O_WRONLY|O_APPEND,M_UNIX,0600);
    ofdv  = gopen(OUTPUTFILEV,O_CREAT|O_TRUNC|O_WRONLY|O_APPEND,M_UNIX,0600);
  }
  else
  {
    ofd  = gopen(OUTPUTFILE,O_CREAT|O_TRUNC|O_WRONLY,M_UNIX,0600);
    ofdv  = gopen(OUTPUTFILEV,O_CREAT|O_TRUNC|O_WRONLY,M_UNIX,0600);
  }
    
  ifd  = gopen(INPUTFILE,O_CREAT|O_RDONLY,M_UNIX,0600);
  ifdv  = gopen(INPUTFILEV,O_CREAT|O_RDONLY,M_UNIX,0600);


  for (op = ops; *op != '\0'; op++)
  {
    lseek(ofd,0,SEEK_SET);
    lseek(ofdv,0,SEEK_SET);
    lseek(ifd,0,SEEK_SET);
    lseek(ifdv,0,SEEK_SET);
    if ((!append) && (mynum == 0))
    {
      lseek(ofdvn,0,SEEK_SET);
      lseek(ofdn,0,SEEK_SET);
    }
    
    
    if (*op == 's')
    {
      if (mynum == 0) printf("Doing setiomode() test\n");

      for (it=0;it<iterations;it++)
      {
        for (mp = modes; *mp != '\0'; mp++)
        {
          switch (*mp)
          {
          case 'u':
            mode = M_UNIX;
            break;
          case 'g':
            mode = M_GLOBAL;
            break;
          case 'l':
            mode = M_LOG;
            break;
          case 's':
            mode = M_SYNC;
            break;
          case 'r':
            mode = M_RECORD;
            break;
          default:
            prtmsg("UNKNOWN MODE\n");
            break;
          }
          setiomode(ofd,mode);
        }
      }
      continue;
    }
    

    for (mp = modes; *mp != '\0'; mp++)
    {
      switch (*mp)
      {
      case 'u':
        mode = M_UNIX;
        break;
      case 'g':
        mode = M_GLOBAL;
        break;
      case 'l':
        mode = M_LOG;
        break;
      case 's':
        mode = M_SYNC;
        break;
      case 'r':
        mode = M_RECORD;
        break;
      default:
        prtmsg("UNKNOWN MODE\n");
        break;
      }

      switch (*op)
      {
      case 'c':
        n_op(ifd,mode,N_CREAD);
        n_op(ifdv,mode,N_CREADV);

        n_op(ofd,mode,N_CWRITE);
        setiomode(ofd,mode);        /* Synchronize before check */
        if ((mynum == 0) && (chk_output(ofdn,mode) < 0))
          fprintf(stderr,"%s %s _cwrite(): INCORRECT DATA\n",
                  opstr(N_CWRITE),modestr(mode));

        n_op(ofdv,mode,N_CWRITEV);
        setiomode(ofdv,mode);        /* Synchronize before check */
        if ((mynum == 0) && (chkv_output(ofdvn,mode) < 0))
          fprintf(stderr,"%s %s _cwritev(): INCORRECT DATA\n",
                  opstr(N_CWRITEV),modestr(mode));

        break;
      case 'w':
        n_op(ifd,mode,N_IREAD_IOWAIT);
        n_op(ifdv,mode,N_IREADV_IOWAIT);
      
        n_op(ofd,mode,N_IWRITE_IOWAIT);
        setiomode(ofd,mode);        /* Synchronize before check */
        if ((mynum == 0) && (chk_output(ofdn,mode) < 0))
          fprintf(stderr,"%s %s _iwrite(): INCORRECT DATA\n",
                  opstr(N_IWRITE_IOWAIT),modestr(mode));

        n_op(ofdv,mode,N_IWRITEV_IOWAIT);
        setiomode(ofdv,mode);        /* Synchronize before check */
        if ((mynum == 0) && (chkv_output(ofdvn,mode) < 0))
          fprintf(stderr,"%s %s _iwritev(): INCORRECT DATA\n",
                  opstr(N_IWRITEV_IOWAIT),modestr(mode));
        break;
      case 'i':
        n_op(ifd,mode,N_IREAD_N_IOWAIT);
        n_op(ifdv,mode,N_IREADV_N_IOWAIT);

        n_op(ofd,mode,N_IWRITE_N_IOWAIT);
        setiomode(ofd,mode);        /* Synchronize before check */
        if ((mynum == 0) && (chk_output(ofdn,mode) < 0))
          fprintf(stderr,"%s %s _iwrite(): INCORRECT DATA\n",
                  opstr(N_IWRITE_N_IOWAIT),modestr(mode));

        n_op(ofdv,mode,N_IWRITEV_N_IOWAIT);
        setiomode(ofdv,mode);        /* Synchronize before check */
        if ((mynum == 0) && (chkv_output(ofdvn,mode) < 0))
          fprintf(stderr,"%s %s _iwritev(): INCORRECT DATA\n",
                  opstr(N_IWRITEV_N_IOWAIT),modestr(mode));
        break;
      default:
        fprintf(stderr,"UNKNOWN OPERATION TYPE\n");
        break;
      }
    }
  }
  
  
  close (ifd);
  close (ifdv);
  close (ofd);
  close (ofdv);
  
  if (mynum == 0)
  {
    close (ofdn);
    close (ofdvn);
  }
  
  return;
}    
  
int main
#ifdef ANSI_C
(int argc, char **argv)
#else
(argc, argv)
int argc;
char **argv;
#endif
{
  int c;
  int i;
  int chpid;
  char *ops = PERMOP; 
  char *modes = PERMMODES;

  int dbg = 1;

  while ((c = getopt(argc,argv,"akh:n:s:c:i:l:v:m:o:")) != -1)
  {
    switch (c)
    {
    case 'a':
      append = 1;
      break;
    case 'k':
      nocheck = 1;
      break;
    case 'h':                   /* Hostname */
      pfsdhost = optarg;
      break;
    case 'n':                   /* Number of clients */
#ifdef NXLIB
      fprintf(stderr,"%s: warning -n flag will be ignored. Use -sz NXLib flag\n",argv[0]);
#else
      numclnts = atoi(optarg);
#endif
      break;
    case 's':                   /* server threshold */
      svc_thr = atoi(optarg);
      break;
    case 'c':                   /* client threshold */
      clt_thr = atoi(optarg);
      break;
    case 'i':                   /* iterations */
      iterations = atoi(optarg);
      break;
    case 'l':                   /* length of data to write */
      length = atoi(optarg);
      vectorlength = length;
      break;
    case 'v':
      vectorcnt = atoi(optarg);
      break;
    case 'o':
      ops = optarg;
      break;
    case 'm':
      modes = optarg;
      break;
    case '?':
      fprintf(stderr,"%s: usage: %s [-h pfsdhost] [-n number_of_clients] [-s server_threshold] [-c client_threshold] [-i iter] [-l length] [-v vectorcnt]\n",
              argv[0], argv[0]);
      exit (1);
    }
  }
  
  if (((length+numclnts-1) > BUFFSIZE) ||
      ((vectorlength+vectorcnt-1+numclnts-1) > (BUFFSIZE/vectorcnt)))
  {
    fprintf(stderr,"%s: data exceeds iternal buffer. Use lesser clients, lesser length, or lesser vectorcnt\n",argv[0]);
    exit (1);
  }
  

#ifdef NXLIB
  mynum = mynode();
  numclnts = numnodes();
#else 
  mynum = 0;

  for (i=1; i<numclnts; i++)
  {
    if ((chpid = fork()) == -1)
    {
      perror("fork()");
      exit(1);
    }
    if (chpid == 0)
    {
      mynum = i;
      break;
    }
    
  }
#endif  

/*  while (dbg); */

  _pfslib_init(pfsdhost,numclnts,mynum,svc_thr,clt_thr);

  n_ops(modes,ops);
  
  exit (0);
  

}

