/* Very simple PFSLib test program */

#include <fcntl.h>
#include <sys/types.h>
#include <pfslib.h>             /* Include the pfslib header file */
#include <stdio.h>
#include <unistd.h>

#define FILENAME "file"
#define DATA "This is a test\n"

int main(int argc, char **argv)
{
  
  int fd;
  char rdata[100];
  
  if (argc != 2)
  {
    fprintf(stderr,"usage: %s hostname\n",argv[0]);
    exit(1);
  }
  

  /* Initialize PFSLib */
  pfslib_init(argv[1],          /* Host of pfsd */
              1,                /* Number of clients */
              0);               /* Number of this process */
  
  /* Open a file */
  fd = gopen(FILENAME,          /* Name of file */
             O_CREAT | O_RDWR,  /* Unix open(2) open flags */
             M_UNIX,            /* I/O mode */
             0644);             /* Unix file access permissions */
  
  /* Write data synchronously */
  cwrite(fd, DATA, strlen(DATA));
  
  /* Set file pointer to beginning of file */
  if (lseek(fd,0,SEEK_SET) != 0)
  {
    pfslib_perror("lseek()");
    exit(1);
  }
  
  /* Read data synchronously */
  cread(fd,rdata,strlen(DATA));
  
  rdata[strlen(DATA)] = '\0';
  
  fprintf(stdout,rdata);
  fflush(stdout);
  
  /* Close the file */
  close(fd);
  
  exit(0);
}
