#include <sys/types.h>
#include <sys/time.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>

int main (argc, argv)
int argc;
char **argv;
{
  int fd;

	int i,j;
	int xdim, ydim;
  int dat;
  
	if ( argc != 4 )
	{
		printf("usage: %s <xdim> <ydim> <filename>\n",argv[0]);
		exit(1);
	}

  xdim = atoi(argv[1]);
  ydim = atoi(argv[2]);

	if ((fd = open(argv[3], O_CREAT | O_TRUNC | O_WRONLY, 0644)) < 0)
  {
    perror("open()");
    exit(1);
  }

  /* Write X and Y dimension */
  if (write(fd,&xdim,sizeof(int)) != sizeof(int))
  {
    perror("write(xdim)");
    exit(1);
  }
  
  if (write(fd,&ydim,sizeof(int)) != sizeof(int))
  {
    perror("write(ydim)");
    exit(1);
  }
  
  srand48((long)time(NULL));

  /* Write random matrix */
  for (i=0; i<xdim; i++)
    for (j=0; j<ydim; j++)
    {
      dat = (int)mrand48();
      if (write(fd,&dat,sizeof(int)) != sizeof(int))
      {
        perror("write(mat)");
        exit(1);
      }
    }  
  /* Write random vector */
  for (i=0; i<xdim; i++)
  {
    dat = (int)mrand48();
    if (write(fd,&dat,sizeof(int)) != sizeof(int))
    {
      perror("write(vec)");
      exit(1);
    }
  }  

  close(fd);

  exit(0);
}
