#include <sys/types.h>
#include <sys/time.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>

int main (argc, argv)
int argc;
char **argv;
{
  int fd;                       /* file descriptor */
	int arraysize;                /* size of an array */
  int arraynumber;              /* number of arrays */
  int *array;                   /* Pointer to the array */
	int i,j;                      /* Counter */

	if ( argc != 4 )
	{
		printf("usage: %s <size of array> <number of arrays> <filename>\n",
           argv[0]);
		exit(1);
	}

  arraysize = atoi(argv[1]);
  arraynumber = atoi(argv[2]);

	if ((fd = open(argv[3], O_CREAT | O_TRUNC | O_WRONLY, 0644)) < 0)
  {
    perror("open()");
    exit(1);
  }

  if ((array = (int *)malloc(sizeof(int)*arraysize)) == NULL)
  {
    perror("malloc()");
    exit(1);
  }
  
  write(fd,&arraysize,sizeof(int));

  srand48((long)time(NULL));

  for (i=0; i<arraynumber; i++)
  {
    for (j=0; j<arraysize; j++)
      array[j] = (int)mrand48();
    write(fd,array,sizeof(int)*arraysize);
  }
  
  close(fd);

  exit(0);
}
