#include <stdio.h>
#include <fcntl.h>
#include <nx.h>
#include <pfslib.h>
#include <unistd.h>

int main(argc, argv)
int argc;
char **argv;
{
  int ifd;                      /* input file descriptor */
  int ofd;                      /* output file descriptor */
  off_t filesize;               /* size of the input file */
  int arraysize;                /* size of the arrays */
  int arraynumber;              /* total number of arrays */
  int myarraynumber;            /* number of arrays to be processed by this
                                 * process */
  int *array[2];                /* Pointer to two arrays; one is used for
                                 * the calcuation, the other for an 
                                 * asynchronous read operation */
  int *carray;                  /* Pointer to the current array */
  int *narray;                  /* Pointer to the next array */
  int max;                      /* The maximum */
  long ioid;                    /* I/O Id of the asynchronous I/O operation */
  int i,j;                      /* Counter */
  
  if (argc != 4)
  {
    fprintf(stderr,"usage: $s <pfsd host> <input file> <output file> \n",
            argv[0]);
    exit(1);
  }

  pfslib_init(argv[1],numnodes(),mynode()); /* Initialize PFSLib */
  _dbgmsg("Initailized PFSLib");
  
  /* open input file */
  ifd = gopen(argv[2],O_RDONLY,M_GLOBAL,0644);
  _dbgmsg("Opened input file %s",argv[2]);

  /* open output file */
  ofd = gopen(argv[3],O_CREAT | O_TRUNC | O_WRONLY, M_RECORD, 0644);
  _dbgmsg("Opened output file %s",argv[3]);
  
  /* determine size of input file */
  filesize = lseek(ifd,0,SEEK_END);
  _dbgmsg("Size of input file is %d",filesize);
  
  /* reset the file pointer */
  lseek(ifd,0,SEEK_SET);
  
  /* Read the size of the arrays */
  cread(ifd,(char *)&arraysize,sizeof(int));
  _dbgmsg("The size of an array is %d",arraysize);
  
  /* Calculate the number of arrays to be read by this process */
  arraynumber = (((int)filesize-(int)sizeof(int))/(arraysize*sizeof(int)));
  _dbgmsg("There are % arrays in total",arraynumber);
  myarraynumber = arraynumber/(int)numnodes();
  if ((arraynumber%(int)numnodes()) > mynode()) 
    myarraynumber++;
  _dbgmsg("I have to process %d arrays",myarraynumber);
  
  /* Set the I/O mode of the input file to M_RECORD */
  setiomode(ifd,M_RECORD);

  if (myarraynumber > 0)
  {
    /* Allocate two arrays in order to read the arrays asynchronously
     * overlapping with calculation */
    if (((array[0] = (int *)malloc(sizeof(int)*arraysize)) == NULL) ||
        ((array[1] = (int *)malloc(sizeof(int)*arraysize)) == NULL))
    {
      perror("malloc()");
      exit(1);
    }
    
    /* read the first array asynchronously */
    ioid = iread(ifd,(char *)array[0],sizeof(int)*arraysize);
    
    for (i=0;i < myarraynumber; i++)
    {
      carray = array[i%2];      /* current array */
      narray = array[(i+1)%2];  /* next array */
      
      /* wait for the asynchronous read operation to finish */
      iowait(ioid);

      /* read the next array asynchronously */
      if (myarraynumber > (i+1))
        ioid = iread(ifd, (char *)narray, sizeof(int)*arraysize);
      
      /* Calulate Maximum in the current array */
      for (j=0; j<arraysize;j++)
        if ((j==0) && (max < carray[j]))
          max = carray[j];
      _dbgmsg("Maximum of array %d is %d",i,max);
      
      /* Write result */
      cwrite(ofd,(char *)&max,sizeof(int));
    }
  }    

  close(ifd);                   /* close input file */
  close(ofd);                   /* close output file */

  exit(0);
}
