#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <pfslib.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <stdlib.h>
#include <math.h>
#include <nx.h>

#define USAGE "\
\t[-r <Resultfile>]\n\
\t[-h <pfsdHost>]\n\
\t[-d <number of io Daemons>]\n\
\t[-a|-s]\n\
\t[-e <number of External iterations>]\n\
\t[-i <number of Internal iterations>]\n\
\t[-n <miNimum number of bytes>]\n\
\t[-x <maXimum number of bytes>]\n\
\t[-t <sTep of number of bytes>]\n\
\t[-m <Mode string of the form [glrsu]+>]\n\
\t[-o <Operations> ..... (must be last argument)]"

#define BUFFSIZE       100000

#define OUTPUTLINESIZE 1000

#define MAXINTITER     20       /* Maximal outstanding io operations */

#define INPUTFILE      "/tmp/input"
#define OUTPUTFILE     "/tmp/output"

#define DFLTRESULTFILE "/tmp/results"
#define DFLTPFSDHOST   "sunbode25"
#define DFLTIODNUMBER  0
#define DFLTSYNCFLAG   1
#define DFLTEXTITER    1
#define DFLTINTITER    20
#define DFLTMINIMUM    1
#define DFLTMAXIMUM    100000
#define DFLTSTEP       0
#define DFLTMODES      "glrsu"

char *dfltopargs[] = {"CWR","CRD","IWRW","IRDW","IWRIOW","IRDIOW",(char *)0};

extern char *optarg;
extern int optind;

int iodnumber = -1;
int syncflag  = -1;
int mode;

char buffer [BUFFSIZE];

int resultfd;

int inputfd;
int outputfd;


enum optype
{
  NO_OP,
  CWR,
  CRD,
  IWRW,
  IRDW,
  IWRIOW,
  IRDIOW,
  IWR,
  IRD,
  WIOW,
  RIOW
};
typedef enum optype optype;

char *mode2str
#ifdef ANSI_C
(int mode)
#else
(mode)
int mode;
#endif
{
  
  return (mode == M_UNIX   ? "M_UNIX"   :
          mode == M_LOG    ? "M_LOG"    :
          mode == M_RECORD ? "M_RECORD" :
          mode == M_SYNC   ? "M_SYNC"   :
          mode == M_GLOBAL ? "M_GLOBAL" :
          "UNKOWN");
}

char mode2char
#ifdef ANSI_C
(int mode)
#else
(mode)
int mode;
#endif
{
  
  return (mode == M_UNIX   ? 'U' :
          mode == M_LOG    ? 'L' :
          mode == M_RECORD ? 'R' :
          mode == M_SYNC   ? 'S' :
          mode == M_GLOBAL ? 'G' :
          'X');
}

optype str2op
#ifdef ANSI_C
(char *str)
#else
(str)
char *str;
#endif
{
  if (!strcmp(str,"CWR"))
    return(CWR);
  if (!strcmp(str,"CRD"))
    return(CRD);
  if (!strcmp(str,"IWRW"))
    return(IWRW);
  if (!strcmp(str,"IRDW"))
    return(IRDW);
  if (!strcmp(str,"IWRIOW"))
    return(IWRIOW);
  if (!strcmp(str,"IRDIOW"))
    return(IRDIOW);
  if (!strcmp(str,"IWR"))
    return(IWR);
  if (!strcmp(str,"IRD"))
    return(IRD);
  if (!strcmp(str,"WIOW"))
    return(WIOW);
  if (!strcmp(str,"RIOW"))
    return(RIOW);

  return(NO_OP);
}

char *op2str
#ifdef ANSI_C
(optype op)
#else
(op)
optype op;
#endif
{
  switch (op)
  {
  case CWR:
    return("CWR");
  case CRD:
    return("CRD");
  case IWRW:
    return("IWRW");
  case IRDW:
    return("IRDW");
  case IWRIOW:
    return("IWRIOW");
  case IRDIOW:
    return("IRDIOW");
  case IWR:
    return("IWR");
  case IRD:
    return("IRD");
  case WIOW:
    return("WIOW");
  case RIOW:
    return("RIOW");
  }
  
  return("NO_OP");
}  

void write_res
#ifdef ANSI_C
(char *op,int extiter, int intiter, int size, double min, double max,
 double  total, double  tsq)
#else
(op,extiter,intiter,size,min,max,total,tsq)
char   *op;
int     extiter;
int     intiter;
int     size;
double  min;
double  max;
double  total;
double  tsq;
#endif
{
  double work;
  double gmin;
  double gmax;
  double gtotal;
  double gaver;
  double gtsq;
  double gstd;
  double aver;
  double std;
  
  char output[OUTPUTLINESIZE];
  
  gmin = min;
  gdlow(&gmin,1,&work);

  gmax = max;
  gdhigh(&max,1,&work);

  gtotal = total;
  gdsum(&gtotal,1,&work);
  gaver = (gtotal/(double)(extiter*numnodes()));

  gtsq = tsq;
  gdsum(&gtsq,1,&work);
  if ((extiter*numnodes()) == 1)
    gstd = 0.0;
  else
    gstd = sqrt((gtsq-(gaver*gaver*(double)(extiter*numnodes())))/
                (double)((extiter*numnodes())-1));
  
 /*               OP  IOD CLT  MYN CA M  EI  II  SIZ MIN   MAX   AVG   STD */
  sprintf(output,"%6s %2d %2ld %2d %c %c %4d %2d %7d %9.4f %9.4f %9.4f %9.4f\n",
          op2str(op),
          iodnumber,
          numnodes(),
          numnodes(),
          syncflag ? 'S' : 'A',
          mode2char(mode),
          extiter,
          intiter,
          size,
          gmin,
          gmax,
          gaver,
          gstd);

  setiomode(resultfd,M_GLOBAL);
  cwrite(resultfd,output,strlen(output));
  
  
  aver = (total/(double)extiter);
  if (extiter == 1)
    std = 0.0;
  else
    std = sqrt((tsq-(aver*aver*(double)extiter))/(double)(extiter - 1));

 /*               OP  IOD CLT  MYN CA M  EI  II  SIZ MIN   MAX   AVG   STD */
  sprintf(output,"%6s %2d %2ld %2d %c %c %4d %2d %7d %9.4f %9.4f %9.4f %9.4f\n",
          op2str(op),
          iodnumber,
          numnodes(),
          mynode(),
          syncflag ? 'S' : 'A',
          mode2char(mode),
          extiter,
          intiter,
          size,
          min,
          max,
          aver,
          std);

  setiomode(resultfd,M_SYNC);
  cwrite(resultfd,output,strlen(output));

  return;
}


void meas_op
#ifdef ANSI_C
(optype op, int extiter, int intiter, int size)
#else
(op, extiter, intiter, size)
optype op;
int extiter;
int intiter;
int size;
#endif
{
  int ei;
  int ii;
  long id[20];
  double start;
  double time;
  double total = 0.0;
  double tsq = 0.0;
  double min = -1.0;
  double max = -1.0;

  gsync();

  for (ei = 0; ei < extiter; ei++)
  {
    switch (op)
    {
    case CWR:
      start = dclock();
      for(ii = 0; ii < intiter; ii++)
        cwrite(outputfd,buffer,size);
      time = (dclock() - start);
      break;
    case CRD:
      start = dclock();
      for (ii=0;ii<intiter;ii++)
        cread(inputfd,buffer,size);
      time = (dclock() - start);
      break;
    case IWRW:
      start = dclock();
      for (ii=0;ii<intiter;ii++)
      {
        id[0]=iwrite(outputfd,buffer,size);
        iowait(id[0]);
      }
      time = (dclock() - start);
      break;
    case IRDW:
      start = dclock();
      for (ii = 0; ii < intiter; ii++)
      {
        id[0] = iread(inputfd,buffer,size);
        iowait(id[0]);
      }
      time = (dclock() - start);
      break;
    case IWRIOW:
      start = dclock();
      for (ii=0;ii<intiter;ii++)
        id[ii]=iwrite(outputfd,buffer,size);
      for (ii=0;ii<intiter;ii++)
        iowait(id[ii]);
      time = (dclock() - start);
      break;
    case IRDIOW:
      start = dclock();
      for (ii = 0; ii < intiter; ii++)
        id[ii] = iread(inputfd,buffer,size);
      for (ii = 0; ii < intiter; ii++)
        iowait(id[ii]);
      time = (dclock() - start);
      break;
    case IWR:
      start = dclock();
      for (ii=0;ii<intiter;ii++)
        id[ii]=iwrite(outputfd,buffer,size);
      time = (dclock() - start);
      for (ii=0;ii<intiter;ii++)
        iowait(id[ii]);
      break;
    case IRD:
      start = dclock();
      for (ii = 0; ii < intiter; ii++)
        id[ii] = iread(inputfd,buffer,size);
      time = (dclock() - start);
      for (ii = 0; ii < intiter; ii++)
        iowait(id[ii]);
      break;
    case WIOW:
      for (ii=0;ii<intiter;ii++)
        id[ii]=iwrite(outputfd,buffer,size);
      start = dclock();
      for (ii=0;ii<intiter;ii++)
        iowait(id[ii]);
      time = (dclock() - start);
      break;
    case RIOW:
      for (ii = 0; ii < intiter; ii++)
        id[ii] = iread(inputfd,buffer,size);
      start = dclock();
      for (ii = 0; ii < intiter; ii++)
        iowait(id[ii]);
      time = (dclock() - start);
      break;
    }

    total += time;
    tsq += time*time;
    if ((max == -1.0) || (time > max))
      max = time;
    if ((min == -1.0) || (time < min))
      min = time;
  }
  
  write_res(op,extiter,intiter,size,min,max,total,tsq);
  
  return;
}

int main
#ifdef ANSI_C
(int argc, char **argv)
#else
(argc, argv)
int argc;
char **argv;
#endif
{
  char  *resultfile = NULL;
  char  *pfsdhost   = NULL;
  int    extiter    = -1;
  int    intiter    = -1;
  int    minimum    = -1;
  int    maximum    = -1;
  int    step       = -1;
  char  *modes      = NULL;
  char **opargs     = NULL;
  int client_threshold;
  int server_threshold;
  int inputfilesize;
  
  int goerr = 0;
  
  int c;
  int i;
  int fd;
  char *mp;
  optype op;
  int size;
  char **opa;
  
  while (((c = getopt(argc,argv,"r:h:d:ase:i:n:x:t:m:o")) != -1) &&
         (opargs == NULL))
  {
    switch (c)
    {
    case 'r':
      if (resultfile != NULL)
        fprintf(stderr,"%s: Warning: Overwriting -r flag\n",argv[0]);
      resultfile = optarg;
      break;
    case 'h':                   /* Hostname */
      if (pfsdhost != NULL)
        fprintf(stderr,"%s: Warning: Overwriting -h flag\n",argv[0]);
      pfsdhost = optarg;
      break;
    case 'd':
      if (iodnumber != -1)
        fprintf(stderr,"%s: Warning: Overwriting -d flag\n",argv[0]);
      if ((iodnumber = atoi(optarg)) < 0)
      {
        fprintf(stderr,"%s: Invalid -d option argument %s\n",argv[0],optarg);
        goerr++;
      }
      break;
    case 'a':                   /* Client asynchron */
      if (syncflag == 1)
        fprintf(stderr,"%s: Warning: Overwriting -s flag\n",argv[0]);
      syncflag = 0;
      break;
    case 's':                   /* Client synchron */
      if (syncflag == 0)
        fprintf(stderr,"%s: Warning: Overwriting -a flag\n",argv[0]);
      syncflag = 1;
      break;
    case 'e':
      if (extiter != -1)
        fprintf(stderr,"%s: Warning: Overwriting -e flag\n",argv[0]);
      if ((extiter = atoi(optarg)) <= 0)
      {
        fprintf(stderr,"%s: Invalid -e option argument %s\n",argv[0],optarg);
        goerr++;
      }
      break;
    case 'i':
      if (intiter != -1)
        fprintf(stderr,"%s: Warning: Overwriting -i flag\n",argv[0]);
      if ((intiter = atoi(optarg)) <= 0)
      {
        fprintf(stderr,"%s: Invalid -i option argument %s\n",argv[0],optarg);
        goerr++;
      }
      break;
    case 'n':
      if (minimum != -1)
        fprintf(stderr,"%s: Warning: Overwriting -n flag\n",argv[0]);
      if ((minimum = atoi(optarg)) < 0)
      {
        fprintf(stderr,"%s: Invalid -n option argument %s\n",argv[0],optarg);
        goerr++;
      }
      break;
    case 'x':
      if (maximum != -1)
        fprintf(stderr,"%s: Warning: Overwriting -x flag\n",argv[0]);
      if ((maximum = atoi(optarg)) < 0)
      {
        fprintf(stderr,"%s: Invalid -x option argument %s\n",argv[0],optarg);
        goerr++;
      }
      break;
    case 't':
      if (step != -1)
        fprintf(stderr,"%s: Warning: Overwriting -t flag\n",argv[0]);
      if ((step = atoi(optarg)) < 0)
      {
        fprintf(stderr,"%s: Invalid -t option argument %s\n",argv[0],optarg);
        goerr++;
      }
      break;
    case 'm':
      if (modes != NULL)
        fprintf(stderr,"%s: Warning: Overwriting -m flag\n",argv[0]);
      modes = optarg;
      for (mp = modes; *mp != '\0'; mp++)
        if ((*mp != 'g') &&     /* global */
            (*mp != 'l') &&     /* log */
            (*mp != 'r') &&     /* record */
            (*mp != 's') &&     /* sync */
            (*mp != 'u'))       /* unix */
        {
          fprintf(stderr,"%s: Invalid -m option argument %s: %c\n",
                  argv[0],optarg,*mp);
          goerr++;
        }
      break;
    case 'o':
      opargs = &argv[optind];
      for (i=optind; i < argc; i++)
      {
        if (str2op(argv[i]) == NO_OP)
        {
          fprintf(stderr,"%s: Invalid -o option argument %s\n",
                  argv[0],argv[i]);
          goerr++;
        }
      }
      break;
    case '?':
      fprintf(stderr,"%s: Invalid option\n");
      goerr++;
      break;
    }
  }
  
  if (resultfile == NULL)
    resultfile = DFLTRESULTFILE;

  if (pfsdhost == NULL)
    pfsdhost = DFLTPFSDHOST;
  
  if (iodnumber == -1)
    iodnumber = DFLTIODNUMBER;

  if (syncflag == -1)
    syncflag = DFLTSYNCFLAG;
  
  if (extiter == -1)
    extiter = DFLTEXTITER;
  
  if (intiter == -1)
    intiter = DFLTINTITER;
  
  if (minimum == -1)
    minimum = DFLTMINIMUM;
  
  if (maximum == -1)
    maximum = DFLTMAXIMUM;
  
  if (step == -1)
    step = DFLTSTEP;
  
  if (modes == NULL)
    modes = DFLTMODES;
  
  if (opargs == NULL)
    opargs = dfltopargs;
  
  if (minimum > maximum)
  {
    fprintf(stderr,"%s: Error: Minimum greater than maximum\n");
    goerr++;
  }
  
  if (maximum > BUFFSIZE)
  {
    fprintf("%s: Error: Maximum greater than internal Buffersize (%d)\n",
            BUFFSIZE);
    goerr++;
  }
  
  if ((minimum == 0) && (step == 0))
  {
    fprintf(stderr,"%s: Error: Can't use exponential step starting with 0\n");
    goerr++;
  }
  
  if (intiter > MAXINTITER)
  {
    fprintf("%s: Error: Internal iteration must be less than %d\n",argv[0],
            MAXINTITER);
    goerr++;
  }

  if (goerr)
  {
    fprintf(stderr,"Usage: %s %s\n",argv[0],USAGE);
    exit (1);
  }
  
  if (syncflag)
    client_threshold = maximum;
  else
    client_threshold = 0;
  
  if (iodnumber == 0)
    server_threshold = maximum;
  else
    server_threshold = 0;
  
  
  inputfilesize = maximum*extiter*intiter*numnodes();

  _pfslib_init(pfsdhost,numnodes(),mynode(),server_threshold,client_threshold);

  _dbgmsg("Nach _pfslib_init()");

  /* Open result file */
  resultfd = gopen(resultfile,O_CREAT|O_WRONLY|O_APPEND,M_UNIX,0644);
  
  _dbgmsg("Nach gopen()");

  inputfd  = gopen(INPUTFILE,O_CREAT|O_RDWR,M_UNIX,0644);
  
  _dbgmsg("Nach gopen()");

  outputfd = gopen(OUTPUTFILE,O_CREAT|O_WRONLY|O_TRUNC,M_UNIX,0644);
  
  _dbgmsg("Nach gopen()");

  if (mynode() == 0)
  {
    lsize(inputfd,inputfilesize,SIZE_SET);
  }
  
  _dbgmsg("Nach lsize()");

  for (mp = modes; *mp != '\0'; mp++)
  {
    switch (*mp)
    {
    case 'u':
      mode = M_UNIX;
      break;
    case 'g':
      mode = M_GLOBAL;
      break;
    case 'l':
      mode = M_LOG;
      break;
    case 's':
      mode = M_SYNC;
      break;
    case 'r':
      mode = M_RECORD;
      break;
    }
      
    setiomode(inputfd,M_UNIX);
    setiomode(outputfd,M_UNIX);
  
    if (mynode() == 0)
      fprintf(stderr,"IO-mode set to %s\n",mode2str(mode));

    for (opa = opargs; *opa != NULL; opa++)
    {
      if ((op = str2op(*opa)) == NO_OP)
      {
        fprintf(stderr,"%s: No such operation: %s; skipping\n",*opa);
        break;
      }
      
      if (mynode() == 0)
        fprintf(stderr,"Running operation %s\n",*opa);

      if (lseek(inputfd,0,SEEK_SET) != 0)
      {
        perror("lseek(inputfile)");
        exit(1);
      }
    
      if (lseek(outputfd,0,SEEK_SET) != 0)
      {
        perror("lseek(outputfile)");
        exit(1);
      }
    

      for (size = minimum; size <= maximum;)
      {
        meas_op(op, extiter, intiter, size);
	if (step == 0)
	  size += step;
	else
	  size *= 2;
      }
    }
  }

  close(resultfd);
  close(inputfd);
  close(outputfd);
  
  exit (0);
}

