/******************************************************************************
 *
 *    pfsdreset.c,v : reset the filetable in a pfsd 
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : pfsdreset.c,v
 *  RCS Date     : 1995/11/29 14:05:05
 *  RCS Revision : 1.6
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef lint
static char rcs_id[] = "pfsdreset.c,v 1.6 1995/11/29 14:05:05 lamberts Rel";
#endif

#include <rpc/rpc.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/tcp.h>
#include <stdio.h>
#include <stdlib.h>
#ifdef SUN4
#include <memory.h>
#else
#include <string.h>
#endif /* SUN4 */
#include <unistd.h>

#include "pfsd.h"


int main
#ifdef ANSI_C
(int argc, char **argv)
#else
(argc, argv)
int argc;
char **argv;
#endif /* ANSI_C */
{
  CLIENT *clnt;

  struct hostent *hp;
  struct sockaddr_in addr;
  int sockp = RPC_ANYSOCK;

  int sooptarg;

  resetres    *result;
  resetargs   args;

	int ac;

	if ( argc < 2 )
	{
		fprintf(stdout,"usage: %s <pfsd_host> [<fname(1)> <fname(2)> ... <fname(n)>]\n", argv[0]);
		exit(1);
	}

  /* Create client transport */

  if ((hp = gethostbyname(argv[1])) == (struct hostent *)0)
  {
    perror("gethostbyname()");
    exit (1);
  }

  memset(&addr, 0, sizeof(struct sockaddr_in));
  addr.sin_family = AF_INET;
  memcpy(&addr.sin_addr, hp->h_addr, (size_t)hp->h_length);
  addr.sin_port = htons(0);

	if ((clnt = clnttcp_create(&addr, PFSD, PFSD_VERS,
                             &sockp, RPC_IOD_BUFSZ, RPC_IOD_BUFSZ)) == NULL)
	{
		clnt_pcreateerror("clnttcp_create()");
		exit(1);
	}

  /* Set REUSEADDR */
  sooptarg = 1;
  setsockopt(sockp,SOL_SOCKET,SO_REUSEADDR,(char *)&sooptarg,sizeof(sooptarg));
  /* TCP_NODELAY */
  sooptarg = 1;
  setsockopt(sockp,IPPROTO_TCP,TCP_NODELAY,(char *)&sooptarg,sizeof(sooptarg));

	auth_destroy(clnt->cl_auth);
	clnt->cl_auth = authunix_create_default();


  /* Reset file(s) */

  if (argc == 2)
  {    
    args.fname = "";
    
    if ((result = pfsd_reset_1(&args, clnt)) == NULL)
    {
      clnt_perror(clnt,"pfsd_reset_1() call failed");
      exit(1);
    }
    
    if (result->stat == RPC_ERR)
    {
      perror("Reset failed");
      exit(1);
    }

    fprintf(stdout,"%s: Reset %d files\n",argv[0],result->resetres_u.count);
    
    xdr_free(xdr_resetres, (char *)result);

    exit(0);
  }
  
	for (ac=2; ac<argc; ac++ )
	{
    args.fname = argv[ac];
    
    if ((result = pfsd_reset_1(&args, clnt)) == NULL)
    {
      clnt_perror(clnt,"pfsd_reset_1() call failed");
      exit(1);
    }
    
    if (result->stat == RPC_ERR)
    {
      perror("Reset failed");
    }
    else
    {
      fprintf(stdout,"%s: Reset %d files named %s\n",
              argv[0],result->resetres_u.count,argv[ac]);
    }
    
    xdr_free(xdr_resetres, (char *)result);
	}

	exit(0);
}
