/******************************************************************************
 *
 *    clnt_write.c,v : synchronous and asynchronous write operations
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : clnt_write.c,v
 *  RCS Date     : 1995/11/23 17:52:55
 *  RCS Revision : 1.6
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef lint
static char rcs_id[] = "clnt_write.c,v 1.6 1995/11/23 17:52:55 lamberts Rel";
#endif


#include <rpc/rpc.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <stdlib.h>
#include <errno.h>

#include "pfsd.h"
#include "clnt_defines.h"
#include "clnt_macros.h"

extern ioIDtabel _pfslib_ioidtbl[];

extern long _ioopv
#ifdef ANSI_C
(int op, int fd, struct iovec *iov, int iovcnt, bool_t ccall);
#else
();
#endif /* ANSI_C */

extern long _ioop
#ifdef ANSI_C
(int op, int fd, char *buffer, unsigned int nbytes, bool_t ccall);
#else
();
#endif /* ANSI_C */

extern void pfslib_perror
#ifdef ANSI_C
(char *str);
#else
();
#endif /* ANSI_C */

extern long _iowait
#ifdef ANSI_C
(long ioID);
#else
();
#endif /* ANSI_C */

extern long _vectorlength
#ifdef ANSI_C
(struct iovec *iov, int iovcnt);
#else
();
#endif /* ANSI_C */


/* ************************************************************************ */
/*                                                                          */
/* iwrite(): asynchronous (nonblocking) write in a shared file              */
/*                                                                          */
/* ************************************************************************ */


long _iwritev
#ifdef ANSI_C
(int filedes, struct iovec *iov, int iovcnt)
#else
(filedes, iov, iovcnt)
int filedes;
struct iovec *iov;
int iovcnt;
#endif /* ANSI_C */
{
	return (_ioopv(WRITEV_OP,filedes, iov, iovcnt, FALSE));
}

long _iwrite
#ifdef ANSI_C
(int filedes, char *buffer, unsigned int nbytes)
#else
(filedes, buffer, nbytes)
int filedes;
char *buffer;
unsigned int nbytes;
#endif /* ANSI_C */
{
	return (_ioop(WRITE_OP,filedes, buffer, nbytes, FALSE));
}


long iwritev
#ifdef ANSI_C
(int filedes, struct iovec *iov, int iovcnt)
#else
(filedes, iov, iovcnt)
int filedes;
struct iovec *iov;
int iovcnt;
#endif /* ANSI_C */
{
  long ioID;

	if ((ioID = _iwritev(filedes, iov, iovcnt)) < 0)
  {
		pfslib_perror("iwrite()");
    exit (1);
  }

	return(ioID);
}

long iwrite
#ifdef ANSI_C
(int filedes, char *buffer, unsigned int nbytes)
#else
(filedes, buffer, nbytes)
int filedes;
char *buffer;
unsigned int nbytes;
#endif /* ANSI_C */
{
  long res;

	if ((res = _iwrite(filedes, buffer, nbytes)) < 0)
  {
		pfslib_perror("iwrite()");
    exit(1);
  }
  
	return (res);
}

/* ************************************************************************ */
/*                                                                          */
/* cwrite(): synchronous (blocking) write in a shared file                  */
/*                                                                          */
/* ************************************************************************ */

long _cwritev
#ifdef ANSI_C
(int filedes, struct iovec *iov, int iovcnt)
#else
(filedes, iov, iovcnt)
int filedes;
struct iovec *iov;
int iovcnt;
#endif /* ANSI_C */
{
	long res;
	long ioID;

	if ((ioID = _ioopv(WRITEV_OP, filedes, iov, iovcnt, TRUE)) < 0 )
		return(-1);

  res = _IDTE.reallen;

	if (_iowait(ioID) < 0 )
		return(-1);

	return(res);
}

long _cwrite
#ifdef ANSI_C
(int filedes, char *buffer, unsigned int nbytes)
#else
(filedes, buffer, nbytes)
int filedes;
char *buffer;
unsigned int nbytes;
#endif /* ANSI_C */
{
	long ioID;
  long res;
  
	if ((ioID = _ioop(WRITE_OP, filedes, buffer, nbytes, TRUE)) < 0)
		return (-1);

  res = _IDTE.reallen;

	if (_iowait(ioID) < 0 )
		return(-1);

	return(res);
}

void cwritev
#ifdef ANSI_C
(int filedes, struct iovec *iov, int iovcnt)
#else
(filedes, iov, iovcnt)
int filedes;
struct iovec *iov;
int iovcnt;
#endif /* ANSI_C */
{
  long res;

	if ((res = _cwritev(filedes, iov, iovcnt))
      != _vectorlength(iov,iovcnt))
  {
    if (res >= 0) errno = EPFSLNBYTES;
		pfslib_perror("cwritev()");
    exit (1);
  }

	return;
}

void cwrite
#ifdef ANSI_C
(int filedes, char *buffer, unsigned int nbytes)
#else
(filedes, buffer, nbytes)
int filedes;
char *buffer;
unsigned int nbytes;
#endif /* ANSI_C */
{
  long res;

	if ((res = _cwrite( filedes, buffer, nbytes)) != nbytes)
  {
    if (res >= 0) errno = EPFSLNBYTES;
		pfslib_perror("cwrite()");
    exit(1);
  }

	return;
}
