/******************************************************************************
 *
 *    clnt_vecop.c,v : vector functions for readv and writev operations
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : clnt_vecop.c,v
 *  RCS Date     : 1995/11/23 17:53:17
 *  RCS Revision : 1.5
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef lint
static char rcs_id[] = "clnt_vecop.c,v 1.5 1995/11/23 17:53:17 lamberts Rel";
#endif


#include <sys/types.h>
#include <sys/uio.h>
#include <string.h>

long _vectorlength
#ifdef ANSI_C
(struct iovec *iov, int iovcnt)
#else
(iov,iovcnt)
struct iovec *iov;
int iovcnt;
#endif /* ANSI_C */
{
  int i;
  long len = 0;
  
  for (i=0; i<iovcnt; i++)
    len += iov[i].iov_len;

  return (len);
}




void _vectorcollect
#ifdef ANSI_C
(char *buffer, struct iovec *iov, int iovcnt)
#else
(buffer, iov,iovcnt)
char *buffer;
struct iovec *iov;
int iovcnt;
#endif /* ANSI_C */
{
  int i;
  char *bp = buffer;

  for (i=0; i<iovcnt; i++)
  {
    memcpy(bp,iov[i].iov_base,(size_t)iov[i].iov_len);
    bp += iov[i].iov_len;
  }
  
  return;
}

void _vectordistribute
#ifdef ANSI_C
(char *buffer, struct iovec *iov, int iovcnt)
#else
(buffer, iov,iovcnt)
char *buffer;
struct iovec *iov;
int iovcnt;
#endif /* ANSI_C */
{
  int i;
  char *bp = buffer;
  
  for (i=0; i<iovcnt; i++)
  {
    memcpy(iov[i].iov_base,bp,(size_t)iov[i].iov_len);
    bp += iov[i].iov_len;
  }
  
  return;
}
