/******************************************************************************
 *
 *    clnt_timout.c,v : set RPC timeout 
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : clnt_timout.c,v
 *  RCS Date     : 1995/11/29 14:03:53
 *  RCS Revision : 1.5
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef lint
static char rcs_id[] = "clnt_timout.c,v 1.5 1995/11/29 14:03:53 lamberts Rel";
#endif


#include <rpc/rpc.h>
#include <stdlib.h>
#ifdef HPPA
#include <sys/time.h>
#endif /* HPPA */

#include "timeouts.h"

void _pfslib_awaitresult
#ifdef ANSI_C
(CLIENT *clnt)
#else
(clnt)
CLIENT *clnt;
#endif /* ANSI_C */
{
	struct timeval settimeout;

	settimeout.tv_sec  = AWAITTIMEOUT;
	settimeout.tv_usec = 0;
			
	if (!clnt_control(clnt, CLSET_TIMEOUT, (char *)&settimeout))
	{
		clnt_perror(clnt,"couldn't change timeout");
		exit (1);
	}
}

void _pfslib_resettimeout
#ifdef ANSI_C
(CLIENT *clnt)
#else
(clnt)
CLIENT *clnt;
#endif /* ANSI_C */
{
	struct timeval settimeout;

	settimeout.tv_sec  = DFLTTIMEOUT;
	settimeout.tv_usec = 0;
			
	if (!clnt_control(clnt, CLSET_TIMEOUT, (char *)&settimeout))
	{
		clnt_perror(clnt,"couldn't change timeout");
		exit (1);
	}
}

