/******************************************************************************
 *
 *    clnt_open.c,v : open a shared or local  file
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : clnt_open.c,v
 *  RCS Date     : 1995/11/23 17:42:46
 *  RCS Revision : 1.7
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef lint
static char rcs_id[] = "clnt_open.c,v 1.7 1995/11/23 17:42:46 lamberts Rel";
#endif


#include <rpc/rpc.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include <stdlib.h>

#include "pfsd.h"
#include "pfslib_errno.h"
#include "clnt_defines.h"
#include "clnt_macros.h"

extern int _pfslib_maxfiles;
extern int _pfslib_mynumber;
extern int _pfslib_numclnts;
extern pfslib_fhdl *_pfslib_ftbl;
extern CLIENT *_pfslib_clnt;

extern void _pfslib_awaitresult
#ifdef ANSI_C
(CLIENT *clnt);
#else
();
#endif /* ANSI_C */

extern void _pfslib_resettimeout
#ifdef ANSI_C
(CLIENT *clnt);
#else
();
#endif /* ANSI_C */

extern void pfslib_perror
#ifdef ANSI_C
(char *str);
#else
();
#endif /* ANSI_C */


static bool_t replcross
#ifdef ANSI_C
(char *out, char *in, int mynumber)
#else
(out, in, mynumber)
char *out;
char *in;
int mynumber;
#endif /* ANSI_C */
{
  bool_t repl = FALSE;

  char format[200];

  char *ipos = in;
  char *opos = out;
  unsigned int  len;
  char *cpos;
  int  clen;
  
  while ((cpos = strstr(ipos,"###")) != (char *)0)
  {
    repl = TRUE;                /* A replacement occured */
    
    /* copy this chunk to out */
    len = cpos - ipos;
    strncpy(opos,ipos,len);
    opos += len;
    *opos = '\0';
    
    for (clen = 3, ipos = cpos+3; *ipos == '#'; clen++, ipos++);
    
    sprintf(format ,"%%0%dd",clen);
    
    sprintf(opos,format,mynumber);
    
    opos += strlen(opos);       /* set opos to the end of the string */
  }
  
  /* Copy the rest of io to out */
  strcpy(opos, ipos);
  
  return (repl);
}

/* ************************************************************************ */
/*                                                                          */
/* _pflib_open(): make rpc to close a shared file                           */
/*                                                                          */
/* ************************************************************************ */

int _pfslib_open
#ifdef ANSI_C
(char *filename, int oflags, mode_t perm, int mode, int how_many, int which, bool_t global)
#else
(filename, oflags, perm, mode, how_many, which, global)
char *filename;
int oflags;
mode_t perm;
int mode;
int how_many;
int which;
bool_t global;
#endif /* ANSI_C */
{
	openres  	*result;
	openargs  arg;

  char realfname[MAXNLEN];
  
  int i;

  if (filename[0] == '/')
  {
    if (strlen(filename) >= MAXNLEN)
    {
      errno = ENAMETOOLONG;
      return (-1);
    }
    strcpy(realfname,filename);
  }
  else 
  {
    if (getcwd(realfname,MAXNLEN) == NULL)
    {
      perror("_pfslib_open(): getcwd()");
      return (-1);
    }
    if ((strlen(filename)+strlen(realfname)+1) >= MAXNLEN)
    {
      errno = ENAMETOOLONG;
      return (-1);
    }
    strcat(realfname,"/");
    strcat(realfname,filename);
  }

	/* not set up as PFSLib client until now
	if ( _pfslib_clnt == NULL )
		pfslib_init(PFSDHOST, DFLTNUMCL, DFLTWHICH);
	*/
	
  /* find the lowest empty table element */
  for (i=0; i < _pfslib_maxfiles;i++)
    if (_pfslib_ftbl[i].vfd == -1)
      break;
    
  if (i >= _pfslib_maxfiles)
  {
    errno = EPFSLMFILE;
    return (-1);
  }
    
	/*
	 * then lets call the pfsd 
	 */
  arg.global     = global;
	arg.filename   = realfname;
	arg.oflags     = oflags;
	arg.permission = (int)perm;
	arg.how_many   = how_many;
	arg.which      = which;
  arg.mode       = mode;
  
  if (global)
    _pfslib_awaitresult(_pfslib_clnt);

	if ((result = pfsd_open_1(&arg, _pfslib_clnt)) == NULL )
	{
		clnt_perror(_pfslib_clnt, "open() call failed:");
		exit(1);
	}

  _pfslib_resettimeout(_pfslib_clnt);
  

  ERR_RESULT(openres_u, xdr_openres);
  
  /* make the entry in the file hanlde table */

  _pfslib_ftbl[i] = result->openres_u.fh;

  xdr_free(xdr_openres, (char *)result);

  return (i + VFDOFFSET);
}

/* ************************************************************************ */
/*                                                                          */
/* cio_open(): open a local or a shared file                                */
/*                                                                          */
/* ************************************************************************ */


int pfslib_open
#ifdef ANSI_C
(char *filename, int oflags, mode_t perm)
#else
(filename,oflags,perm)
char *filename;
int oflags;
mode_t perm;
#endif /* ANSI_C */
{
	int	    filedes;           /* result of this function */
  char    fname[MAXNLEN];
	bool_t	localfile=FALSE;   /* local or a shared file ? */


	/* first decide if we have a local or a shared file */


  /* Filenames with a ### in it are local files. ###+ will be replaced with
   * 001 ... 1000 etc. */
  /* File with pfs i its name are PFSLib files */
	localfile = (replcross(fname,filename,_pfslib_mynumber) ||
               (strstr(fname,"pfs") == (char *)0)); 

	if (!localfile)
	{
		/* then lets call the pfsd */
		filedes = _pfslib_open(fname, oflags, perm, M_UNIX, _pfslib_numclnts,
                           _pfslib_mynumber, FALSE);
	}
	else
	{
		/* we have a local file just for the calling process */
    filedes = open(fname, oflags, perm);
	}

	return(filedes);
}




int _gopen
#ifdef ANSI_C
(char *path, int oflag, int mode, mode_t perm)
#else
(path,oflag,mode,perm)
char *path;
int oflag;
int mode;
mode_t perm;
#endif /* ANSI_C */
{
  return (_pfslib_open(path, oflag, perm, mode, _pfslib_numclnts,
                       _pfslib_mynumber, TRUE));
}


int gopen
#ifdef ANSI_C
(char *path, int oflag, int mode, mode_t perm)
#else
(path, oflag, mode, perm)
char *path;
int oflag;
int mode;
mode_t perm;
#endif /* ANSI_C */
{
  int res;
  
  if ((res = _gopen(path, oflag, mode, perm)) < 0)
  {
    pfslib_perror("gopen():");
    exit (1);
  }
  return (res);
}


