/******************************************************************************
 *
 *    clnt_lsize.c,v : increase the size of a shared file
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : clnt_lsize.c,v
 *  RCS Date     : 1995/11/23 17:42:45
 *  RCS Revision : 1.5
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef lint
static char rcs_id[] = "clnt_lsize.c,v 1.5 1995/11/23 17:42:45 lamberts Rel";
#endif


#include <rpc/rpc.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>

#include "pfsd.h"
#include "clnt_defines.h"
#include "clnt_macros.h"
#include "pfslib_errno.h"

extern int _pfslib_maxfiles;
extern CLIENT * _pfslib_clnt;

extern pfslib_fhdl * _pfslib_ftbl;

extern void pfslib_perror
#ifdef ANSI_C
(char *str);
#else
();
#endif /* ANSI_C */

long _lsize
#ifdef ANSI_C
(int fd, off_t offset, int whence)
#else
(fd, offset, whence)
int fd;
off_t offset;
int whence;
#endif /* ANSI_C */
{
	lsizeres  	*result;
	fpmoveargs 	arg;
  long size;

  fd -= VFDOFFSET;

  /* Check arguments */
  if ((fd < 0) || (fd >= _pfslib_maxfiles) ||
      (_pfslib_ftbl[fd].vfd == -1))
  {
    errno = EPFSLBADF;
    return (-1);
  }
  
  if ((whence != SIZE_SET) &&
      (whence != SIZE_CUR) &&
      (whence != SIZE_END))
  {
    errno = EPFSLINVAL;
    return (-1);
  }
  
  arg.fh     = _pfslib_ftbl[fd];
  arg.whence = whence;
  arg.offset = (u_int)offset;


  if ((result = pfsd_lsize_1(&arg, _pfslib_clnt)) == NULL)
  {
    clnt_perror(_pfslib_clnt, "extend() call failed:");
    exit (1);
  }

  ERR_RESULT(lsizeres_u, xdr_lsizeres);
  
  size = (long)result->lsizeres_u.size;

  xdr_free(xdr_lsizeres, (char *)result);
  
  return (size);
}

long lsize
#ifdef ANSI_C
(int filedes, off_t offset, int whence)
#else
(filedes, offset, whence)
int filedes;
off_t offset;
int whence;
#endif /* ANSI_C */
{
	long res;

	if ((res = _lsize( filedes, offset, whence)) < 0)
  {
		pfslib_perror("lsize()");
    exit (1);
  }

	return(res);
}
