/******************************************************************************
 *
 *    clnt_iowait.c,v : wait for the end of an IO
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : clnt_iowait.c,v
 *  RCS Date     : 1995/11/29 14:40:02
 *  RCS Revision : 1.8
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef lint
static char rcs_id[] = "clnt_iowait.c,v 1.8 1995/11/29 14:40:02 lamberts Rel";
#endif

#include <rpc/rpc.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <errno.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>

#include "pfsd.h"
#include "clnt_defines.h"
#include "clnt_macros.h"
#include "pfslib_errno.h"

extern ioIDtabel _pfslib_ioidtbl[];
extern pfslib_fhdl * _pfslib_ftbl;
extern CLIENT * _pfslib_clnt;

extern void _copy_child_shm
#ifdef ANSI_C
(long ioID);
#else
();
#endif /* ANSI_C */

extern void _pfslib_awaitresult
#ifdef ANSI_C
(CLIENT *clnt);
#else
();
#endif /* ANSI_C */

extern void _pfslib_resettimeout
#ifdef ANSI_C
(CLIENT *clnt);
#else
();
#endif /* ANSI_C */

extern void pfslib_perror
#ifdef ANSI_C
(char *str);
#else
();
#endif /* ANSI_C */

long _iowait
#ifdef ANSI_C
(long ioID)
#else
(ioID)
int ioID;
#endif /* ANSI_C */
{
	iowaitres  		*result;
	ioidstatargs  arg;

#ifdef CHILDSIGNAL
#ifdef BSD_SIG
  int oldmask;
#else  /* BSD_SIG */
  sigset_t set;
  sigset_t oset;
#endif /* BSD_SIG */
#else  /* CHILDSIGNAL */
  pid_t pid;
  int state;
#endif /* CHILDSIGNAL */

	/* 
	 * input correct?
	 */

  if ((ioID < 0) || (ioID >= MAXIOID) ||
      (_IDTE.state == IDT_UNUSED))
	{
		errno  = EPFSLBADID;
    return (-1);
  }
  
#ifdef CHILDSIGNAL

  /* Block SIGCHLD to check the condition */
#ifdef BSD_SIG
  oldmask = sigblock(sigmask(SIGCHLD));
#else  /* BSD_SIG */
  sigemptyset(&set);
  sigaddset(&set,SIGCHLD);
  sigprocmask(SIG_BLOCK,&set,&oset);
  sigemptyset(&set);
#endif /* BSD_SIG */

  while(_IDTE.state != IDT_CLTDONE)
  {
#ifdef BSD_SIG
    sigpause(0);
#else  /* BSD_SIG */
    sigsuspend(&set);
#endif /* BSD_SIG */
  }
  
#ifdef BSD_SIG
  sigsetmask(oldmask);
#else  /* BSD_SIG */
  sigprocmask(SIG_SETMASK,&oset,(sigset_t *)0);
#endif /* BSD_SIG */

#else  /* CHILDSIGNAL */

  if (_IDTE.state != IDT_CLTDONE)
  {
    if (_IDTE.childpid == -1)
    {
      errno = EPFSLNOCHLD;
      return (-1);
    }

    if ((pid = waitpid(_IDTE.childpid,&state,0)) != _IDTE.childpid)
    {
      perror("waitpid()");
      exit (1);
    }
 
    if (WIFSIGNALED(state) || WIFEXITED(state))
    {
      if ((!WIFSIGNALED(state)) && (WEXITSTATUS(state) == 0))
        _copy_child_shm(ioID);
      
      _IDTE.childpid  = -1;
      _IDTE.state     = IDT_CLTDONE;
      _IDTE.childexit = state;
      _IDTE.shmid     = -1;
    }
  }
#endif /* CHILDSIGNAL */
  

  if (!_IDTE.csync)
  {
    if (WIFSIGNALED(_IDTE.childexit))
    {
      errno = EPFSLCHLDSIG;
      return (-1);
    }
    
    if (WEXITSTATUS(_IDTE.childexit) != 0)
    {
      errno = EPFSLCHLDEXIT;
      return (-1);
    }
  }
  
  arg.fh = _pfslib_ftbl[_IDTE.fd];
  arg.ioID = _IDTE.svrioID;

  _pfslib_awaitresult(_pfslib_clnt);

  if ( (result = pfsd_iowait_1(&arg,_pfslib_clnt)) == NULL )
  {
    clnt_perror(_pfslib_clnt, "pfsd_iowait_1()");
    perror("pfsd_iowait_1()");
    exit (1);
  }

  _pfslib_resettimeout(_pfslib_clnt);

  ERR_RESULT(iowaitres_u, xdr_iowaitres);

  xdr_free(xdr_iowaitres, (char *)result);

  _IDTE.state = IDT_UNUSED;
  _IDTE.childpid = -1;
  _IDTE.shmid    = -1;

  return (0);
}

void iowait
#ifdef ANSI_C
(int ioID)
#else
(ioID)
int ioID;
#endif /* ANSI_C */
{
	if (_iowait(ioID) < 0 )
  {
		pfslib_perror("iowait()");
    exit (1);
  }

	return;
}
