/******************************************************************************
 *
 *    clnt_ioop_pfs.c,v : Input/Output from to PFSD
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : clnt_ioop_pfs.c,v
 *  RCS Date     : 1995/11/29 14:39:27
 *  RCS Revision : 1.8
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef lint
static char rcs_id[] = "clnt_ioop_pfs.c,v 1.8 1995/11/29 14:39:27 lamberts Rel";
#endif

#include <rpc/rpc.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>

#include "pfsd.h"
#include "clnt_defines.h"
#include "clnt_macros.h"

extern ioIDtabel _pfslib_ioidtbl[];
extern pfslib_fhdl * _pfslib_ftbl;

extern void _vectordistribute
#ifdef ANSI_C
(char *buffer, struct iovec *iov, int iovcnt);
#else
();
#endif /* ANSI_C */

extern void _vectorcollect
#ifdef ANSI_C
(char *buffer, struct iovec *iov, int iovcnt);
#else
();
#endif /* ANSI_C */

extern void _pfslib_awaitresult
#ifdef ANSI_C
(CLIENT *clnt);
#else
();
#endif /* ANSI_C */

extern void _pfslib_resettimeout
#ifdef ANSI_C
(CLIENT *clnt);
#else
();
#endif /* ANSI_C */


/* read data from a synchronous server
 * data is sent with the result of an RPC from the pfsd
 */
long _svc_ioop
#ifdef ANSI_C
(long ioID, char *buffer, CLIENT *clnt)
#else
(ioID,buffer,clnt)
long ioID;
char *buffer;
CLIENT *clnt;
#endif /* ANSI_C */
{
	ioopres  	*result;            /* result of RPC */
	ioopargs  arg;                /* argument of RPC */
  long iolen;
  
  arg.op    = _IDTE.op;
  arg.ioID  = _IDTE.svrioID;
  arg.fh    = _pfslib_ftbl[_IDTE.fd];

  switch (_IDTE.op)
  {
  case WRITE_OP:
    if ((arg.fh.mode == M_GLOBAL) && (arg.fh.which != 0))
    {
      arg.iolen = 0;
      arg.data.pfslib_data_len = 0;
    }
    else
    {
      arg.iolen = _IDTE.iolen;
      arg.data.pfslib_data_len = _IDTE.iolen;
      arg.data.pfslib_data_val = _IDTE.buffer;
    }
    break;
  case WRITEV_OP:
    if (((arg.fh.mode == M_GLOBAL) && (arg.fh.which != 0)) ||
        (_IDTE.iolen == 0))
    {
      arg.iolen = 0;
      arg.data.pfslib_data_len = 0;
      arg.data.pfslib_data_val = (char *)0;
    }
    else
    {
      arg.iolen = _IDTE.iolen;
      arg.data.pfslib_data_len = _IDTE.iolen;
      if ((arg.data.pfslib_data_val = malloc(_IDTE.iolen)) == (char *)0)
        return (-1);
      _vectorcollect(arg.data.pfslib_data_val,_IDTE.iov,_IDTE.iovcnt);
    }
    break;
  default:
    arg.iolen = _IDTE.iolen;
    arg.data.pfslib_data_len = 0;
    break;
  }
  
  if ((arg.fh.mode == M_SYNC) || (arg.fh.mode == M_GLOBAL))
    _pfslib_awaitresult(clnt);

  if ((result = pfsd_ioop_1(&arg, clnt)) == NULL )
  {
    clnt_perror(clnt, "pfsd_ioop_1()");
    return (-1);
  }

  _pfslib_resettimeout(clnt);
      
  ERR_RESULT(ioopres_u, xdr_ioopres);  

  switch (_IDTE.op)
  {
  case READ_OP:
    if (result->ioopres_u.res.data.pfslib_data_len !=
        result->ioopres_u.res.iolen)
    {
      fprintf(stderr,"PFSLib Internal error _svc_ioop()\n");
      exit (1);
    }
    memcpy(buffer, result->ioopres_u.res.data.pfslib_data_val,
           result->ioopres_u.res.iolen);
  
    iolen = result->ioopres_u.res.iolen;
    break;
  case READV_OP:
    if (result->ioopres_u.res.data.pfslib_data_len !=
        result->ioopres_u.res.iolen)
    {
      fprintf(stderr,"PFSLib Internal error _svc_ioop()\n");
      exit (1);
    }
    if (_IDTE.csync)
      _vectordistribute(result->ioopres_u.res.data.pfslib_data_val,
                        _IDTE.iov, _IDTE.iovcnt);
    else
      memcpy(buffer, result->ioopres_u.res.data.pfslib_data_val,
             result->ioopres_u.res.iolen);
  
    iolen = result->ioopres_u.res.iolen;
    break;
  case WRITE_OP:
    if ((arg.fh.mode == M_GLOBAL) && (arg.fh.which != 0))
      iolen = (long)_IDTE.iolen;
    else
      iolen = result->ioopres_u.res.iolen;
    break;
  case WRITEV_OP:
    if (arg.data.pfslib_data_val != (char *)0)
      free (arg.data.pfslib_data_val);

    if ((arg.fh.mode == M_GLOBAL) && (arg.fh.which != 0))
      iolen = (long)_IDTE.iolen;
    else
      iolen = result->ioopres_u.res.iolen;
    break;
  }
  
  xdr_free(xdr_ioopres, (char *)result);

  return (iolen);
}




