/******************************************************************************
 *
 *    clnt_ioop_iod.c,v : Input/Output from/to IO daemon
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : clnt_ioop_iod.c,v
 *  RCS Date     : 1995/11/29 14:18:53
 *  RCS Revision : 1.12
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef lint
static char rcs_id[] = "clnt_ioop_iod.c,v 1.12 1995/11/29 14:18:53 lamberts Rel";
#endif

#include <rpc/rpc.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/tcp.h>
#include <errno.h>
#include <stdlib.h>
#include <memory.h>
#include <stdio.h>
#include <unistd.h>

#include "iod.h"
#include "clnt_defines.h"
#include "clnt_macros.h"

extern ioIDtabel _pfslib_ioidtbl[];
extern CLIENT * _pfslib_clnt;
extern pfslib_fhdl * _pfslib_ftbl;

extern void _vectordistribute
#ifdef ANSI_C
(char *buffer, struct iovec *iov, int iovcnt);
#else
();
#endif /* ANSI_C */

extern void _vectorcollect
#ifdef ANSI_C
(char *buffer, struct iovec *iov, int iovcnt);
#else
();
#endif /* ANSI_C */

extern void _pfslib_awaitresult
#ifdef ANSI_C
(CLIENT *clnt);
#else
();
#endif /* ANSI_C */

extern void _pfslib_resettimeout
#ifdef ANSI_C
(CLIENT *clnt);
#else
();
#endif /* ANSI_C */


long _iod_ioop
#ifdef ANSI_C
(long ioID, char *buffer)
#else
(ioID,buffer)
long ioID;
char *buffer;
#endif /* ANSI_C */
{
  iod_ioopres *result;
  iod_ioopargs arg;
  unsigned int iolen;

  int sockp;
  struct sockaddr_in addr;

  struct hostent *hp;
  
  CLIENT *iodclnt;
  
  int sooptarg;
  
  int retry;

  memset(&addr, 0, sizeof(struct sockaddr_in));
  addr.sin_family = AF_INET;
  memcpy(&addr.sin_addr, &_IDTE.iod_addr.ipaddr, IPADDRLEN);
  addr.sin_port = htons(_IDTE.iod_addr.port);
  
  retry = -1;
  do
  {
    retry++;
    sockp = RPC_ANYSOCK;
    iodclnt = clnttcp_create(&addr, IOD, IOD_VERS, &sockp, 0, 0);
  }
  while ((retry < CONNECT_RETRIES) &&
         (iodclnt == NULL) && (errno == ETIMEDOUT));
      
  if (iodclnt == NULL)
  {
    clnt_pcreateerror("clnttcp_create()");
    return (-1);
  }
  
  /* Set REUSEADDR */
  sooptarg = 1;
  setsockopt(sockp,SOL_SOCKET,SO_REUSEADDR,(char *)&sooptarg,sizeof(sooptarg));
  /* TCP_NODELAY */
  sooptarg = 1;
  setsockopt(sockp,IPPROTO_TCP,TCP_NODELAY,(char *)&sooptarg,sizeof(sooptarg));

  _pfslib_resettimeout(iodclnt);

  iodclnt->cl_auth = _pfslib_clnt->cl_auth;

  arg.op    = _IDTE.op;
  arg.ioID  = _IDTE.svrioID;
  arg.fh    = _pfslib_ftbl[_IDTE.fd];

  switch (_IDTE.op)
  {
  case WRITE_OP:
    if ((arg.fh.mode == M_GLOBAL) && (arg.fh.which != 0))
    {
      arg.iolen = 0;
      arg.data.pfslib_data_len = 0;
    }
    else
    {
      arg.iolen = _IDTE.iolen;
      arg.data.pfslib_data_len = _IDTE.iolen;
      arg.data.pfslib_data_val = _IDTE.buffer;
    }
    break;
  case WRITEV_OP:
    if (((arg.fh.mode == M_GLOBAL) && (arg.fh.which != 0)) ||
        (_IDTE.iolen == 0))
    {
      arg.iolen = 0;
      arg.data.pfslib_data_len = 0;
      arg.data.pfslib_data_val = (char *)0;
    }
    else
    {
      arg.iolen = _IDTE.iolen;
      arg.data.pfslib_data_len = _IDTE.iolen;
      if ((arg.data.pfslib_data_val = malloc(_IDTE.iolen)) == (char *)0)
        return (-1);
      _vectorcollect(arg.data.pfslib_data_val,_IDTE.iov,_IDTE.iovcnt);
    }
    break;
  default:
    arg.iolen = _IDTE.iolen;
    arg.data.pfslib_data_len = 0;
    break;
  }
  
  if ((arg.fh.mode == M_SYNC) || (arg.fh.mode == M_GLOBAL))
    _pfslib_awaitresult(iodclnt);

  if ((result = iod_ioop_1(&arg, iodclnt)) == NULL )
  {
    clnt_perror(iodclnt, "iod_ioop_1()");
    return (-1);
  }

  _pfslib_resettimeout(iodclnt);
      
  ERR_RESULT(iod_ioopres_u, xdr_iod_ioopres);
  
  switch (_IDTE.op)
  {
  case READ_OP:
    if (result->iod_ioopres_u.res.data.pfslib_data_len !=
        result->iod_ioopres_u.res.iolen)
    {
      fprintf(stderr,"PFSLib Internal error ssync_ioop()\n");
      exit (1);
    }
    memcpy(buffer, result->iod_ioopres_u.res.data.pfslib_data_val,
           result->iod_ioopres_u.res.iolen);

    iolen = result->iod_ioopres_u.res.iolen;
    break;
  case READV_OP:
    if (result->iod_ioopres_u.res.data.pfslib_data_len !=
        result->iod_ioopres_u.res.iolen)
    {
      fprintf(stderr,"PFSLib Internal error ssync_ioop()\n");
      exit (1);
    }
    if (_IDTE.csync)
      _vectordistribute(result->iod_ioopres_u.res.data.pfslib_data_val,
                        _IDTE.iov, _IDTE.iovcnt);
    else
      memcpy(buffer, result->iod_ioopres_u.res.data.pfslib_data_val,
             result->iod_ioopres_u.res.iolen);

    iolen = result->iod_ioopres_u.res.iolen;
    break;
  case WRITE_OP:
    if ((arg.fh.mode == M_GLOBAL) && (arg.fh.which != 0))
      iolen = _IDTE.iolen;
    else
      iolen = result->iod_ioopres_u.res.iolen;
    break;
  case WRITEV_OP:
    if (arg.data.pfslib_data_val != (char *)0)
      free (arg.data.pfslib_data_val);

    if ((arg.fh.mode == M_GLOBAL) && (arg.fh.which != 0))
      iolen = _IDTE.iolen;
    else
      iolen = result->iod_ioopres_u.res.iolen;
    break;
  }

  xdr_free(xdr_iod_ioopres, (char *)result);

  clnt_destroy(iodclnt);
  close(sockp);

  return (iolen);
}

