/******************************************************************************
 *
 *    clnt_init.c,v : initialize PFSLib
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : clnt_init.c,v
 *  RCS Date     : 1995/11/29 14:16:43
 *  RCS Revision : 1.11
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef lint
static char rcs_id[] = "clnt_init.c,v 1.11 1995/11/29 14:16:43 lamberts Rel";
#endif


#include <rpc/rpc.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <netdb.h>
#include <netinet/tcp.h>
#include <signal.h>
#ifdef SUN4
#include <memory.h>
#else
#include <string.h>
#endif /* SUN4 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "pfsd.h"
#include "clnt_defines.h"
#include "clnt_macros.h"

extern int pfslib_close
#ifdef ANSI_C
(int filedes);
#else
();
#endif /* ANSI_C */

extern void _pfslib_resettimeout
#ifdef ANSI_C
(CLIENT *clnt);
#else
();
#endif /* ANSI_C */

#ifdef CHILDSIGNAL
extern void _chld_handler
#ifdef ANSI_C
(int sig);
#else
();
#endif /* ANSI_C */
#endif /* CHILDSIGNAL */

CLIENT *_pfslib_clnt;            /* RPC client */

int _pfslib_numclnts;           /* Total number of clients */
int _pfslib_mynumber;           /* Number of this client */
int _pfslib_maxfiles;           /* max number of files */
int _pfslib_clt_thr;            /* Client threshold */
int _pfslib_svr_thr;            /* Server threshold */
pfslib_ipaddr _pfslib_host_ipaddr; /* IP address of pfsd host */
char _pfslib_host[MAXNLEN];     /* Name of server host */

pid_t _pfslib_mypid;            /* pid of the client process
                                 * NOT its children */

pfslib_fhdl *_pfslib_ftbl;       /* File handle table */

ioIDtabel _pfslib_ioidtbl[MAXIOID]; /* io id table */

static void init_ioidtable
#ifdef ANSI_C
(void)
#else
()
#endif /* ANSI_C */
{
  int ioID;

  for (ioID=0;ioID<MAXIOID;ioID++)
  {
    _IDTE.state    = IDT_UNUSED;
    _IDTE.childpid = -1;
    _IDTE.shmid    = -1;
  }
}

/* ************************************************************************* */
/* if the client exits without regularly closing shared files, the pfsd will */
/* be informed to prevent filetable overflow                                 */
/* ************************************************************************* */

static void pfslib_exit
#ifdef ANSI_C
(void)
#else
()
#endif /* ANSI_C */
{
	int i;
  int ioID;
  struct shmid_ds shmds;

	/* try to close all open files at the pfsd */

	if ( _pfslib_mypid == getpid() )
	{
		for (i=0; i<_pfslib_maxfiles; i++ )
			if (_pfslib_ftbl[i].vfd != -1) 
				pfslib_close(i+VFDOFFSET);
	
		/* and destroy myself as a client */
		clnt_destroy(_pfslib_clnt);

    /* kill all children and close shmids*/
    for (ioID=0;ioID<MAXIOID;ioID++)
    {
      if (_IDTE.childpid != -1)
        kill(_IDTE.childpid,SIGKILL);
      if (_IDTE.shmid != -1)
        shmctl(_IDTE.shmid,IPC_RMID,&shmds);
    }
  }
}


CLIENT *pfslib_clnt_create
#ifdef ANSI_C
(void)
#else
()
#endif /* ANSI_C */
{
  CLIENT *clnt;

  struct hostent *hp;
  struct sockaddr_in addr;
  int sockp = RPC_ANYSOCK;

  int sooptarg;
  
  if ((hp = gethostbyname(_pfslib_host)) == (struct hostent *)0)
  {
    perror("gethostbyname()");
    exit (1);
  }

  memcpy(&_pfslib_host_ipaddr, hp->h_addr, IPADDRLEN);
  
  memset(&addr, 0, sizeof(struct sockaddr_in));
  addr.sin_family = AF_INET;
  memcpy(&addr.sin_addr,_pfslib_host_ipaddr,IPADDRLEN);
  addr.sin_port = htons(0);

	if ((clnt = clnttcp_create(&addr, PFSD, PFSD_VERS,
                             &sockp, RPC_IOD_BUFSZ, RPC_IOD_BUFSZ)) == NULL)
	{
		clnt_pcreateerror("clnttcp_create()");
		exit(1);
	}

  /* Set REUSEADDR */
  sooptarg = 1;
  setsockopt(sockp,SOL_SOCKET,SO_REUSEADDR,(char *)&sooptarg,sizeof(sooptarg));
  /* TCP_NODELAY */
  sooptarg = 1;
  setsockopt(sockp,IPPROTO_TCP,TCP_NODELAY,(char *)&sooptarg,sizeof(sooptarg));

	auth_destroy(clnt->cl_auth);
	clnt->cl_auth = authunix_create_default();

  _pfslib_resettimeout(clnt);

  return(clnt);
}



/* ************************************************************************* */
/* this has to be called before any IO takes place                           */
/* arguments:                                                                */
/*      host:        hostname of the pfsd                                    */
/*      numofclnts:  number of clients attaching shared files                */
/*      whichnum:    my number in the parallel application                   */
/*      th_ios:      threshold to fork an IO-Server                          */
/*      th_ioc:      in case of ixxx() calls threshold to fork an IO-Client  */
/* nb: th_ios and th_ioc mainly used for testing                             */
/* ************************************************************************* */

void _pfslib_init
#ifdef ANSI_C
(char *host, int numofclnts, int whichnum, int svr_thr, int clt_thr)
#else
(host, numofclnts, whichnum, svr_thr, clt_thr)
char *host;
int numofclnts;
int whichnum;
int svr_thr;
int clt_thr;
#endif /* ANSI_C */
{
	int    *numfd;
	int 	 i;
	char   numfarg;

#ifdef BSD_SIG
  struct sigvec vec;
#else
  struct sigaction  sigact;
#endif

  if (svr_thr < 0)
    svr_thr = S_DFLTIOLEN;
  
  if (clt_thr < 0)
    clt_thr = C_DFLTIOLEN;
  
	/*
	 * set or change the number of clients
	 * set or change my client number
	 */

	_pfslib_numclnts =  numofclnts;
	_pfslib_mynumber =  whichnum;
	_pfslib_mypid    =  getpid();

  strcpy(_pfslib_host,host);

	/* set up as PFSLib client */
  _pfslib_clnt = pfslib_clnt_create();
  
	/* homany files are possible? */

	if ((numfd = pfsd_numfiles_1(&numfarg,_pfslib_clnt)) == NULL)
  {
		clnt_perror(_pfslib_clnt, "pfslib_init(): pfsd_numfiles_1()");
		exit(1);
	}

	_pfslib_maxfiles = *numfd;

  /* No xdr_free necessary */

	/* allocate memory for file handle table */

	if ((_pfslib_ftbl=(struct pfslib_fhdl *)malloc(sizeof(struct pfslib_fhdl) *
                                                _pfslib_maxfiles))
      == NULL )
	{
		perror("_pfslib_init: malloc()");
		exit (1);
	}

  for (i = 0; i < _pfslib_maxfiles; i++ )
  {
		_pfslib_ftbl[i].vfd  = -1;
  }
  
	/*
	 * set up exit-handler
	 */

#ifdef SUN4
	on_exit(pfslib_exit);
#else
  atexit(pfslib_exit);
#endif

  /* Initialize ioidtabke */
  init_ioidtable();
  
	/*
	 * set thresholds for asynchronous IO
	 */

  _pfslib_clt_thr = clt_thr;    /* fork() an IO-Client with this threshold */
	_pfslib_svr_thr = svr_thr;    /* fork() an IO-Server with this threshold */

#ifdef CHILDSIGNAL
#ifdef BSD_SIG
  vec.sv_handler = _chld_handler;
  vec.sv_mask = sigmask(SIGCHLD);
  vec.sv_flags = 0;
  if (sigvec(SIGCHLD, &vec, (struct sigvec *)0) != 0)
  {
    perror("sigvec()");
    exit(1);
  }
#else  /* ! BSD_SIG */
  sigact.sa_handler = _chld_handler;
  sigact.sa_flags = 0;
  if ((sigemptyset(&sigact.sa_mask) != 0) ||
      (sigaddset(&sigact.sa_mask,SIGCHLD) != 0) ||
      (sigaction(SIGCHLD, &sigact, (struct sigaction *)0) != 0))
  {
    perror("sigaction()");
    exit(1);
  }
#endif /* BSD_SIG */
#endif /* CHILDSIGNAL */

  return;
}

void pfslib_init
#ifdef ANSI_C
(char *host, int numofclnts, int whichnum)
#else
(host, numofclnts, whichnum)
char *host;
int numofclnts;
int whichnum;
#endif /* ANSI_C */
{
	(void) _pfslib_init(host, numofclnts, whichnum, -1, -1);
}
