/******************************************************************************
 *
 *    clnt_getioid.c,v : io id request
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : clnt_getioid.c,v
 *  RCS Date     : 1995/11/29 14:13:43
 *  RCS Revision : 1.6
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef lint
static char rcs_id[] = "clnt_getioid.c,v 1.6 1995/11/29 14:13:43 lamberts Rel";
#endif


#include <rpc/rpc.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "pfsd.h"
#include "clnt_defines.h"
#include "clnt_macros.h"
#include "pfslib_errno.h"

extern pfslib_fhdl * _pfslib_ftbl;
extern CLIENT * _pfslib_clnt;
extern int _pfslib_svr_thr;
extern ioIDtabel _pfslib_ioidtbl[];

int _getioID
#ifdef ANSI_C
(int fd, int op, unsigned int iolen)
#else
(fd, op, iolen)
int fd;
int op;
unsigned int iolen;
#endif /* ANSI_C */
{
	getioidres *result;
	getioidargs args;             /* passed with every call */

	int        ioID;

  /* Get a free element of the ioiotable */
  for (ioID=0;ioID<MAXIOID;ioID++)
  {
    if (_IDTE.state == IDT_UNUSED)
      break;
  }
  
  if (ioID >= MAXIOID)
  {
    errno = EPFSLMREQUEST;
    return (-1);
  }

  _IDTE.state    = IDT_USED;
  _IDTE.fd       = fd;
  _IDTE.op       = op;
  _IDTE.iolen    = iolen;
  if (iolen < _pfslib_svr_thr)
    _IDTE.ssync  = TRUE;
  else
    _IDTE.ssync  = FALSE;
  _IDTE.buffer   = (char *)0;
  _IDTE.childpid = -1;
  _IDTE.shmid    = -1;
  
  /* Get an ioID from the server
   * this call is never synchronising */

  args.fh    = _pfslib_ftbl[fd];
  args.op    = op;
  args.ssync = _IDTE.ssync;
  args.iolen = iolen;
  
  if ((result = pfsd_getioid_1(&args, _pfslib_clnt)) == NULL)
  {
    clnt_perror(_pfslib_clnt, "pfsd_getioid_1() call failed:");
    exit (1);
  }

  if (result->stat == RPC_ERR)
  {
    /* Free ioidtable element */
    _IDTE.state = IDT_UNUSED;
  }
  
  ERR_RESULT(getioidres_u, xdr_getioidres);
  
  _IDTE.svrioID = result->getioidres_u.res.ioID;
  
  if (!_IDTE.ssync)
  {
    strcpy(_IDTE.iod_addr.hname,result->getioidres_u.res.iod_addr.hname);
    memcpy(&_IDTE.iod_addr.ipaddr,
           &result->getioidres_u.res.iod_addr.ipaddr,
           IPADDRLEN);
    _IDTE.iod_addr.port = result->getioidres_u.res.iod_addr.port;
  }
  
  xdr_free(xdr_getioidres, (char *)result);

	return (ioID);
}

