/* ************************************************************************* *
 *                                                                           *
 *    pfsd_unlink.c,v
 *    pfsd procedures to remove a PFSLib file
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : pfsd_unlink.c,v
 *  RCS Date     : 1996/12/27 15:47:21
 *  RCS Revision : 1.3
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts, Christian R"oder                               *
 *                                                                           *
 * ************************************************************************* */
#ifndef lint
static void *rcs_id = "pfsd_unlink.c,v 1.3 1996/12/27 15:47:21 lamberts V2_0_B";
#endif

/* ************************************************************************* *
 * Include files                                                             *
 * ************************************************************************* */

#include <rpc/rpc.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>

#include "pfsd.h"
#include "pfsd_macros.h"
#include "pfsd_defines.h"
#include "pfslib_errno.h"

/* ************************************************************************* *
 * External declarations                                                     *
 * ************************************************************************* */

extern filetabel *_cftbl;

#ifdef ANSI_C
#define _PH(a) a
#else  /* ANSI_C */
#define _PH(a) ()
#endif /* ANSI_C */

extern int  _dist_setunlink _PH((int _ftix));
extern int  _dist_init      _PH((int _ftix));
extern void _dist_del       _PH((int _ftix));

#undef _PH

/* ************************************************************************* *
 * Procedures                                                                *
 * ************************************************************************* */

/* ************************************************************************* *
 * Unlink a distributed file                                                 *
 * ************************************************************************* */
errorres *pfsd_unlink_1
#ifdef ANSI_C
(resetargs *argp, struct svc_req *rqstp)
#else  /* ANSI_C */
(argp, rqstp)
resetargs *argp;
struct svc_req *rqstp;
#endif /* ANSI_C */
{
  static errorres result;
  int _ftix;

  for (_ftix = 0; _ftix < MAXNUMFILES; _ftix++)
    if (_CFTE.actual == 0) break;
  
  if (_ftix >= MAXNUMFILES)
  {
    ERR_MACRO(errorres_u, EPFSLMFILE);
    return (&result);
  }
  
  strcpy(_CFTE.filename,argp->fname);
  
  if (_dist_init(_ftix) < 0)
  {
    if (errno == ENOENT)
      result.stat = RPC_OK;
    else
    {
      ERR_MACRO(errorres_u, errno);
    }
    return (&result);
  }
  
  _CFTE.oflags = 0;
  
  if (_dist_setunlink(_ftix) < 0)
  {
    ERR_MACRO(errorres_u, errno);
    return (&result);
  }
  
  _dist_del(_ftix);

  result.stat = RPC_OK;
  
  return (&result);
}
