/* ************************************************************************* *
 *                                                                           *
 *    pfsd_timing.c,v
 *    pfsd procedures to time internal PFSLib functions
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : pfsd_timing.c,v
 *  RCS Date     : 1996/10/18 14:44:37
 *  RCS Revision : 1.2
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts,                                                *
 *                                                                           *
 * ************************************************************************* */
#ifndef lint
static void *rcs_id = "pfsd_timing.c,v 1.2 1996/10/18 14:44:37 lamberts V2_0_B";
#endif

#ifdef TIMING

/* ************************************************************************* *
 * Include files                                                             *
 * ************************************************************************* */

#include <stdio.h>
#include <sys/time.h>
#include <stdlib.h>

/* ************************************************************************* *
 * Global variables                                                          *
 * ************************************************************************* */

#define DFN_TIMER(a) \
double _tm_sum_ ## a   = 0.0;\
double _tm_sqsum_ ## a = 0.0;\
double _tm_max_ ## a   = 0.0;\
double _tm_min_ ## a   = 0.0;\
int    _tm_cnt_ ## a   = 0;\
double _tm_start_ ## a = 0.0;\
double _tm_time_ ## a  = 0.0;

DFN_TIMER(_dist_get_list)

/* ************************************************************************* *
 * Procedures                                                                *
 * ************************************************************************* */

/* ************************************************************************* *
 * Get time of day in double format                                          *
 * ************************************************************************* */
double dclock
#ifdef ANSI_C
()
#else  /* ANSI_C */
()
#endif /* ANSI_C */
{
  struct timeval t;
  struct timezone tz;
  
  if (gettimeofday(&t,&tz) < 0)
    return(-1.0);
  
  return ((double)((double)t.tv_sec + ((double)t.tv_usec*(double)0.000001)));

}

#define RST_TIMER(a) \
_tm_sum_ ## a   = 0.0;\
_tm_sqsum_ ## a = 0.0;\
_tm_max_ ## a   = 0.0;\
_tm_min_ ## a   = 0.0;\
_tm_cnt_ ## a   = 0;\
_tm_start_ ## a = 0.0;\
_tm_time_ ## a  = 0.0

/* ************************************************************************* *
 * Reset timers                                                              *
 * ************************************************************************* */
void reset_timing(void)
{
  RST_TIMER(_dist_get_list);

  return;
}


/* ************************************************************************* *
 * Print timing values and reset timers                                      *
 * ************************************************************************* */
void print_timing(void)
{
  printf("Avg Time in _dist_get_list : %9.4f\n",
         _tm_sum__dist_get_list/(double)_tm_cnt__dist_get_list);
  printf("Max Time in _dist_get_list : %9.4f\n",
         _tm_max__dist_get_list);
  printf("Min Time in _dist_get_list : %9.4f\n",
         _tm_min__dist_get_list);

  reset_timing();

  return;
}

#endif /* TIMING */
