/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#include <stdio.h>
#include <rpc/rpc.h>
#include "pfsd.h"
/* ************************************************************************* *
 *                                                                           *
 *    pfsd.x,v
 *    RPC description file for the pfsd program
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : pfsd.x,v
 *  RCS Date     : 1996/12/27 15:46:56
 *  RCS Revision : 1.3
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts, Christian R"oder                               *
 *                                                                           *
 * ************************************************************************* */
#ifndef lint
#ifndef __rcs_id_pfsd_x__
#define __rcs_id_pfsd_x__
static void *rcs_id_pfsd_x = "pfsd.x,v 1.3 1996/12/27 15:46:56 lamberts V2_0_B";
#endif
#endif


#ifndef lint
#ifndef __rcs_id_global_rcp_h__
#define  __rcs_id_global_rcp_h__
static void *rcs_id_global_rpc_h = "global_rpc.h,v 1.1 1996/04/24 14:28:00 lamberts V2_0_B";
#endif
#endif


#ifdef ANSI_C
#define _PH(a) a
#else  /* ANSI_C */
#define _PH(a) ()
#endif /* ANSI_C */

extern bool_t pfslib_auth_ok _PH((struct svc_req *rqstp, SVCXPRT *transp));
extern void   _pfsd_init     _PH((int argc, char **argv));
static void   svc_main       _PH((int argc, char **argv));

#undef _PH

int main
#ifdef ANSI_C
(int argc, char **argv)
#else  /* ANSI_C */
(argc, argv)
int argc;
char **argv;
#endif /* ANSI_C */
{
  char hostname[MAXNLEN];
  
  if (gethostname(hostname,MAXNLEN) < 0)
  {
    perror("pfsd: main(): gethostname()");
    exit(1);
  }
  
  if (callrpc(hostname, PFSD, PFSD_VERS, NULLPROC,
              xdr_void, (char *)NULL, xdr_void, (char *)0) == RPC_SUCCESS)
  {
    fprintf(stderr,"%s: main(): There is already a pfsd registered on this machine\n",
            argv[0]);
    fprintf(stderr,"%s: main(): Exiting\n",argv[0]);
    exit(1);
  }

  svc_main(argc,argv);
  return (1);
}


#ifdef ANSI_C
#define main() static void svc_main(int argc, char **argv)
#else
#define main() static void svc_main(argc, argv)\
int argc;\
char **argv;
#endif


static int pfsd_svc_run
#ifdef ANSI_C
(int argc, char **argv)
#else  /* ANSI_C */
(argc, argv)
int argc;
char **argv;
#endif /* ANSI_C */
{
  _pfsd_init(argc, argv);
  svc_run();
  /* Should never return */
  exit(1);
}


#define svc_run() pfsd_svc_run(argc, argv)  


static void pfsd_1();

main()
{
	register SVCXPRT *transp;

	(void) pmap_unset(PFSD, PFSD_VERS);

	transp = svcudp_create(RPC_ANYSOCK);
	if (transp == NULL) {
		fprintf(stderr, "cannot create udp service.");
		exit(1);
	}
	if (!svc_register(transp, PFSD, PFSD_VERS, pfsd_1, IPPROTO_UDP)) {
		fprintf(stderr, "unable to register (PFSD, PFSD_VERS, udp).");
		exit(1);
	}

	transp = svctcp_create(RPC_ANYSOCK, 0, 0);
	if (transp == NULL) {
		fprintf(stderr, "cannot create tcp service.");
		exit(1);
	}
	if (!svc_register(transp, PFSD, PFSD_VERS, pfsd_1, IPPROTO_TCP)) {
		fprintf(stderr, "unable to register (PFSD, PFSD_VERS, tcp).");
		exit(1);
	}

	svc_run();
	fprintf(stderr, "svc_run returned");
	exit(1);
	/* NOTREACHED */
}

static void
pfsd_1(rqstp, transp)
	struct svc_req *rqstp;
	register SVCXPRT *transp;
{
	union {
		openargs pfsd_open_1_arg;
		setiomodeargs pfsd_setiomode_1_arg;
		pfslib_fhdl pfsd_getiomode_1_arg;
		getioidargs pfsd_getioid_1_arg;
		ioidstatargs pfsd_iodone_1_arg;
		ioidstatargs pfsd_iowait_1_arg;
		fpmoveargs pfsd_lsize_1_arg;
		pfslib_fhdl pfsd_iseof_1_arg;
		fpmoveargs pfsd_lseek_1_arg;
		pfslib_fhdl pfsd_getfattr_1_arg;
		pfslib_fhdl pfsd_close_1_arg;
		resetargs pfsd_reset_1_arg;
		pfslib_fhdl pfsd_cltexit_1_arg;
		prtstatargs pfsd_prtstat_1_arg;
		ioidstatargs pfsd_getdist_1_arg;
		ioopdoneargs pfsd_ioopdone_1_arg;
		resetargs pfsd_unlink_1_arg;
	} argument;
	char *result;
	bool_t (*xdr_argument)(), (*xdr_result)();
	char *(*local)();


/* BEGIN PATCH done by Makefile */
if (!pfslib_auth_ok(rqstp,transp)) return;
/* END PATCH */

	switch (rqstp->rq_proc) {
	case NULLPROC:
		(void) svc_sendreply(transp, xdr_void, (char *)NULL);
		return;

	case PFSD_OPEN:
		xdr_argument = xdr_openargs;
		xdr_result = xdr_openres;
		local = (char *(*)()) pfsd_open_1;
		break;

	case PFSD_SETIOMODE:
		xdr_argument = xdr_setiomodeargs;
		xdr_result = xdr_errorres;
		local = (char *(*)()) pfsd_setiomode_1;
		break;

	case PFSD_GETIOMODE:
		xdr_argument = xdr_pfslib_fhdl;
		xdr_result = xdr_iomoderes;
		local = (char *(*)()) pfsd_getiomode_1;
		break;

	case PFSD_GETIOID:
		xdr_argument = xdr_getioidargs;
		xdr_result = xdr_getioidres;
		local = (char *(*)()) pfsd_getioid_1;
		break;

	case PFSD_IODONE:
		xdr_argument = xdr_ioidstatargs;
		xdr_result = xdr_ioopres;
		local = (char *(*)()) pfsd_iodone_1;
		break;

	case PFSD_IOWAIT:
		xdr_argument = xdr_ioidstatargs;
		xdr_result = xdr_ioopres;
		local = (char *(*)()) pfsd_iowait_1;
		break;

	case PFSD_LSIZE:
		xdr_argument = xdr_fpmoveargs;
		xdr_result = xdr_lsizeres;
		local = (char *(*)()) pfsd_lsize_1;
		break;

	case PFSD_ISEOF:
		xdr_argument = xdr_pfslib_fhdl;
		xdr_result = xdr_iseofres;
		local = (char *(*)()) pfsd_iseof_1;
		break;

	case PFSD_LSEEK:
		xdr_argument = xdr_fpmoveargs;
		xdr_result = xdr_lseekres;
		local = (char *(*)()) pfsd_lseek_1;
		break;

	case PFSD_GETFATTR:
		xdr_argument = xdr_pfslib_fhdl;
		xdr_result = xdr_fattrres;
		local = (char *(*)()) pfsd_getfattr_1;
		break;

	case PFSD_CLOSE:
		xdr_argument = xdr_pfslib_fhdl;
		xdr_result = xdr_errorres;
		local = (char *(*)()) pfsd_close_1;
		break;

	case PFSD_NUMCLNTS:
		xdr_argument = xdr_void;
		xdr_result = xdr_int;
		local = (char *(*)()) pfsd_numclnts_1;
		break;

	case PFSD_NUMFILES:
		xdr_argument = xdr_void;
		xdr_result = xdr_int;
		local = (char *(*)()) pfsd_numfiles_1;
		break;

	case PFSD_RESET:
		xdr_argument = xdr_resetargs;
		xdr_result = xdr_resetres;
		local = (char *(*)()) pfsd_reset_1;
		break;

	case PFSD_CLTEXIT:
		xdr_argument = xdr_pfslib_fhdl;
		xdr_result = xdr_void;
		local = (char *(*)()) pfsd_cltexit_1;
		break;

	case PFSD_PRTSTAT:
		xdr_argument = xdr_prtstatargs;
		xdr_result = xdr_void;
		local = (char *(*)()) pfsd_prtstat_1;
		break;

	case PFSD_EXIT:
		xdr_argument = xdr_void;
		xdr_result = xdr_void;
		local = (char *(*)()) pfsd_exit_1;
		break;

	case PFSD_GETDIST:
		xdr_argument = xdr_ioidstatargs;
		xdr_result = xdr_getdistres;
		local = (char *(*)()) pfsd_getdist_1;
		break;

	case PFSD_IOOPDONE:
		xdr_argument = xdr_ioopdoneargs;
		xdr_result = xdr_errorres;
		local = (char *(*)()) pfsd_ioopdone_1;
		break;

	case PFSD_UNLINK:
		xdr_argument = xdr_resetargs;
		xdr_result = xdr_errorres;
		local = (char *(*)()) pfsd_unlink_1;
		break;

	default:
		svcerr_noproc(transp);
		return;
	}
	bzero((char *)&argument, sizeof(argument));
	if (!svc_getargs(transp, xdr_argument, &argument)) {
		svcerr_decode(transp);
		return;
	}
	result = (*local)(&argument, rqstp);

/* BEGIN PATCH done by Makefile */
/* Send reply only if resul != NULL
* otherwise reply has to be delayed and sent by _do_op()
*/
if (result != NULL) {
if (!svc_sendreply(transp, xdr_result, result)) {
svcerr_systemerr(transp); }}
/* END PATCH */

	if (!svc_freeargs(transp, xdr_argument, &argument)) {
		fprintf(stderr, "unable to free arguments");
		exit(1);
	}
	return;
}
