/* ************************************************************************* *
 *                                                                           *
 *    pfsd_setiom.c,v
 *    pfsd procedures to set the IO mode of a PFSLib file
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : pfsd_setiom.c,v
 *  RCS Date     : 1996/05/29 15:37:03
 *  RCS Revision : 1.2
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts, Christian R"oder                               *
 *                                                                           *
 * ************************************************************************* */
#ifndef lint
static void *rcs_id = "pfsd_setiom.c,v 1.2 1996/05/29 15:37:03 lamberts V2_0_B";
#endif

/* ************************************************************************* *
 * Include files                                                             *
 * ************************************************************************* */

#include <rpc/rpc.h>
#include <errno.h>
#include <stdio.h>

#include "pfsd.h"
#include "pfsd_defines.h"
#include "pfsd_macros.h"
#include "pfslib_errno.h"

/* ************************************************************************* *
 * External declarations                                                     *
 * ************************************************************************* */

extern filetabel *_cftbl;

#ifdef ANSI_C
#define _PH(a) a
#else  /* ANSI_C */
#define _PH(a) ()
#endif /* ANSI_C */

extern int _checkfh _PH((pfslib_fhdl fh, struct svc_req *rqstp));

#undef _PH

/* ************************************************************************* *
 * Procedures                                                                *
 * ************************************************************************* */

/* ************************************************************************* *
 * Set the IO mode                                                           *
 * ************************************************************************* */
errorres *pfsd_setiomode_1
#ifdef ANSI_C
(setiomodeargs *argp, struct svc_req *rqstp)
#else  /* ANSI_C */
(argp, rqstp)
setiomodeargs *argp;
struct svc_req *rqstp;
#endif /* ANSI_C */
{

  static errorres  result;    /* cached result of this function */

  int _ftix = argp->fh.vfd;     /* File table index */
  int _ctix = argp->fh.which;   /* Client table index */
  
  int _clc;                     /* counter for loop over clienttable */
  int _cid;                     /* counter for loop over ioID table */
  
  off_t newpos;                 /* offset in file for this client */
  off_t newendpos;
  
  bool_t all_done;
  bool_t syncok;
  int    syncerr;

  /* check the pfslib_fhdl */
  if (_checkfh(argp->fh,rqstp) < 0 )
  {
    ERR_MACRO(errorres_u, errno);
    return (&result);
  }

  if ((argp->mode != M_UNIX) &&
      (argp->mode != M_LOG) &&
      (argp->mode != M_SYNC) &&
      (argp->mode != M_RECORD) &&
      (argp->mode != M_GLOBAL))
  {
    ERR_MACRO(errorres_u, EPFSLINVAL);
    return (&result);
  }
    
  /*
   * its an synchronising call anyway, so
   * in any case collect the transport handle
   */

  /* Check for pending io operations
   * It is necessary that the ioIDs for a synchronizing operation
   * are the same for all processes. Hence, in PFSLib it is not allowed
   * that there are pending asynchronous operations. */

  switch (_CFTE.sync)
  {
  case PFSD_SYNC_NONE:           /* first of global operation */
    /* ********************************************************************* *
     * Initialize a synchorizing operation                                   *
     * ********************************************************************* */
  
    for (_clc = 0; _clc < _CFTE.how_many; _clc++)
    {
      _CNCL.syncdone = FALSE;
      _CNCL.syncok = TRUE;
      _CNCL.syncerr = 0;
    }

    _CFTE.sync     = PFSD_SYNC_SETIOMODE;
    
    _CFTE.rqmode = argp->mode;
    
  case PFSD_SYNC_SETIOMODE:
    _CLNT.syncdone = TRUE;
    _CLNT.transp = rqstp->rq_xprt;
    
    if (_CFTE.rqmode != argp->mode) /* Check new iomode */
    {
      _CLNT.syncok = FALSE;
      _CLNT.syncerr = EPFSLMIXIO;
    }
    
    all_done = TRUE;
    syncok = TRUE;
    for (_clc = 0; _clc < _CFTE.how_many; _clc++)
    {
      if (!_CNCL.syncdone)
      {
        all_done = FALSE;
        break;
      }
      else if (!_CNCL.syncok)
      {                   /* There was an error */
        syncok  = FALSE;
        syncerr = _CNCL.syncerr;
      }
    }
    if (all_done)
    {
      if (syncok)
      {
        /* Check file positions */
        switch (_CFTE.mode)
        {
        case M_UNIX:
          newpos = _CLNT.foffs;
          newendpos = _CFTE.endoffs;
          for (_clc = 0; _clc < _CFTE.how_many; _clc++)
          {
            if (_CNCL.foffs != newpos)
            {
              syncok = FALSE;
              syncerr = EPFSLMIXIO;
              break;
            }
          }            
          break;
        case M_RECORD:
          newpos = _CLNT.foffs;
          newendpos = _CFTE.endoffs;
          for (_clc = 0; _clc < _CFTE.how_many; _clc++)
          {
            if ((_CNCL.foffs != newpos) || (_CNCL.endoffs != newendpos))
            {
              syncok = FALSE;
              syncerr = EPFSLMIXIO;
              break;
            }
          }            
          break;
        case M_LOG:
        case M_SYNC:
        case M_GLOBAL:
          newpos = _CFTE.shoffs;
          newendpos = _CFTE.endoffs;
          break;
        default:
          /* LAMBO Fehler */
          break;
        }
      }
      
      if (syncok)
      {
        _CFTE.mode = _CFTE.rqmode; /* Set mode */

        /* Set sequence number of ioIDs to 0 */
        for(_clc = 0; _clc < _CFTE.how_many; _clc++)
        {
          _CNCL.ioseq = 0;
          /* Mark ioID which are not freed */
          for (_cid = 0; _cid < MAXIOID; _cid++)
          {
            if (_CNID.state != ID_UNUSED)
              _CNID.oldmode = TRUE;
          }
        }

        /* Set new file position */
        switch (_CFTE.mode)
        {
        case M_UNIX:            /* independent file positions */
          for (_clc = 0; _clc < _CFTE.how_many; _clc++)
            _CNCL.foffs = newpos;
          _CFTE.endoffs = newendpos;
          break;
        case M_RECORD:
          for (_clc = 0; _clc < _CFTE.how_many; _clc++)
          {
            _CNCL.foffs = newpos;
            _CNCL.endoffs = newendpos;
          }
          _CFTE.endoffs = newendpos;
          break;
        case M_LOG:             /* shared file position */
        case M_SYNC:
        case M_GLOBAL:
          _CFTE.shoffs = newpos;
          _CFTE.endoffs = newendpos;
          break;
        default:
          /* LAMBO Fehler */
          break;
        }
        
        result.stat = RPC_OK;
      }
      else
      {
        ERR_MACRO(errorres_u, syncerr);
      }          

      /* Send reply */
      for (_clc=0; _clc < _CFTE.how_many; _clc++)
      {
        if (!svc_sendreply(_CNCL.transp, xdr_errorres, (char *)&result))
        {
          svcerr_systemerr(_CNCL.transp);
        }
      }
      _CFTE.sync = PFSD_SYNC_NONE;
    }
    return ((errorres *)0); /* Delay reply or already sent */

  default:
    fprintf(stderr,"pfsd: pfsd_setiomode_1(): MISMATCHED SYNCHRONISING OPERATIONS");
    ERR_MACRO(errorres_u, EPFSLMIXIO);
  }
      
  return(&result);
}
