/* ************************************************************************* *
 *                                                                           *
 *    pfsd_reset.c,v
 *    pfsd procedures to reset the pfsd process
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : pfsd_reset.c,v
 *  RCS Date     : 1996/12/27 15:47:20
 *  RCS Revision : 1.4
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts, Christian R"oder                               *
 *                                                                           *
 * ************************************************************************* */
#ifndef lint
static void *rcs_id = "pfsd_reset.c,v 1.4 1996/12/27 15:47:20 lamberts V2_0_B";
#endif

/* ************************************************************************* *
 * Include files                                                             *
 * ************************************************************************* */

#include <rpc/rpc.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <stdlib.h>

#include "pfsd.h"
#include "pfsd_defines.h"
#include "pfsd_macros.h"

/* ************************************************************************* *
 * External declarations                                                     *
 * ************************************************************************* */

extern filetabel *_cftbl;

#ifdef ANSI_C
#define _PH(a) a
#else  /* ANSI_C */
#define _PH(a) ()
#endif /* ANSI_C */

extern int _dist_del   _PH((int _ftix));

#undef _PH

/* ************************************************************************* *
 * Procedures                                                                *
 * ************************************************************************* */

/* ************************************************************************* *
 * Reset the file table                                                      *
 * ************************************************************************* */
resetres *pfsd_reset_1
#ifdef ANSI_C
(resetargs *argp, struct svc_req *rqstp)
#else  /* ANSI_C */
(argp, rqstp)
resetargs *argp;
struct svc_req *rqstp;
#endif /* ANSI_C */
{

  static resetres  result;       /* reply to client */
  int    _ftix;                 /* File table index */

  struct authunix_parms *unix_cred;
  uid_t  uid;
  gid_t  gid;

  /*
  xdr_free(xdr_resetres, (char *)&result);
  */

  switch (rqstp->rq_cred.oa_flavor)
  {
  case AUTH_UNIX:
    unix_cred = (struct authunix_parms *) rqstp->rq_clntcred;
    uid = unix_cred->aup_uid;
    gid = unix_cred->aup_gid;
    break;
  default:
    break;
  }


  result.stat = RPC_OK;
  result.resetres_u.count = 0;

  for (_ftix=0; _ftix<MAXNUMFILES; _ftix++)
  {

    /* 
     * find the filename in the filetable
     */

    if ((_CFTE.actual > 0) &&
        ((strlen(argp->fname) == 0) ||
         (strcmp(_CFTE.filename, argp->fname) == 0)) &&
        (_CFTE.uid == uid) &&
        (_CFTE.gid == gid))
    {

      /*
       * don't care of pending replies, just do it
       * and reset the file table
       */

      (void) _dist_del(_ftix);
      free(_CFTE.cltab);
      _CFTE.cltab = (CltTabEl *)0;
      _CFTE.actual = 0;

      result.resetres_u.count++;
    }
  }
  
  return(&result);
}
