/* ************************************************************************* *
 *                                                                           *
 *    pfsd_print.c,v
 *    pfsd procedures to print status information
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : pfsd_print.c,v
 *  RCS Date     : 1996/12/27 15:47:18
 *  RCS Revision : 1.3
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts, Christian R"oder                               *
 *                                                                           *
 * ************************************************************************* */
#ifndef lint
static void *rcs_id = "pfsd_print.c,v 1.3 1996/12/27 15:47:18 lamberts V2_0_B";
#endif

/* ************************************************************************* *
 * Include files                                                             *
 * ************************************************************************* */

#include <rpc/rpc.h>
#include <stdio.h>

#include "pfsd.h"
#include "pfsd_defines.h"
#include "pfsd_macros.h"

/* ************************************************************************* *
 * External declarations                                                     *
 * ************************************************************************* */

extern filetabel *_cftbl;

#ifdef ANSI_C
#define _PH(a) a
#else  /* ANSI_C */
#define _PH(a) ()
#endif /* ANSI_C */

extern void _iod_prtlist _PH((void));
extern void _dist_prt    _PH((int _ftix));

#undef _PH

#ifdef TIMING
extern void print_timing(void);
#endif /* TIMING */
/* ************************************************************************* *
 * Procedures                                                                *
 * ************************************************************************* */

/* ************************************************************************* *
 * Print id table element                                                    *
 * ************************************************************************* */
void prt_idtabelem
#ifdef ANSI_C
(int _ftix, int _ctix, int _ioID)
#else  /* ANSI_C */
(_ftix, _ctix, _ioID)
int _ftix;
int _ctix;
int _ioID;
#endif /* ANSI_C */
{

  printf("FILETABLE ELEMENT %d CLIENTTABLE ELEMENT %d IDTABLE ELEMENT %d\n",
         _ftix,_ctix,_ioID);

  switch (_IOID.state)
  {
  case ID_UNUSED:
    printf("\tstate\t\t: ID_UNUSED\n");
    break;
  case ID_ALLOC:
    printf("\tstate\t\t: ID_ALLOC\n");
    break;
  case ID_OFSSET:
    printf("\tstate\t\t: ID_OFSSET\n");
    break;
  case ID_DISTPEND:
    printf("\tstate\t\t: ID_DISTPEND\n");
    break;
  case ID_DISTDONE:
    printf("\tstate\t\t: ID_DISTDONE\n");
    break;
  case ID_DONE:
    printf("\tstate\t\t: ID_DONE\n");
    break;
  }
  printf("\tioseq\t\t: %lu\n",_IOID.ioseq);
  switch(_IOID.mode)
  {
  case M_UNIX:
    printf("\tmode\t\t: M_UNIX\n");
    break;
  case M_LOG:
    printf("\tmode\t\t: M_LOG\n");
    break;
  case M_RECORD:
    printf("\tmode\t\t: M_RECORD\n");
    break;
  case M_SYNC:
    printf("\tmode\t\t: M_SYNC\n");
    break;
  case M_GLOBAL:
    printf("\tmode\t\t: M_GLOBAL\n");
    break;
  default:
    printf("\tmode\t\t: UNKOWN MODE\n");
    break;
  }
  if (_IOID.oldmode)
    printf("\toldmode\t\t: TRUE\n");
  else
    printf("\toldmode\t\t: FALSE\n");
  printf("\tres\t\t: %ld\n",_IOID.res);
  printf("\terrno\t\t: %d\n",_IOID.errno);
  if (_IOID.iowait)
    printf("\tiowait\t\t: TRUE\n");
  else
    printf("\tiowait\t\t: FALSE\n");
  if (_IOID.mixio)
    printf("\tmixio\t\t: TRUE\n");
  else
    printf("\tmixio\t\t: FALSE\n");
  switch (_IOID.op)
  {
  case READ_OP:
    printf("\top\t\t: READ_OP\n");
    break;
  case READV_OP:
    printf("\top\t\t: READV_OP\n");
    break;
  case WRITE_OP:
    printf("\top\t\t: WRITE_OP\n");
    break;
  case WRITEV_OP:
    printf("\top\t\t: WRITEV_OP\n");
    break;
  default:
    printf("\top\t\t: UNKOWN\n");
    break;
  }
  printf("\toffset\t\t: %ld\n",_IOID.offset);
  printf("\tiolen\t\t: %ld\n",_IOID.iolen);
  if (_IOID.transp == NULL)
    printf("\ttarnsp\t\t: NULL\n");
  else
    printf("\ttransp\t\t: SET\n");
}

/* ************************************************************************* *
 * Print client table element                                                *
 * ************************************************************************* */
void prt_clnttabelem
#ifdef ANSI_C
(int _ftix, int _ctix, bool_t verbose)
#else  /* ANSI_C */
(_ftix, _ctix, verbose)
int _ftix;
int _ctix;
bool_t verbose;
#endif /* ANSI_C */
{  
  int _ioID;
  
  printf("FILETABLE ELEMENT %d CLIENTTABLE ELEMENT %d\n",_ftix, _ctix);

  if (_CLNT.access)
    printf("\taccess\t\t: TRUE\n");
  else
    printf("\taccess\t\t: FALSE\n");
  if (_CLNT.access || verbose)
  {
    printf("\thname\t\t: %s\n",_CLNT.ident.hname);
    printf("\tipaddr\t\t: %s\n",_CLNT.ident.ipaddr);
    printf("\tpid\t\t: %d\n",_CLNT.ident.pid);
    printf("\tuid\t\t: %d\n",_CLNT.ident.uid);
    printf("\tgid\t\t: %d\n",_CLNT.ident.gid);
    printf("\taup\t\t: %ld\n",_CLNT.ident.aup_time);
    printf("\tfoffs\t\t: %ld\n",_CLNT.foffs);
    printf("\tendoffs\t\t: %ld\n",_CLNT.endoffs);
    if (_CLNT.syncdone)
      printf("\tsyncdone\t: TRUE\n");
    else
      printf("\tsyncdone\t: FALSE\n");
    if (_CLNT.syncok)
      printf("\tsyncok\t\t: TRUE\n");
    else
      printf("\tsyncok\t\t: FALSE\n");
    printf("\tsyncerr\t\t: %d\n",_CLNT.syncerr);
    if (_CLNT.transp == NULL)
      printf("\ttransp\t\t: NULL\n");
    else
      printf("\ttransp\t\t: SET\n");
    printf("\tioseq\t\t: %ld\n",_CLNT.ioseq);
  
    for (_ioID=0; _ioID < MAXIOID; _ioID++)
    {
      if ((_IOID.state != ID_UNUSED) || verbose)
        prt_idtabelem(_ftix,_ctix,_ioID);
    }
  }
  return;
}

/* ************************************************************************* *
 * Print file table element                                                  *
 * ************************************************************************* */
void prt_filetabelem
#ifdef ANSI_C
(int _ftix, bool_t verbose)
#else  /* ANSI_C */
(_ftix, verbose)
int _ftix;
bool_t verbose;
#endif /* ANSI_C */
{
  int _ctix;

  printf("FILETABLE ELEMENT %d\n",_ftix);
  printf("\toflags\t\t: %0o\n",_CFTE.oflags);
  printf("\tpermission\t: %o\n",(int)_CFTE.permission);
  printf("\tuid\t\t: %d\n",(int)_CFTE.uid);
  printf("\tgid\t\t: %d\n",(int)_CFTE.gid);
  printf("\tfilename\t: %s\n",_CFTE.filename);
  switch(_CFTE.mode)
  {
  case M_UNIX:
    printf("\tmode\t\t: M_UNIX\n");
    break;
  case M_LOG:
    printf("\tmode\t\t: M_LOG\n");
    break;
  case M_RECORD:
    printf("\tmode\t\t: M_RECORD\n");
    break;
  case M_SYNC:
    printf("\tmode\t\t: M_SYNC\n");
    break;
  case M_GLOBAL:
    printf("\tmode\t\t: M_GLOBAL\n");
    break;
  default:
    printf("\tmode\t\t: UNKOWN MODE\n");
    break;
  }
  switch(_CFTE.rqmode)
  {
  case M_UNIX:
    printf("\trqmode\t\t: M_UNIX\n");
    break;
  case M_LOG:
    printf("\trqmode\t\t: M_LOG\n");
    break;
  case M_RECORD:
    printf("\trqmode\t\t: M_RECORD\n");
    break;
  case M_SYNC:
    printf("\trqmode\t\t: M_SYNC\n");
    break;
  case M_GLOBAL:
    printf("\trqmode\t\t: M_GLOBAL\n");
    break;
  default:
    printf("\trqmode\t\t: UNKOWN MODE\n");
    break;
  }
  printf("\tshoffs\t\t: %ld\n",_CFTE.shoffs);
  printf("\tendoffs\t\t: %ld\n",_CFTE.endoffs);
  printf("\tnow_many\t: %d\n",_CFTE.how_many);
  printf("\tactual\t\t: %d\n",_CFTE.actual);
  switch (_CFTE.sync)
  {
  case PFSD_SYNC_NONE:
    printf("\tsync\t\t: PFSD_SYNC_NONE\n");
    break;
  case PFSD_SYNC_OPEN:
    printf("\tsync\t\t: PFSD_SYNC_OPEN\n");
    break;
  case PFSD_SYNC_CLOSE:
    printf("\tsync\t\t: PFSD_SYNC_CLOSE\n");
    break;
  case PFSD_SYNC_SETIOMODE:
    printf("\tsync\t\t: PFSD_SYNC_SETIOMODE\n");
    break;
  case PFSD_SYNC_LSEEK:
    printf("\tsync\t\t: PFSD_SYNC_LSEEK\n");
    break;
  default:
    printf("\tsync\t\t: UNKNOWN SYNC\n");
    break;
  }
  
  if (_CFTE.distd == NULL)
    printf("\tdistd\t: NULL\n");
  else
    _dist_prt(_ftix);

  if (_CFTE.cltab == NULL)
    printf("\tcltab\t: NULL\n");
  else
  {
    for (_ctix = 0; _ctix < _CFTE.how_many; _ctix++)
      prt_clnttabelem(_ftix,_ctix,verbose);
  }  
  return;
}


/* ************************************************************************* *
 * Print file table                                                          *
 * ************************************************************************* */
void prt_filetable
#ifdef ANSI_C
(char *filename, bool_t verbose)
#else  /* ANSI_C */
(filename, verbose)
char *filename;
bool_t verbose;
#endif /* ANSI_C */
{
  int _ftix;

  for (_ftix = 0; _ftix < MAXNUMFILES; _ftix++)
  {
    if (((filename[0] == '\0') && ((_CFTE.actual > 0) || verbose)) ||
        ((strcmp(_CFTE.filename,filename) == 0) && (_CFTE.actual > 0)))
      prt_filetabelem(_ftix,verbose);
  }
  
  return;
}



/* ************************************************************************* *
 * RPC procedure to print internal status information                        *
 * ************************************************************************* */
void *pfsd_prtstat_1 
#ifdef ANSI_C
(prtstatargs *argp, struct svc_req *rqstp)
#else  /* ANSI_C */
(argp, rqstp)
prtstatargs *argp;
struct svc_req *rqstp;
#endif /* ANSI_C */
{
  static int result;
  
  printf("##############################################################################\n");
  printf("STATE of pfsd\n");

#ifdef TIMING
  print_timing();
#endif /* TIMING */

  prt_filetable(argp->fname,argp->verbose);
  
  printf("\n");

  if (argp->iods)
    _iod_prtlist();

  return ((void *)&result);
}
