/* ************************************************************************* *
 *                                                                           *
 *    pfsd_lsize.c,v
 *    pfsd procedures to change the size of a PFSlib file
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : pfsd_lsize.c,v
 *  RCS Date     : 1996/05/29 15:36:54
 *  RCS Revision : 1.2
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts, Christian R"oder                               *
 *                                                                           *
 * ************************************************************************* */
#ifndef lint
static void *rcs_id = "pfsd_lsize.c,v 1.2 1996/05/29 15:36:54 lamberts V2_0_B";
#endif

/* ************************************************************************* *
 * Include files                                                             *
 * ************************************************************************* */

#include <rpc/rpc.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>

#include "pfsd.h"
#include "pfsd_defines.h"
#include "pfsd_macros.h"
#include "pfslib_errno.h"

/* ************************************************************************* *
 * External declarations                                                     *
 * ************************************************************************* */

extern filetabel *_cftbl;

#ifdef ANSI_C
#define _PH(a) a
#else  /* ANSI_C */
#define _PH(a) ()
#endif /* ANSI_C */

extern int _checkfh _PH((pfslib_fhdl fh, struct svc_req *rqstp));

#undef _PH

/* ************************************************************************* *
 * Procedures                                                                *
 * ************************************************************************* */

/* ************************************************************************* *
 * Increase the size of a file                                               *
 * ************************************************************************* */
lsizeres *pfsd_lsize_1
#ifdef ANSI_C
(fpmoveargs *argp, struct svc_req *rqstp)
#else  /* ANSI_C */
(argp, rqstp)
fpmoveargs *argp;
struct svc_req *rqstp;
#endif /* ANSI_C */
{

  static lsizeres  result;

  int _ftix = argp->fh.vfd;     /* File table index */
  int _ctix = argp->fh.which;
  
  off_t length;

  /* check pfslib_fhdl */

  if (_checkfh(argp->fh,rqstp) < 0)
  {
    ERR_MACRO(lsizeres_u,errno);
    return (&result);
  }

  /* This call is never synchronizing */
  switch (argp->whence )
  {
  case SIZE_SET:
    length = argp->offset;
    break;
  case SIZE_CUR:
    switch (_CFTE.mode)
    {
    case M_UNIX:
    case M_RECORD:
      length = _CLNT.foffs + argp->offset;
      break;
    case M_LOG:
    case M_SYNC:
    case M_GLOBAL:
      length = _CFTE.shoffs + argp->offset;
      break;
    default:
      /* LAMBO Fehler */
      break;
    }
    break;
  case SIZE_END:
    length = _CFTE.endoffs + argp->offset;
    break;
  default:
    ERR_MACRO(lsizeres_u,EPFSLINVAL);
    return (&result);
  }

  /* lsize has no effect at all use lseek to increase a distributed file */

  if ( length > _CFTE.endoffs )
  {
    result.stat = RPC_OK;
    result.lsizeres_u.size = length;
  }
  else
  {
    result.stat = RPC_OK;
    result.lsizeres_u.size = _CFTE.endoffs;
  }

  return(&result);
}
