/* ************************************************************************* *
 *                                                                           *
 *    pfsd_ioopdone.c,v
 *    pfsd procedures to register the termination of an IO operation
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : pfsd_ioopdone.c,v
 *  RCS Date     : 1996/05/29 15:36:51
 *  RCS Revision : 1.2
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts, Christian R"oder                               *
 *                                                                           *
 * ************************************************************************* */
#ifndef lint
static void *rcs_id = "pfsd_ioopdone.c,v 1.2 1996/05/29 15:36:51 lamberts V2_0_B";
#endif

/* ************************************************************************* *
 * Include files                                                             *
 * ************************************************************************* */

#include <rpc/rpc.h>
#include <errno.h>

#include "pfsd.h"
#include "pfsd_defines.h"
#include "pfsd_macros.h"
#include "pfslib_errno.h"

/* ************************************************************************* *
 * External declarations                                                     *
 * ************************************************************************* */

extern filetabel *_cftbl;

#ifdef ANSI_C
#define _PH(a) a
#else  /* ANSI_C */
#define _PH(a) ()
#endif /* ANSI_C */

extern int  _checkfh      _PH((pfslib_fhdl fh, struct svc_req *rqstp));
extern void _iowait_reply _PH((int _ftix, int _ctix, int _ioID));

#undef _PH

/* ************************************************************************* *
 * Procedures                                                                *
 * ************************************************************************* */

/* ************************************************************************* *
 * Receive information the termination of an IO operation.                   *
 * ************************************************************************* */
errorres *pfsd_ioopdone_1
#ifdef ANSI_C
(ioopdoneargs *argp, struct svc_req *rqstp)
#else  /* ANSI_C */
(argp, rqstp)
ioopdoneargs *argp;
struct svc_req *rqstp;
#endif /* ANSI_C */
{
  static errorres result;

  int _ftix = argp->fh.vfd;     /* File table index */
  int _ctix = argp->fh.which;   /* Client table index */
  int _ioID = argp->ioID;       /* Id table index */

  if (_checkfh(argp->fh,rqstp) < 0 )
  {
    ERR_MACRO(errorres_u, errno);
    return (&result);
  }

  /*
   * check the rest of the input arguments
   */

  if ((_ioID < 0) || ( _ioID >= MAXIOID ) || 
      (_IOID.state != ID_DISTDONE))
  {
    ERR_MACRO(errorres_u, EPFSLBADID);
    return(&result);
  }

  _IOID.state = ID_DONE;
  if  ((_IOID.mode == M_GLOBAL) &&
       ((_IOID.op == WRITE_OP) || (_IOID.op == WRITEV_OP)) &&
       argp->res == 0)
    _IOID.res = _IOID.iolen;
  else
    _IOID.res   = argp->res;

  _IOID.errno = argp->errno;

  if (_IOID.iowait)
    _iowait_reply(_ftix, _ctix, _ioID);

  result.stat = RPC_OK;

  return(&result);                 /* No reply needed */
}
